<?php

if ( ! function_exists( 'manufaktursolutions_core_add_author_info_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function manufaktursolutions_core_add_author_info_widget( $widgets ) {
		$widgets[] = 'ManufakturSolutionsCore_Author_Info_Widget';

		return $widgets;
	}

	add_filter( 'manufaktursolutions_core_filter_register_widgets', 'manufaktursolutions_core_add_author_info_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class ManufakturSolutionsCore_Author_Info_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$this->set_base( 'manufaktursolutions_core_author_info' );
			$this->set_name( esc_html__( 'ManufakturSolutions Author Info', 'manufaktursolutions-core' ) );
			$this->set_description( esc_html__( 'Add author info element into widget areas', 'manufaktursolutions-core' ) );
			$this->set_widget_option(
				array(
					'field_type' => 'text',
					'name'       => 'author_username',
					'title'      => esc_html__( 'Author Username', 'manufaktursolutions-core' ),
				)
			);
			$this->set_widget_option(
				array(
					'field_type' => 'color',
					'name'       => 'author_color',
					'title'      => esc_html__( 'Author Color', 'manufaktursolutions-core' ),
				)
			);
		}

		public function render( $atts ) {
			$author_id = 1;
			if ( ! empty( $atts['author_username'] ) ) {
				$author = get_user_by( 'login', $atts['author_username'] );

				if ( ! empty( $author ) ) {
					$author_id = $author->ID;
				}
			}

			$author_link = get_author_posts_url( $author_id );
			$author_bio  = get_the_author_meta( 'description', $author_id );
			$user_additional_information = get_the_author_meta('qodef_user_additional_information', $author_id);
			?>
			<div class="widget qodef-author-info">
				<a itemprop="url" class="qodef-author-info-image" href="<?php echo esc_url( $author_link ); ?>">
					<?php echo get_avatar( $author_id, 138 ); ?>
				</a>

				<?php if ( ! empty( $author_bio ) ) { ?>
					<h4 class="qodef-author-info-name vcard author">
						<a itemprop="url" href="<?php echo esc_url( $author_link ); ?>">
							<span class="fn"><?php echo esc_html( get_the_author_meta( 'display_name', $author_id ) ); ?></span>
						</a>
					</h4>
					<p itemprop="description" class="qodef-author-info-description"><?php echo esc_html( $author_bio ); ?></p>
				<?php } ?>
                <?php if (!empty ($user_additional_information)) { ?>
                    <p itemprop="additional-info"
                       class="qodef-author-additional-information"><?php echo wp_kses_post($user_additional_information); ?></p>
                <?php } ?>
			</div>
			<?php
		}
	}
}
