<?php

if ( ! function_exists( 'manufaktursolutions_core_add_social_share_variation_list' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function manufaktursolutions_core_add_social_share_variation_list( $variations ) {
		$variations['list'] = esc_html__( 'List', 'manufaktursolutions-core' );

		return $variations;
	}

	add_filter( 'manufaktursolutions_core_filter_social_share_layouts', 'manufaktursolutions_core_add_social_share_variation_list' );
	add_filter( 'manufaktursolutions_core_filter_social_share_layout_options', 'manufaktursolutions_core_add_social_share_variation_list' );
}

if ( ! function_exists( 'manufaktursolutions_core_set_default_social_share_variation_list' ) ) {
	/**
	 * Function that set default variation layout for this module
	 *
	 * @return string
	 */
	function manufaktursolutions_core_set_default_social_share_variation_list() {
		return 'list';
	}

	add_filter( 'manufaktursolutions_core_filter_social_share_layout_default_value', 'manufaktursolutions_core_set_default_social_share_variation_list' );
}
