<?php

if (!function_exists('manufaktursolutions_core_add_section_title_shortcode')) {
    /**
     * Function that add shortcode into shortcodes list for registration
     *
     * @param array $shortcodes
     *
     * @return array
     */
    function manufaktursolutions_core_add_section_title_shortcode($shortcodes)
    {
        $shortcodes[] = 'ManufakturSolutionsCore_Section_Title_Shortcode';

        return $shortcodes;
    }

    add_filter('manufaktursolutions_core_filter_register_shortcodes', 'manufaktursolutions_core_add_section_title_shortcode');
}

if (class_exists('ManufakturSolutionsCore_Shortcode')) {
    class ManufakturSolutionsCore_Section_Title_Shortcode extends ManufakturSolutionsCore_Shortcode
    {

        public function map_shortcode()
        {
            $this->set_shortcode_path(MANUFAKTURSOLUTIONS_CORE_SHORTCODES_URL_PATH . '/section-title');
            $this->set_base('manufaktursolutions_core_section_title');
            $this->set_name(esc_html__('Section Title', 'manufaktursolutions-core'));
            $this->set_description(esc_html__('Shortcode that adds section title element', 'manufaktursolutions-core'));
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name' => 'custom_class',
                    'title' => esc_html__('Custom Class', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name' => 'title',
                    'title' => esc_html__('Title', 'manufaktursolutions-core'),
                    'default_value' => esc_html__('Title Text', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name' => 'line_break_positions',
                    'title' => esc_html__('Positions of Line Break', 'manufaktursolutions-core'),
                    'description' => esc_html__('Enter the positions of the words after which you would like to create a line break. Separate the positions with commas (e.g. if you would like the first, third, and fourth word to have a line break, you would enter "1,3,4")', 'manufaktursolutions-core'),
                    'group' => esc_html__('Title Style', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'select',
                    'name' => 'disable_title_break_words',
                    'title' => esc_html__('Disable Title Line Break', 'manufaktursolutions-core'),
                    'description' => esc_html__('Enabling this option will disable title line breaks for screen size 1024 and lower', 'manufaktursolutions-core'),
                    'options' => manufaktursolutions_core_get_select_type_options_pool('no_yes', false),
                    'default_value' => 'no',
                    'group' => esc_html__('Title Style', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name' => 'title_highlight_words',
                    'title' => esc_html__('Words with Highlights Color', 'manufaktursolutions-core'),
                    'description' => esc_html__('Enter the positions of the words you would like to display in a "highlights" color. Separate the positions with commas (e.g. if you would like the first, second, and third word to have a highlights color, you would enter "1,2,3")', 'manufaktursolutions-core'),
                    'group' => esc_html__('Title Style', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'select',
                    'name' => 'title_tag',
                    'title' => esc_html__('Title Tag', 'manufaktursolutions-core'),
                    'options' => manufaktursolutions_core_get_select_type_options_pool('title_tag'),
                    'default_value' => 'h2',
                    'group' => esc_html__('Title Style', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name' => 'title_color',
                    'title' => esc_html__('Title Color', 'manufaktursolutions-core'),
                    'group' => esc_html__('Title Style', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name' => 'link',
                    'title' => esc_html__('Title Custom Link', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'select',
                    'name' => 'target',
                    'title' => esc_html__('Custom Link Target', 'manufaktursolutions-core'),
                    'options' => manufaktursolutions_core_get_select_type_options_pool('link_target'),
                    'default_value' => '_self',
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name' => 'subtitle',
                    'title' => esc_html__('Subtitle Text', 'manufaktursolutions-core'),
                    'default_value' => esc_html__('Subtitle Text', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name' => 'subtitle_color',
                    'title' => esc_html__('Subtitle Color', 'manufaktursolutions-core'),
                    'group' => esc_html__('Subtitle Style', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name' => 'highlight_text',
                    'title' => esc_html__('Highlight Text', 'manufaktursolutions-core'),
                    'default_value' => esc_html__('Highlight Text', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name' => 'highlight_text_color',
                    'title' => esc_html__('Subtitle Color', 'manufaktursolutions-core'),
                    'group' => esc_html__('Highlight Style', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name' => 'highlight_text_margin_bottom',
                    'title' => esc_html__('Highlight Text Margin Bottom', 'manufaktursolutions-core'),
                    'group' => esc_html__('Highlight Style', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'textarea',
                    'name' => 'text',
                    'title' => esc_html__('Text', 'manufaktursolutions-core'),
                    'default_value' => esc_html__('Contrary to popular belief, Lorem Ipsum is not simply random text.', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name' => 'text_color',
                    'title' => esc_html__('Text Color', 'manufaktursolutions-core'),
                    'group' => esc_html__('Text Style', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name' => 'text_margin_top',
                    'title' => esc_html__('Text Margin Top', 'manufaktursolutions-core'),
                    'group' => esc_html__('Text Style', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'select',
                    'name' => 'content_alignment',
                    'title' => esc_html__('Content Alignment', 'manufaktursolutions-core'),
                    'options' => array(
                        '' => esc_html__('Default', 'manufaktursolutions-core'),
                        'left' => esc_html__('Left', 'manufaktursolutions-core'),
                        'center' => esc_html__('Center', 'manufaktursolutions-core'),
                        'right' => esc_html__('Right', 'manufaktursolutions-core'),
                    ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'select',
                    'name' => 'inverse_color',
                    'title' => esc_html__('Inverse Title Color', 'manufaktursolutions-core'),
                    'options' => manufaktursolutions_core_get_select_type_options_pool('no_yes'),
                    'default_value' => 'no',
                )
            );
             $this->set_option(
                array(
                    'field_type' => 'select',
                    'name' => 'disable_inverse_color',
                    'title' => esc_html__('Disable Inverse Title Color On Mobile', 'manufaktursolutions-core'),
                    'options' => manufaktursolutions_core_get_select_type_options_pool('no_yes'),
                    'default_value' => 'no',
                )
            );
        }

        public function render($options, $content = null)
        {
            parent::render($options);
            $atts = $this->get_atts();

            $atts['holder_classes'] = $this->get_holder_classes($atts);
            $atts['title'] = $this->get_modified_title($atts);
            $atts['title_styles'] = $this->get_title_styles($atts);
            $atts['subtitle_styles'] = $this->get_subtitle_styles($atts);
            $atts['highlight_text_styles'] = $this->get_highlight_text_styles($atts);
            $atts['text_styles'] = $this->get_text_styles($atts);

            return manufaktursolutions_core_get_template_part('shortcodes/section-title', 'templates/section-title', '', $atts);
        }

        private function get_holder_classes($atts)
        {
            $holder_classes = $this->init_holder_classes();

            $holder_classes[] = 'qodef-section-title';
            $holder_classes[] = !empty($atts['content_alignment']) ? 'qodef-alignment--' . $atts['content_alignment'] : 'qodef-alignment--left';
            $holder_classes[] = 'yes' === $atts['disable_title_break_words'] ? 'qodef-title-break--disabled' : '';
            $holder_classes[] = 'yes' === $atts['inverse_color'] ? 'qodef-title-inverse-color--yes' : '';
            $holder_classes[] = 'yes' === $atts['disable_inverse_color'] ? 'qodef-title-disable-inverse-color-mobile--yes' : '';

            return implode(' ', $holder_classes);
        }

        private function get_modified_title($atts)
        {
            $title = $atts['title'];
            $title_highlight_words = str_replace(' ', '', $atts['title_highlight_words']);

            if (!empty($title)) {
                $split_title = explode(' ', $title);
                $line_break_positions = explode(',', str_replace(' ', '', $atts['line_break_positions']));
                $highlights_words = explode(',', $title_highlight_words);

                if (!empty($atts['line_break_positions'])) {
                    foreach ($line_break_positions as $position) {
                        $position = intval($position);
                        if (isset($split_title[$position - 1]) && !empty($split_title[$position - 1])) {
                            $split_title[$position - 1] = $split_title[$position - 1] . '<br />';
                        }
                    }
                }
                if (!empty($title_highlight_words)) {
                    foreach ($highlights_words as $value) {
                        $value = intval($value);
                        if (!empty($split_title[$value - 1])) {
                            $split_title[$value - 1] = '<span class="qodef-highlight-title">' . $split_title[$value - 1] . '</span>';
                        }
                    }
                }


                $title = implode(' ', $split_title);
            }

            return $title;
        }

        private function get_title_styles($atts)
        {
            $styles = array();

            if (!empty($atts['title_color'])) {
                $styles[] = 'color: ' . $atts['title_color'];
            }

            return $styles;
        }

        private function get_subtitle_styles($atts)
        {
            $styles = array();

            if (!empty($atts['subtitle_color'])) {
                $styles[] = 'color: ' . $atts['subtitle_color'];
            }

            return $styles;
        }

        private function get_highlight_text_styles($atts)
        {
            $styles = array();

            if (!empty($atts['highlight_text_color'])) {
                $styles[] = 'color: ' . $atts['highlight_text_color'];
            }
            if ('' !== $atts['highlight_text_margin_bottom']) {
                if (qode_framework_string_ends_with_space_units($atts['highlight_text_margin_bottom'])) {
                    $styles[] = 'margin-bottom: ' . $atts['highlight_text_margin_bottom'];
                } else {
                    $styles[] = 'margin-bottom: ' . intval($atts['highlight_text_margin_bottom']) . 'px';
                }
            }

            return $styles;
        }

        private function get_text_styles($atts)
        {
            $styles = array();

            if ('' !== $atts['text_margin_top']) {
                if (qode_framework_string_ends_with_space_units($atts['text_margin_top'])) {
                    $styles[] = 'margin-top: ' . $atts['text_margin_top'];
                } else {
                    $styles[] = 'margin-top: ' . intval($atts['text_margin_top']) . 'px';
                }
            }

            if (!empty($atts['text_color'])) {
                $styles[] = 'color: ' . $atts['text_color'];
            }

            return $styles;
        }
    }
}
