<?php

if ( ! function_exists( 'manufaktursolutions_core_add_graphs_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function manufaktursolutions_core_add_graphs_shortcode( $shortcodes ) {
		$shortcodes[] = 'ManufakturSolutionsCore_Graphs_Shortcode';

		return $shortcodes;
	}

	add_filter( 'manufaktursolutions_core_filter_register_shortcodes', 'manufaktursolutions_core_add_graphs_shortcode' );
}

if ( class_exists( 'ManufakturSolutionsCore_Shortcode' ) ) {
	class ManufakturSolutionsCore_Graphs_Shortcode extends ManufakturSolutionsCore_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( MANUFAKTURSOLUTIONS_CORE_SHORTCODES_URL_PATH . '/graphs' );
			$this->set_base( 'manufaktursolutions_core_graphs' );
			$this->set_name( esc_html__( 'Graphs', 'manufaktursolutions-core' ) );
			$this->set_description( esc_html__( 'Shortcode that displays graphs with provided parameters', 'manufaktursolutions-core' ) );
			$this->set_scripts(
				array(
					'chart' => array(
						'registered' => false,
						'url'        => MANUFAKTURSOLUTIONS_CORE_ASSETS_URL_PATH . '/plugins/charts/Chart.min.js',
						'dependency' => array( 'jquery' ),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'manufaktursolutions-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'repeater',
					'name'       => 'children',
					'title'      => esc_html__( 'Datasets', 'manufaktursolutions-core' ),
					'items'      => array(
						array(
							'field_type'    => 'text',
							'name'          => 'item_dataset_values',
							'title'         => esc_html__( 'Dataset Values', 'manufaktursolutions-core' ),
							'dynamic'       => false,
							'default_value' => '30,20,30,80,20',
						),
						array(
							'field_type'    => 'text',
							'name'          => 'item_dataset_labels',
							'title'         => esc_html__( 'Dataset Labels', 'manufaktursolutions-core' ),
							'default_value' => esc_html__( 'Label', 'manufaktursolutions-core' ),
						),
						array(
							'field_type'    => 'color',
							'name'          => 'item_border_color',
							'title'         => esc_html__( 'Line Color', 'manufaktursolutions-core' ),
							'default_value' => '#14203b',
						),
						array(
							'field_type'    => 'color',
							'name'          => 'item_hover_border_color',
							'title'         => esc_html__( 'Hover Line Color', 'manufaktursolutions-core' ),
							'description'   => esc_html__( 'Only for bar graphs', 'manufaktursolutions-core' ),
							'default_value' => '#0f182d',
						),
						array(
							'field_type'  => 'text',
							'name'        => 'item_fill_area',
							'title'       => esc_html__( 'Filling Modes', 'manufaktursolutions-core' ),
							'dynamic'     => false,
							'description' => esc_html__( 'Only for line graphs. Ex. values: origin, -1, -2, +1, +2 ...', 'manufaktursolutions-core' ),
						),
						array(
							'field_type'    => 'color',
							'name'          => 'item_background_color',
							'title'         => esc_html__( 'Area Color', 'manufaktursolutions-core' ),
							'default_value' => '#14203b',
						),
						array(
							'field_type'    => 'color',
							'name'          => 'item_hover_background_color',
							'title'         => esc_html__( 'Hover Area Color', 'manufaktursolutions-core' ),
							'description'   => esc_html__( 'Only for bar graphs', 'manufaktursolutions-core' ),
							'default_value' => '#0f182d',
						),
						array(
							'field_type'    => 'select',
							'name'          => 'item_linear',
							'title'         => esc_html__( 'Enable Linear Mode', 'manufaktursolutions-core' ),
							'options'       => manufaktursolutions_core_get_select_type_options_pool( 'no_yes', false ),
							'default_value' => 'no',
							'description'   => esc_html__( 'Only for line graphs', 'manufaktursolutions-core' ),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'textarea',
					'name'          => 'data_labels',
					'title'         => esc_html__( 'Data Labels', 'manufaktursolutions-core' ),
					'default_value' => esc_html__( '1 month, 3 months, 6 months, 12 months, 24 months', 'manufaktursolutions-core' ),
					'description'   => esc_html__( 'Separate labels with commas', 'manufaktursolutions-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'chart_type',
					'title'      => esc_html__( 'Graph Type', 'manufaktursolutions-core' ),
					'options'    => array(
						'line' => esc_html__( 'Line', 'manufaktursolutions-core' ),
						'bar'  => esc_html__( 'Bar', 'manufaktursolutions-core' ),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'enable_chart_legend',
					'title'      => esc_html__( 'Enable Chart Legend', 'manufaktursolutions-core' ),
					'options'    => manufaktursolutions_core_get_select_type_options_pool( 'yes_no', false ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'color',
					'name'          => 'legend_and_label_color',
					'title'         => esc_html__( 'Legend And Label Color', 'manufaktursolutions-core' ),
					'default_value' => '#14203b',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'color',
					'name'          => 'grid_color',
					'title'         => esc_html__( 'Grid Color', 'manufaktursolutions-core' ),
					'default_value' => '#14203b',
				)
			);
		}

		public function load_assets() {
			wp_enqueue_script( 'chart' );
		}

		public static function call_shortcode( $params ) {
			$html = qode_framework_call_shortcode( 'manufaktursolutions_core_graphs', $params );
			$html = str_replace( "\n", '', $html );

			return $html;
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes']      = $this->get_holder_classes( $atts );
			$atts['items']               = $this->parse_repeater_items( $atts['children'] );
			$atts['data_attrs']          = $this->get_data_attrs( $atts['items'], $atts );
			$atts['legend_label_styles'] = $this->get_legend_label_styles( $atts );

			return manufaktursolutions_core_get_template_part( 'shortcodes/graphs', 'templates/graphs', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-graphs';
			$holder_classes[] = ! empty( $atts['chart_alignment'] ) ? 'qodef-chart-alignment--' . $atts['chart_alignment'] : '';

			return implode( ' ', $holder_classes );
		}

		private function get_data_attrs( $items, $atts ) {
			$data = array();
			$temp = array();

			foreach ( $items as $key => $value ) {
				$temp['data-values'][]                  = ! empty( $value['item_dataset_values'] ) ? $value['item_dataset_values'] : 0;
				$temp['data-item-labels'][]             = ! empty( $value['item_dataset_labels'] ) ? $value['item_dataset_labels'] : '';
				$temp['data-background-colors'][]       = ! empty( $value['item_background_color'] ) ? $value['item_background_color'] : '#14203b';
				$temp['data-hover-background-colors'][] = ! empty( $value['item_hover_background_color'] ) ? $value['item_hover_background_color'] : '#0f182d';
				$temp['data-border-colors'][]           = ! empty( $value['item_border_color'] ) ? $value['item_border_color'] : '#14203b';
				$temp['data-hover-border-colors'][]     = ! empty( $value['item_hover_border_color'] ) ? $value['item_hover_border_color'] : '#0f182d';
				$temp['data-fill'][]                    = ! empty( $value['item_fill_area'] ) ? $value['item_fill_area'] : false;
				$temp['data-linear'][]                  = ( 'yes' === $value['item_linear'] ) ? 0 : 0.4;
			}

			$temp['data-labels']        = ! empty( $atts['data_labels'] ) ? explode( ',', $atts['data_labels'] ) : '';
			$temp['data-grid-color']    = ! empty( $atts['grid_color'] ) ? $atts['grid_color'] : '#14203b';
			$temp['data-label-color']   = ! empty( $atts['legend_and_label_color'] ) ? $atts['legend_and_label_color'] : '#14203b';
			$temp['data-type']          = 'line' === $atts['chart_type'];
			$temp['data-enable-legend'] = ( 'yes' === $atts['enable_chart_legend'] ) ? true : false;

			foreach ( $temp as $key => $value ) {
				if ( is_array( $value ) || is_bool( $value ) ) {
					$data[ $key ] = json_encode( $value );
				} else {
					$data[ $key ] = $value;
				}
			}

			return $data;
		}

		public function get_legend_label_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['legend_and_label_color'] ) ) {
				$styles[] = 'color: ' . $atts['legend_and_label_color'];
			}

			return $styles;
		}
	}
}
