(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.manufaktursolutions_core_graphs = {};

	$( document ).ready(
		function () {
			qodefGraphs.init();
		}
	);

	/**
	 * Init graphs shortcode functionality
	 */
	var qodefGraphs = {
		init: function () {
			this.holder = $( '.qodef-graphs' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						qodefGraphs.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			qodefCore.qodefIsInViewport.check(
				$currentItem,
				function () {
					$currentItem.addClass( 'qodef--init' );

					var ctx = $currentItem.find( 'canvas' );

					var data = qodefGraphs.generateChartData(
						$currentItem,
						ctx
					);

					Chart.defaults.font.weight = 400;
					Chart.defaults.font.family = 'Lato';

					var chart = new Chart(
						ctx,
						data
					);
				}
			);
		},
		generateChartData: function ( thisChart, ctx ) {
			var type = thisChart.data( 'type' );
			if ( type ) {
				type = 'line';
			} else {
				type = 'bar';
			}
			var fill                  = thisChart.data( 'fill' );
			var linear                = thisChart.data( 'linear' );
			var values                = thisChart.data( 'values' );
			var item_labels           = thisChart.data( 'item-labels' );
			var labels                = thisChart.data( 'labels' );
			var backgroundColors      = thisChart.data( 'background-colors' );
			var hoverBackgroundColors = thisChart.data( 'hover-background-colors' );
			var borderColors          = thisChart.data( 'border-colors' );
			var hoverBorderColors     = thisChart.data( 'hover-border-colors' );
			var gridColor             = thisChart.data( 'grid-color' );
			var labelColor            = thisChart.data( 'label-color' );

			var datasets = [];

			values.forEach(
				function ( item, index ) {
					var dataset_item = {};

					dataset_item.data                 = values[index].split( ',' );
					dataset_item.label                = item_labels[index];
					dataset_item.backgroundColor      = backgroundColors[index];
					dataset_item.hoverBackgroundColor = hoverBackgroundColors[index];
					dataset_item.borderColor          = borderColors[index];
					dataset_item.hoverBorderColor     = hoverBorderColors[index];

					dataset_item.pointBackgroundColor      = borderColors[index];
					dataset_item.pointHoverBackgroundColor = hoverBorderColors[index];
					dataset_item.pointBorderColor          = backgroundColors[index];
					dataset_item.pointHoverBorderColor     = hoverBackgroundColors[index];

					dataset_item.pointStyle       = 'circle';
					dataset_item.pointRadius      = 6;
					dataset_item.pointHoverRadius = 6;
					// dataset_item.pointBorderWidth = 14;
					// dataset_item.hoverBorderWidth = 14;

					dataset_item.cubicInterpolationMode = 'default';
					dataset_item.fill                   = fill[index];
					dataset_item.tension                = linear[index];

					datasets.push( dataset_item );
				}
			);

			var aspectRatio = 2.4;
			if ( qodefCore.html.hasClass( 'touchevents' ) ) {
				aspectRatio = 1.5;
			}

			var data_temp = {
				type: type,
				data: {
					labels: labels,
					datasets: datasets
				},
				options: {
					responsive: true,
					aspectRatio: aspectRatio,
					hover: {
						mode: 'nearest',
						intersect: true
					},
					plugins: {
						legend: {
							display: false,
						},
						tooltip: {
							mode: 'nearest',
							intersect: false,
							displayColors: false,
							cornerRadius: 5,
							caretSize: 6,
						},
					},
					scales: {
						x: {
							display: true,
							scaleLabel: {
								display: true,
							},
							ticks: {
								color: labelColor,
								padding: 10,
							},
							grid: {
								color: gridColor,
							}
						},
						y: {
							display: true,
							scaleLabel: {
								display: false,
							},
							ticks: {
								color: labelColor,
								padding: 10,
							},
							grid: {
								color: gridColor,
							}
						}
					}
				}
			};

			return data_temp;
		},
	};

	qodefCore.shortcodes.manufaktursolutions_core_graphs.qodefGraphs = qodefGraphs;

})( jQuery );
