<?php

if ( ! function_exists( 'manufaktursolutions_core_add_standard_header_options' ) ) {
	/**
	 * Function that add additional header layout options
	 *
	 * @param object $page
	 * @param array $general_header_tab
	 */
	function manufaktursolutions_core_add_standard_header_options( $page, $general_header_tab ) {

		$section = $general_header_tab->add_section_element(
			array(
				'name'        => 'qodef_standard_header_section',
				'title'       => esc_html__( 'Standard Header', 'manufaktursolutions-core' ),
				'description' => esc_html__( 'Standard header settings', 'manufaktursolutions-core' ),
				'dependency'  => array(
					'show' => array(
						'qodef_header_layout' => array(
							'values'        => 'standard',
							'default_value' => '',
						),
					),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'    => 'yesno',
				'name'          => 'qodef_standard_header_in_grid',
				'title'         => esc_html__( 'Content in Grid', 'manufaktursolutions-core' ),
				'description'   => esc_html__( 'Set content to be in grid', 'manufaktursolutions-core' ),
				'default_value' => 'no',
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_header_height',
				'title'       => esc_html__( 'Header Height', 'manufaktursolutions-core' ),
				'description' => esc_html__( 'Enter header height', 'manufaktursolutions-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'manufaktursolutions-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_header_side_padding',
				'title'       => esc_html__( 'Header Side Padding', 'manufaktursolutions-core' ),
				'description' => esc_html__( 'Enter side padding for header area', 'manufaktursolutions-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px or %', 'manufaktursolutions-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_standard_header_background_color',
				'title'       => esc_html__( 'Header Background Color', 'manufaktursolutions-core' ),
				'description' => esc_html__( 'Enter header background color', 'manufaktursolutions-core' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_standard_header_border_color',
				'title'       => esc_html__( 'Header Border Color', 'manufaktursolutions-core' ),
				'description' => esc_html__( 'Enter header border color', 'manufaktursolutions-core' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_header_border_width',
				'title'       => esc_html__( 'Header Border Width', 'manufaktursolutions-core' ),
				'description' => esc_html__( 'Enter header border width size', 'manufaktursolutions-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'manufaktursolutions-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_standard_header_border_style',
				'title'       => esc_html__( 'Header Border Style', 'manufaktursolutions-core' ),
				'description' => esc_html__( 'Choose header border style', 'manufaktursolutions-core' ),
				'options'     => manufaktursolutions_core_get_select_type_options_pool( 'border_style' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_standard_header_menu_position',
				'title'         => esc_html__( 'Menu position', 'manufaktursolutions-core' ),
				'default_value' => 'right',
				'options'       => array(
					'left'   => esc_html__( 'Left', 'manufaktursolutions-core' ),
					'center' => esc_html__( 'Center', 'manufaktursolutions-core' ),
					'right'  => esc_html__( 'Right', 'manufaktursolutions-core' ),
				),
			)
		);
	}

	add_action( 'manufaktursolutions_core_action_after_header_options_map', 'manufaktursolutions_core_add_standard_header_options', 10, 2 );
}
