<?php

if ( ! function_exists( 'manufaktursolutions_core_add_fonts_options' ) ) {
	/**
	 * Function that add options for this module
	 */
	function manufaktursolutions_core_add_fonts_options() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope'       => MANUFAKTURSOLUTIONS_CORE_OPTIONS_NAME,
				'type'        => 'admin',
				'slug'        => 'fonts',
				'title'       => esc_html__( 'Fonts', 'manufaktursolutions-core' ),
				'description' => esc_html__( 'Global Fonts Options', 'manufaktursolutions-core' ),
				'icon'        => 'fa fa-cog',
			)
		);

		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_enable_google_fonts',
					'title'         => esc_html__( 'Enable Google Fonts', 'manufaktursolutions-core' ),
					'default_value' => 'yes',
					'args'          => array(
						'custom_class' => 'qodef-enable-google-fonts',
					),
				)
			);

			$google_fonts_section = $page->add_section_element(
				array(
					'name'       => 'qodef_google_fonts_section',
					'title'      => esc_html__( 'Google Fonts Options', 'manufaktursolutions-core' ),
					'dependency' => array(
						'show' => array(
							'qodef_enable_google_fonts' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);

			$page_repeater = $google_fonts_section->add_repeater_element(
				array(
					'name'        => 'qodef_choose_google_fonts',
					'title'       => esc_html__( 'Google Fonts to Include', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Choose Google Fonts which you want to use on your website', 'manufaktursolutions-core' ),
					'button_text' => esc_html__( 'Add New Google Font', 'manufaktursolutions-core' ),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type'  => 'googlefont',
					'name'        => 'qodef_choose_google_font',
					'title'       => esc_html__( 'Google Font', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Choose Google Font', 'manufaktursolutions-core' ),
					'args'        => array(
						'include' => 'google-fonts',
					),
				)
			);

			$google_fonts_section->add_field_element(
				array(
					'field_type'  => 'checkbox',
					'name'        => 'qodef_google_fonts_weight',
					'title'       => esc_html__( 'Google Fonts Weight', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Choose a default Google Fonts weights for your website. Impact on page load time', 'manufaktursolutions-core' ),
					'options'     => array(
						'100'  => esc_html__( '100 Thin', 'manufaktursolutions-core' ),
						'100i' => esc_html__( '100 Thin Italic', 'manufaktursolutions-core' ),
						'200'  => esc_html__( '200 Extra-Light', 'manufaktursolutions-core' ),
						'200i' => esc_html__( '200 Extra-Light Italic', 'manufaktursolutions-core' ),
						'300'  => esc_html__( '300 Light', 'manufaktursolutions-core' ),
						'300i' => esc_html__( '300 Light Italic', 'manufaktursolutions-core' ),
						'400'  => esc_html__( '400 Regular', 'manufaktursolutions-core' ),
						'400i' => esc_html__( '400 Regular Italic', 'manufaktursolutions-core' ),
						'500'  => esc_html__( '500 Medium', 'manufaktursolutions-core' ),
						'500i' => esc_html__( '500 Medium Italic', 'manufaktursolutions-core' ),
						'600'  => esc_html__( '600 Semi-Bold', 'manufaktursolutions-core' ),
						'600i' => esc_html__( '600 Semi-Bold Italic', 'manufaktursolutions-core' ),
						'700'  => esc_html__( '700 Bold', 'manufaktursolutions-core' ),
						'700i' => esc_html__( '700 Bold Italic', 'manufaktursolutions-core' ),
						'800'  => esc_html__( '800 Extra-Bold', 'manufaktursolutions-core' ),
						'800i' => esc_html__( '800 Extra-Bold Italic', 'manufaktursolutions-core' ),
						'900'  => esc_html__( '900 Ultra-Bold', 'manufaktursolutions-core' ),
						'900i' => esc_html__( '900 Ultra-Bold Italic', 'manufaktursolutions-core' ),
					),
				)
			);

			$google_fonts_section->add_field_element(
				array(
					'field_type'  => 'checkbox',
					'name'        => 'qodef_google_fonts_subset',
					'title'       => esc_html__( 'Google Fonts Style', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Choose a default Google Fonts style for your website. Impact on page load time', 'manufaktursolutions-core' ),
					'options'     => array(
						'latin'        => esc_html__( 'Latin', 'manufaktursolutions-core' ),
						'latin-ext'    => esc_html__( 'Latin Extended', 'manufaktursolutions-core' ),
						'cyrillic'     => esc_html__( 'Cyrillic', 'manufaktursolutions-core' ),
						'cyrillic-ext' => esc_html__( 'Cyrillic Extended', 'manufaktursolutions-core' ),
						'greek'        => esc_html__( 'Greek', 'manufaktursolutions-core' ),
						'greek-ext'    => esc_html__( 'Greek Extended', 'manufaktursolutions-core' ),
						'vietnamese'   => esc_html__( 'Vietnamese', 'manufaktursolutions-core' ),
					),
				)
			);

			$page_repeater = $page->add_repeater_element(
				array(
					'name'        => 'qodef_custom_fonts',
					'title'       => esc_html__( 'Custom Fonts', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Add custom fonts', 'manufaktursolutions-core' ),
					'button_text' => esc_html__( 'Add New Custom Font', 'manufaktursolutions-core' ),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'file',
					'name'       => 'qodef_custom_font_ttf',
					'title'      => esc_html__( 'Custom Font TTF', 'manufaktursolutions-core' ),
					'args'       => array(
						'allowed_type' => 'application/octet-stream',
					),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'file',
					'name'       => 'qodef_custom_font_otf',
					'title'      => esc_html__( 'Custom Font OTF', 'manufaktursolutions-core' ),
					'args'       => array(
						'allowed_type' => 'application/octet-stream',
					),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'file',
					'name'       => 'qodef_custom_font_woff',
					'title'      => esc_html__( 'Custom Font WOFF', 'manufaktursolutions-core' ),
					'args'       => array(
						'allowed_type' => 'application/octet-stream',
					),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'file',
					'name'       => 'qodef_custom_font_woff2',
					'title'      => esc_html__( 'Custom Font WOFF2', 'manufaktursolutions-core' ),
					'args'       => array(
						'allowed_type' => 'application/octet-stream',
					),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_custom_font_name',
					'title'      => esc_html__( 'Custom Font Name', 'manufaktursolutions-core' ),
				)
			);

			// Hook to include additional options after module options
			do_action( 'manufaktursolutions_core_action_after_page_fonts_options_map', $page );
		}
	}

	add_action( 'manufaktursolutions_core_action_default_options_init', 'manufaktursolutions_core_add_fonts_options', manufaktursolutions_core_get_admin_options_map_position( 'fonts' ) );
}
