(function ($) {
	'use strict';
	
	var cardsGallery = {};
	mkdf.modules.cardsGallery = cardsGallery;
	
	
	cardsGallery.mkdfOnWindowLoad = mkdfOnWindowLoad;
	
	$(window).on('load', mkdfOnWindowLoad());
	
	/*
	 All functions to be called on $(window).load() should be in this function
	 */
	function mkdfOnWindowLoad() {
		mkdfInitCardsGallery();
        mkdfElementorCardsGallery();
	}
	
	/*
	 **	Init cards gallery shortcode
	 */
	function mkdfInitCardsGallery() {
		var holder = $('.mkdf-cards-gallery');
		
		if (holder.length) {
			holder.each(function () {
				var thisHolder = $(this),
					cards = thisHolder.find('.mkdf-cg-card');
				
				cards.each(function () {
					var card = $(this);
					
					card.on('click', function () {
						if (!cards.last().is(card)) {
							card.addClass('mkdf-out mkdf-animating').siblings().addClass('mkdf-animating-siblings');
							card.detach();
							card.insertAfter(cards.last());
							
							setTimeout(function () {
								card.removeClass('mkdf-out');
							}, 200);
							
							setTimeout(function () {
								card.removeClass('mkdf-animating').siblings().removeClass('mkdf-animating-siblings');
							}, 1200);
							
							cards = thisHolder.find('.mkdf-cg-card');
							
							return false;
						}
					});
				});
				
				if (thisHolder.hasClass('mkdf-bundle-animation') && !mkdf.htmlEl.hasClass('touch')) {
					thisHolder.appear(function () {
						thisHolder.addClass('mkdf-appeared');
						thisHolder.find('img').one('animationend webkitAnimationEnd MSAnimationEnd oAnimationEnd', function () {
							$(this).addClass('mkdf-animation-done');
						});
					}, {accX: 0, accY: mkdfGlobalVars.vars.mkdfElementAppearAmount});
				}
			});
		}
	}

    /**
     * Elementor
     */
    function mkdfElementorCardsGallery(){
        $(window).on('elementor/frontend/init', function () {
            elementorFrontend.hooks.addAction( 'frontend/element_ready/mkdf_cards_gallery.default', function() {
                mkdfInitCardsGallery();
            } );
        });
    }
	
})(jQuery);