<?php
/**
 * The template to display Admin notices
 *
 * @package DETAILX
 * @since DETAILX 1.0.64
 */

$detailx_skins_url  = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$detailx_skins_args = get_query_var( 'detailx_skins_notice_args' );
?>
<div class="detailx_admin_notice detailx_skins_notice notice notice-info is-dismissible" data-notice="skins">
	<?php
	// Theme image
	$detailx_theme_img = detailx_get_file_url( 'screenshot.jpg' );
	if ( '' != $detailx_theme_img ) {
		?>
		<div class="detailx_notice_image"><img src="<?php echo esc_url( $detailx_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'detailx' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="detailx_notice_title">
		<?php esc_html_e( 'New skins are available', 'detailx' ); ?>
	</h3>
	<?php

	// Description
	$detailx_total      = $detailx_skins_args['update'];	// Store value to the separate variable to avoid warnings from ThemeCheck plugin!
	$detailx_skins_msg  = $detailx_total > 0
							// Translators: Add new skins number
							? '<strong>' . sprintf( _n( '%d new version', '%d new versions', $detailx_total, 'detailx' ), $detailx_total ) . '</strong>'
							: '';
	$detailx_total      = $detailx_skins_args['free'];
	$detailx_skins_msg .= $detailx_total > 0
							? ( ! empty( $detailx_skins_msg ) ? ' ' . esc_html__( 'and', 'detailx' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d free skin', '%d free skins', $detailx_total, 'detailx' ), $detailx_total ) . '</strong>'
							: '';
	$detailx_total      = $detailx_skins_args['pay'];
	$detailx_skins_msg .= $detailx_skins_args['pay'] > 0
							? ( ! empty( $detailx_skins_msg ) ? ' ' . esc_html__( 'and', 'detailx' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d paid skin', '%d paid skins', $detailx_total, 'detailx' ), $detailx_total ) . '</strong>'
							: '';
	?>
	<div class="detailx_notice_text">
		<p>
			<?php
			// Translators: Add new skins info
			echo wp_kses_data( sprintf( __( "We are pleased to announce that %s are available for your theme", 'detailx' ), $detailx_skins_msg ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="detailx_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $detailx_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			// Translators: Add theme name
			esc_html_e( 'Go to Skins manager', 'detailx' );
			?>
		</a>
	</div>
</div>
