<?php
/**
 * The template to display the widgets area in the header
 *
 * @package DETAILX
 * @since DETAILX 1.0
 */

// Header sidebar
$detailx_header_name    = detailx_get_theme_option( 'header_widgets' );
$detailx_header_present = ! detailx_is_off( $detailx_header_name ) && is_active_sidebar( $detailx_header_name );
if ( $detailx_header_present ) {
	detailx_storage_set( 'current_sidebar', 'header' );
	$detailx_header_wide = detailx_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $detailx_header_name ) ) {
		dynamic_sidebar( $detailx_header_name );
	}
	$detailx_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $detailx_widgets_output ) ) {
		$detailx_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $detailx_widgets_output );
		$detailx_need_columns   = strpos( $detailx_widgets_output, 'columns_wrap' ) === false;
		if ( $detailx_need_columns ) {
			$detailx_columns = max( 0, (int) detailx_get_theme_option( 'header_columns' ) );
			if ( 0 == $detailx_columns ) {
				$detailx_columns = min( 6, max( 1, detailx_tags_count( $detailx_widgets_output, 'aside' ) ) );
			}
			if ( $detailx_columns > 1 ) {
				$detailx_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $detailx_columns ) . ' widget', $detailx_widgets_output );
			} else {
				$detailx_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $detailx_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'detailx_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $detailx_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $detailx_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'detailx_action_before_sidebar', 'header' );
				detailx_show_layout( $detailx_widgets_output );
				do_action( 'detailx_action_after_sidebar', 'header' );
				if ( $detailx_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $detailx_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'detailx_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
