<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package DETAILX
 * @since DETAILX 1.0
 */

// Page (category, tag, archive, author) title

if ( detailx_need_page_title() ) {
	detailx_sc_layouts_showed( 'title', true );
	detailx_sc_layouts_showed( 'postmeta', true );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								detailx_show_post_meta(
									apply_filters(
										'detailx_filter_post_meta_args', array(
											'components' => join( ',', detailx_array_get_keys_by_value( detailx_get_theme_option( 'meta_parts' ) ) ),
											'counters'   => join( ',', detailx_array_get_keys_by_value( detailx_get_theme_option( 'counters' ) ) ),
											'seo'        => detailx_is_on( detailx_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$detailx_blog_title           = detailx_get_blog_title();
							$detailx_blog_title_text      = '';
							$detailx_blog_title_class     = '';
							$detailx_blog_title_link      = '';
							$detailx_blog_title_link_text = '';
							if ( is_array( $detailx_blog_title ) ) {
								$detailx_blog_title_text      = $detailx_blog_title['text'];
								$detailx_blog_title_class     = ! empty( $detailx_blog_title['class'] ) ? ' ' . $detailx_blog_title['class'] : '';
								$detailx_blog_title_link      = ! empty( $detailx_blog_title['link'] ) ? $detailx_blog_title['link'] : '';
								$detailx_blog_title_link_text = ! empty( $detailx_blog_title['link_text'] ) ? $detailx_blog_title['link_text'] : '';
							} else {
								$detailx_blog_title_text = $detailx_blog_title;
							}
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $detailx_blog_title_class ); ?>">
								<?php
								$detailx_top_icon = detailx_get_term_image_small();
								if ( ! empty( $detailx_top_icon ) ) {
									$detailx_attr = detailx_getimagesize( $detailx_top_icon );
									?>
									<img src="<?php echo esc_url( $detailx_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'detailx' ); ?>"
										<?php
										if ( ! empty( $detailx_attr[3] ) ) {
											detailx_show_layout( $detailx_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $detailx_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $detailx_blog_title_link ) && ! empty( $detailx_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $detailx_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $detailx_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'detailx_action_breadcrumbs' );
						$detailx_breadcrumbs = ob_get_contents();
						ob_end_clean();
						detailx_show_layout( $detailx_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
