<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package DETAILX
 * @since DETAILX 1.0
 */

$detailx_args = get_query_var( 'detailx_logo_args' );

// Site logo
$detailx_logo_type   = isset( $detailx_args['type'] ) ? $detailx_args['type'] : '';
$detailx_logo_image  = detailx_get_logo_image( $detailx_logo_type );
$detailx_logo_text   = detailx_is_on( detailx_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$detailx_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $detailx_logo_image['logo'] ) || ! empty( $detailx_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $detailx_logo_image['logo'] ) ) {
			if ( empty( $detailx_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric($detailx_logo_image['logo']) && (int) $detailx_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$detailx_attr = detailx_getimagesize( $detailx_logo_image['logo'] );
				echo '<img src="' . esc_url( $detailx_logo_image['logo'] ) . '"'
						. ( ! empty( $detailx_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $detailx_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $detailx_logo_text ) . '"'
						. ( ! empty( $detailx_attr[3] ) ? ' ' . wp_kses_data( $detailx_attr[3] ) : '' )
						. '>';
			}
		} else {
			detailx_show_layout( detailx_prepare_macros( $detailx_logo_text ), '<span class="logo_text">', '</span>' );
			detailx_show_layout( detailx_prepare_macros( $detailx_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
