<?php
/**
 * The template to display default site header
 *
 * @package DETAILX
 * @since DETAILX 1.0
 */

$detailx_header_css   = '';
$detailx_header_image = get_header_image();
$detailx_header_video = detailx_get_header_video();
if ( ! empty( $detailx_header_image ) && detailx_trx_addons_featured_image_override( is_singular() || detailx_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$detailx_header_image = detailx_get_current_mode_image( $detailx_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $detailx_header_image ) || ! empty( $detailx_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $detailx_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $detailx_header_image ) {
		echo ' ' . esc_attr( detailx_add_inline_css_class( 'background-image: url(' . esc_url( $detailx_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( detailx_is_on( detailx_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight detailx-full-height';
	}
	$detailx_header_scheme = detailx_get_theme_option( 'header_scheme' );
	if ( ! empty( $detailx_header_scheme ) && ! detailx_is_inherit( $detailx_header_scheme  ) ) {
		echo ' scheme_' . esc_attr( $detailx_header_scheme );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $detailx_header_video ) ) {
		get_template_part( apply_filters( 'detailx_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'detailx_filter_get_template_part', 'templates/header-navi' ) );

	// Mobile header
	if ( detailx_is_on( detailx_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'detailx_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	if ( ! is_single() ) {
		get_template_part( apply_filters( 'detailx_filter_get_template_part', 'templates/header-title' ) );
	}

	// Header widgets area
	get_template_part( apply_filters( 'detailx_filter_get_template_part', 'templates/header-widgets' ) );
	?>
</header>
