<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package DETAILX
 * @since DETAILX 1.0.06
 */

$detailx_header_css   = '';
$detailx_header_image = get_header_image();
$detailx_header_video = detailx_get_header_video();
if ( ! empty( $detailx_header_image ) && detailx_trx_addons_featured_image_override( is_singular() || detailx_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$detailx_header_image = detailx_get_current_mode_image( $detailx_header_image );
}

$detailx_header_id = detailx_get_custom_header_id();
$detailx_header_meta = get_post_meta( $detailx_header_id, 'trx_addons_options', true );
if ( ! empty( $detailx_header_meta['margin'] ) ) {
	detailx_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( detailx_prepare_css_value( $detailx_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $detailx_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $detailx_header_id ) ) ); ?>
				<?php
				echo ! empty( $detailx_header_image ) || ! empty( $detailx_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $detailx_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $detailx_header_image ) {
					echo ' ' . esc_attr( detailx_add_inline_css_class( 'background-image: url(' . esc_url( $detailx_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( detailx_is_on( detailx_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight detailx-full-height';
				}
				$detailx_header_scheme = detailx_get_theme_option( 'header_scheme' );
				if ( ! empty( $detailx_header_scheme ) && ! detailx_is_inherit( $detailx_header_scheme  ) ) {
					echo ' scheme_' . esc_attr( $detailx_header_scheme );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $detailx_header_video ) ) {
		get_template_part( apply_filters( 'detailx_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'detailx_action_show_layout', $detailx_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'detailx_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
