<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package DETAILX
 * @since DETAILX 1.0.10
 */

// Footer sidebar
$detailx_footer_name    = detailx_get_theme_option( 'footer_widgets' );
$detailx_footer_present = ! detailx_is_off( $detailx_footer_name ) && is_active_sidebar( $detailx_footer_name );
if ( $detailx_footer_present ) {
	detailx_storage_set( 'current_sidebar', 'footer' );
	$detailx_footer_wide = detailx_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $detailx_footer_name ) ) {
		dynamic_sidebar( $detailx_footer_name );
	}
	$detailx_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $detailx_out ) ) {
		$detailx_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $detailx_out );
		$detailx_need_columns = true;   //or check: strpos($detailx_out, 'columns_wrap')===false;
		if ( $detailx_need_columns ) {
			$detailx_columns = max( 0, (int) detailx_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $detailx_columns ) {
				$detailx_columns = min( 4, max( 1, detailx_tags_count( $detailx_out, 'aside' ) ) );
			}
			if ( $detailx_columns > 1 ) {
				$detailx_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $detailx_columns ) . ' widget', $detailx_out );
			} else {
				$detailx_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $detailx_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<?php do_action( 'detailx_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $detailx_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $detailx_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'detailx_action_before_sidebar', 'footer' );
				detailx_show_layout( $detailx_out );
				do_action( 'detailx_action_after_sidebar', 'footer' );
				if ( $detailx_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $detailx_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
			<?php do_action( 'detailx_action_after_sidebar_wrap', 'footer' ); ?>
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
