<?php
/**
 * The template to display the site logo in the footer
 *
 * @package DETAILX
 * @since DETAILX 1.0.10
 */

// Logo
if ( detailx_is_on( detailx_get_theme_option( 'logo_in_footer' ) ) ) {
	$detailx_logo_image = detailx_get_logo_image( 'footer' );
	$detailx_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $detailx_logo_image['logo'] ) || ! empty( $detailx_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $detailx_logo_image['logo'] ) ) {
					$detailx_attr = detailx_getimagesize( $detailx_logo_image['logo'] );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $detailx_logo_image['logo'] ) . '"'
								. ( ! empty( $detailx_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $detailx_logo_image['logo_retina'] ) . ' 2x"' : '' )
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'detailx' ) . '"'
								. ( ! empty( $detailx_attr[3] ) ? ' ' . wp_kses_data( $detailx_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $detailx_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $detailx_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
