<?php
/**
 * The template to display default site footer
 *
 * @package DETAILX
 * @since DETAILX 1.0.10
 */

$detailx_footer_id = detailx_get_custom_footer_id();
$detailx_footer_meta = get_post_meta( $detailx_footer_id, 'trx_addons_options', true );
if ( ! empty( $detailx_footer_meta['margin'] ) ) {
	detailx_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( detailx_prepare_css_value( $detailx_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $detailx_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $detailx_footer_id ) ) ); ?>
						<?php
						$detailx_footer_scheme = detailx_get_theme_option( 'footer_scheme' );
						if ( ! empty( $detailx_footer_scheme ) && ! detailx_is_inherit( $detailx_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $detailx_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'detailx_action_show_layout', $detailx_footer_id );
	?>
</footer><!-- /.footer_wrap -->
