<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package DETAILX
 * @since DETAILX 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
$detailx_copyright_scheme = detailx_get_theme_option( 'copyright_scheme' );
if ( ! empty( $detailx_copyright_scheme ) && ! detailx_is_inherit( $detailx_copyright_scheme  ) ) {
	echo ' scheme_' . esc_attr( $detailx_copyright_scheme );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$detailx_copyright = detailx_get_theme_option( 'copyright' );
			if ( ! empty( $detailx_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$detailx_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $detailx_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$detailx_copyright = detailx_prepare_macros( $detailx_copyright );
				// Display copyright
				echo wp_kses( nl2br( $detailx_copyright ), 'detailx_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
