<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package DETAILX
 * @since DETAILX 1.0
 */

$detailx_template_args = get_query_var( 'detailx_template_args' );
if ( is_array( $detailx_template_args ) ) {
	$detailx_columns    = empty( $detailx_template_args['columns'] ) ? 2 : max( 1, $detailx_template_args['columns'] );
	$detailx_blog_style = array( $detailx_template_args['type'], $detailx_columns );
    $detailx_columns_class = detailx_get_column_class( 1, $detailx_columns, ! empty( $detailx_template_args['columns_tablet']) ? $detailx_template_args['columns_tablet'] : '', ! empty($detailx_template_args['columns_mobile']) ? $detailx_template_args['columns_mobile'] : '' );
} else {
	$detailx_template_args = array();
	$detailx_blog_style = explode( '_', detailx_get_theme_option( 'blog_style' ) );
	$detailx_columns    = empty( $detailx_blog_style[1] ) ? 2 : max( 1, $detailx_blog_style[1] );
    $detailx_columns_class = detailx_get_column_class( 1, $detailx_columns );
}

$detailx_post_format = get_post_format();
$detailx_post_format = empty( $detailx_post_format ) ? 'standard' : str_replace( 'post-format-', '', $detailx_post_format );

?><div class="
<?php
if ( ! empty( $detailx_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( detailx_is_blog_style_use_masonry( $detailx_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $detailx_columns ) : esc_attr( $detailx_columns_class ));
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $detailx_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $detailx_columns )
		. ( 'portfolio' != $detailx_blog_style[0] ? ' ' . esc_attr( $detailx_blog_style[0] )  . '_' . esc_attr( $detailx_columns ) : '' )
	);
	detailx_add_blog_animation( $detailx_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	$detailx_hover   = ! empty( $detailx_template_args['hover'] ) && ! detailx_is_inherit( $detailx_template_args['hover'] )
								? $detailx_template_args['hover']
								: detailx_get_theme_option( 'image_hover' );

	if ( 'dots' == $detailx_hover ) {
		$detailx_post_link = empty( $detailx_template_args['no_links'] )
								? ( ! empty( $detailx_template_args['link'] )
									? $detailx_template_args['link']
									: get_permalink()
									)
								: '';
		$detailx_target    = ! empty( $detailx_post_link ) && false === strpos( $detailx_post_link, home_url() )
								? ' target="_blank" rel="nofollow"'
								: '';
	}
	
	// Meta parts
	$detailx_components = ! empty( $detailx_template_args['meta_parts'] )
							? ( is_array( $detailx_template_args['meta_parts'] )
								? $detailx_template_args['meta_parts']
								: explode( ',', $detailx_template_args['meta_parts'] )
								)
							: detailx_array_get_keys_by_value( detailx_get_theme_option( 'meta_parts' ) );

	// Featured image
	detailx_show_post_featured( apply_filters( 'detailx_filter_args_featured',
        array(
			'hover'         => $detailx_hover,
			'no_links'      => ! empty( $detailx_template_args['no_links'] ),
			'thumb_size'    => ! empty( $detailx_template_args['thumb_size'] )
								? $detailx_template_args['thumb_size']
								: detailx_get_thumb_size(
									detailx_is_blog_style_use_masonry( $detailx_blog_style[0] )
										? (	strpos( detailx_get_theme_option( 'body_style' ), 'full' ) !== false || $detailx_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( detailx_get_theme_option( 'body_style' ), 'full' ) !== false || $detailx_columns < 3
											? 'square'
											: 'square'
											)
								),
			'thumb_bg' => detailx_is_blog_style_use_masonry( $detailx_blog_style[0] ) ? false : true,
			'show_no_image' => true,
			'meta_parts'    => $detailx_components,
			'class'         => 'dots' == $detailx_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $detailx_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $detailx_post_link )
												? '<a href="' . esc_url( $detailx_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $detailx_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
            'thumb_ratio'   => 'info' == $detailx_hover ?  '100:102' : '',
        ),
        'content-portfolio',
        $detailx_template_args
    ) );
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!