<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package DETAILX
 * @since DETAILX 1.0
 */

$detailx_template_args = get_query_var( 'detailx_template_args' );
$detailx_columns = 1;
if ( is_array( $detailx_template_args ) ) {
	$detailx_columns    = empty( $detailx_template_args['columns'] ) ? 1 : max( 1, $detailx_template_args['columns'] );
	$detailx_blog_style = array( $detailx_template_args['type'], $detailx_columns );
	if ( ! empty( $detailx_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $detailx_columns > 1 ) {
	    $detailx_columns_class = detailx_get_column_class( 1, $detailx_columns, ! empty( $detailx_template_args['columns_tablet']) ? $detailx_template_args['columns_tablet'] : '', ! empty($detailx_template_args['columns_mobile']) ? $detailx_template_args['columns_mobile'] : '' );
		?>
		<div class="<?php echo esc_attr( $detailx_columns_class ); ?>">
		<?php
	}
} else {
	$detailx_template_args = array();
}
$detailx_expanded    = ! detailx_sidebar_present() && detailx_get_theme_option( 'expand_content' ) == 'expand';
$detailx_post_format = get_post_format();
$detailx_post_format = empty( $detailx_post_format ) ? 'standard' : str_replace( 'post-format-', '', $detailx_post_format );
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_excerpt post_format_' . esc_attr( $detailx_post_format ) );
	detailx_add_blog_animation( $detailx_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$detailx_hover      = ! empty( $detailx_template_args['hover'] ) && ! detailx_is_inherit( $detailx_template_args['hover'] )
							? $detailx_template_args['hover']
							: detailx_get_theme_option( 'image_hover' );
	$detailx_components = ! empty( $detailx_template_args['meta_parts'] )
							? ( is_array( $detailx_template_args['meta_parts'] )
								? $detailx_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $detailx_template_args['meta_parts'] ) )
								)
							: detailx_array_get_keys_by_value( detailx_get_theme_option( 'meta_parts' ) );
	detailx_show_post_featured( apply_filters( 'detailx_filter_args_featured',
		array(
			'no_links'   => ! empty( $detailx_template_args['no_links'] ),
			'hover'      => $detailx_hover,
			'meta_parts' => $detailx_components,
			'thumb_size' => ! empty( $detailx_template_args['thumb_size'] )
							? $detailx_template_args['thumb_size']
							: detailx_get_thumb_size( strpos( detailx_get_theme_option( 'body_style' ), 'full' ) !== false
								? 'full'
								: ( $detailx_expanded 
									? 'huge' 
									: 'big' 
									)
								),
		),
		'content-excerpt',
		$detailx_template_args
	) );

	// Title and post meta
	$detailx_show_title = get_the_title() != '';
	$detailx_show_meta  = count( $detailx_components ) > 0 && ! in_array( $detailx_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $detailx_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			if ( apply_filters( 'detailx_filter_show_blog_title', true, 'excerpt' ) ) {
				do_action( 'detailx_action_before_post_title' );
				if ( empty( $detailx_template_args['no_links'] ) ) {
					the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
				} else {
					the_title( '<h3 class="post_title entry-title">', '</h3>' );
				}
				do_action( 'detailx_action_after_post_title' );
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( apply_filters( 'detailx_filter_show_blog_excerpt', empty( $detailx_template_args['hide_excerpt'] ) && detailx_get_theme_option( 'excerpt_length' ) > 0, 'excerpt' ) ) {
		?>
		<div class="post_content entry-content">
			<?php

			// Post meta
			if ( apply_filters( 'detailx_filter_show_blog_meta', $detailx_show_meta, $detailx_components, 'excerpt' ) ) {
				if ( count( $detailx_components ) > 0 ) {
					do_action( 'detailx_action_before_post_meta' );
					detailx_show_post_meta(
						apply_filters(
							'detailx_filter_post_meta_args', array(
								'components' => join( ',', $detailx_components ),
								'seo'        => false,
								'echo'       => true,
							), 'excerpt', 1
						)
					);
					do_action( 'detailx_action_after_post_meta' );
				}
			}

			if ( detailx_get_theme_option( 'blog_content' ) == 'fullpost' ) {
				// Post content area
				?>
				<div class="post_content_inner">
					<?php
					do_action( 'detailx_action_before_full_post_content' );
					the_content( '' );
					do_action( 'detailx_action_after_full_post_content' );
					?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'detailx' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'detailx' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
			} else {
				// Post content area
				detailx_show_post_content( $detailx_template_args, '<div class="post_content_inner">', '</div>' );
			}

			// More button
			if ( apply_filters( 'detailx_filter_show_blog_readmore',  ! isset( $detailx_template_args['more_button'] ) || ! empty( $detailx_template_args['more_button'] ), 'excerpt' ) ) {
				if ( empty( $detailx_template_args['no_links'] ) ) {
					do_action( 'detailx_action_before_post_readmore' );
					if ( detailx_get_theme_option( 'blog_content' ) != 'fullpost' ) {
						detailx_show_post_more_link( $detailx_template_args, '<p>', '</p>' );
					} else {
						detailx_show_post_comments_link( $detailx_template_args, '<p>', '</p>' );
					}
					do_action( 'detailx_action_after_post_readmore' );
				}
			}

			?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
</article>
<?php

if ( is_array( $detailx_template_args ) ) {
	if ( ! empty( $detailx_template_args['slider'] ) || $detailx_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
