<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package DETAILX
 * @since DETAILX 1.0.50
 */

$detailx_template_args = get_query_var( 'detailx_template_args' );
if ( is_array( $detailx_template_args ) ) {
	$detailx_columns    = empty( $detailx_template_args['columns'] ) ? 2 : max( 1, $detailx_template_args['columns'] );
	$detailx_blog_style = array( $detailx_template_args['type'], $detailx_columns );
} else {
	$detailx_template_args = array();
	$detailx_blog_style = explode( '_', detailx_get_theme_option( 'blog_style' ) );
	$detailx_columns    = empty( $detailx_blog_style[1] ) ? 2 : max( 1, $detailx_blog_style[1] );
}
$detailx_blog_id       = detailx_get_custom_blog_id( join( '_', $detailx_blog_style ) );
$detailx_blog_style[0] = str_replace( 'blog-custom-', '', $detailx_blog_style[0] );
$detailx_expanded      = ! detailx_sidebar_present() && detailx_get_theme_option( 'expand_content' ) == 'expand';
$detailx_components    = ! empty( $detailx_template_args['meta_parts'] )
							? ( is_array( $detailx_template_args['meta_parts'] )
								? join( ',', $detailx_template_args['meta_parts'] )
								: $detailx_template_args['meta_parts']
								)
							: detailx_array_get_keys_by_value( detailx_get_theme_option( 'meta_parts' ) );
$detailx_post_format   = get_post_format();
$detailx_post_format   = empty( $detailx_post_format ) ? 'standard' : str_replace( 'post-format-', '', $detailx_post_format );

$detailx_blog_meta     = detailx_get_custom_layout_meta( $detailx_blog_id );
$detailx_custom_style  = ! empty( $detailx_blog_meta['scripts_required'] ) ? $detailx_blog_meta['scripts_required'] : 'none';

if ( ! empty( $detailx_template_args['slider'] ) || $detailx_columns > 1 || ! detailx_is_off( $detailx_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $detailx_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( detailx_is_off( $detailx_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $detailx_custom_style ) ) . "-1_{$detailx_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $detailx_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $detailx_columns )
					. ' post_layout_' . esc_attr( $detailx_blog_style[0] )
					. ' post_layout_' . esc_attr( $detailx_blog_style[0] ) . '_' . esc_attr( $detailx_columns )
					. ( ! detailx_is_off( $detailx_custom_style )
						? ' post_layout_' . esc_attr( $detailx_custom_style )
							. ' post_layout_' . esc_attr( $detailx_custom_style ) . '_' . esc_attr( $detailx_columns )
						: ''
						)
		);
	detailx_add_blog_animation( $detailx_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'detailx_action_show_layout', $detailx_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $detailx_template_args['slider'] ) || $detailx_columns > 1 || ! detailx_is_off( $detailx_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
