<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package DETAILX
 * @since DETAILX 1.0
 */

$detailx_template_args = get_query_var( 'detailx_template_args' );

if ( is_array( $detailx_template_args ) ) {
	$detailx_columns    = empty( $detailx_template_args['columns'] ) ? 2 : max( 1, $detailx_template_args['columns'] );
	$detailx_blog_style = array( $detailx_template_args['type'], $detailx_columns );
    $detailx_columns_class = detailx_get_column_class( 1, $detailx_columns, ! empty( $detailx_template_args['columns_tablet']) ? $detailx_template_args['columns_tablet'] : '', ! empty($detailx_template_args['columns_mobile']) ? $detailx_template_args['columns_mobile'] : '' );
} else {
	$detailx_template_args = array();
	$detailx_blog_style = explode( '_', detailx_get_theme_option( 'blog_style' ) );
	$detailx_columns    = empty( $detailx_blog_style[1] ) ? 2 : max( 1, $detailx_blog_style[1] );
    $detailx_columns_class = detailx_get_column_class( 1, $detailx_columns );
}
$detailx_expanded   = ! detailx_sidebar_present() && detailx_get_theme_option( 'expand_content' ) == 'expand';

$detailx_post_format = get_post_format();
$detailx_post_format = empty( $detailx_post_format ) ? 'standard' : str_replace( 'post-format-', '', $detailx_post_format );

?><div class="<?php
	if ( ! empty( $detailx_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( detailx_is_blog_style_use_masonry( $detailx_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $detailx_columns ) : esc_attr( $detailx_columns_class ) );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $detailx_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $detailx_columns )
				. ' post_layout_' . esc_attr( $detailx_blog_style[0] )
				. ' post_layout_' . esc_attr( $detailx_blog_style[0] ) . '_' . esc_attr( $detailx_columns )
	);
	detailx_add_blog_animation( $detailx_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$detailx_hover      = ! empty( $detailx_template_args['hover'] ) && ! detailx_is_inherit( $detailx_template_args['hover'] )
							? $detailx_template_args['hover']
							: detailx_get_theme_option( 'image_hover' );

	$detailx_components = ! empty( $detailx_template_args['meta_parts'] )
							? ( is_array( $detailx_template_args['meta_parts'] )
								? $detailx_template_args['meta_parts']
								: explode( ',', $detailx_template_args['meta_parts'] )
								)
							: detailx_array_get_keys_by_value( detailx_get_theme_option( 'meta_parts' ) );

	detailx_show_post_featured( apply_filters( 'detailx_filter_args_featured',
		array(
			'thumb_size' => ! empty( $detailx_template_args['thumb_size'] )
				? $detailx_template_args['thumb_size']
				: detailx_get_thumb_size(
					'classic' == $detailx_blog_style[0]
						? ( strpos( detailx_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $detailx_columns > 2 ? 'big' : 'huge' )
								: ( $detailx_columns > 2
									? ( $detailx_expanded ? 'square' : 'square' )
									: ($detailx_columns > 1 ? 'square' : ( $detailx_expanded ? 'huge' : 'big' ))
									)
							)
						: ( strpos( detailx_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $detailx_columns > 2 ? 'masonry-big' : 'full' )
								: ($detailx_columns === 1 ? ( $detailx_expanded ? 'huge' : 'big' ) : ( $detailx_columns <= 2 && $detailx_expanded ? 'masonry-big' : 'masonry' ))
							)
			),
			'hover'      => $detailx_hover,
			'meta_parts' => $detailx_components,
			'no_links'   => ! empty( $detailx_template_args['no_links'] ),
        ),
        'content-classic',
        $detailx_template_args
    ) );

	// Title and post meta
	$detailx_show_title = get_the_title() != '';
	$detailx_show_meta  = count( $detailx_components ) > 0 && ! in_array( $detailx_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $detailx_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php

			// Post meta
			if ( apply_filters( 'detailx_filter_show_blog_meta', $detailx_show_meta, $detailx_components, 'classic' ) ) {
				if ( count( $detailx_components ) > 0 ) {
					do_action( 'detailx_action_before_post_meta' );
					detailx_show_post_meta(
						apply_filters(
							'detailx_filter_post_meta_args', array(
							'components' => join( ',', $detailx_components ),
							'seo'        => false,
							'echo'       => true,
						), $detailx_blog_style[0], $detailx_columns
						)
					);
					do_action( 'detailx_action_after_post_meta' );
				}
			}

			// Post title
			if ( apply_filters( 'detailx_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'detailx_action_before_post_title' );
				if ( empty( $detailx_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'detailx_action_after_post_title' );
			}

			if( !in_array( $detailx_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
				// More button
				if ( apply_filters( 'detailx_filter_show_blog_readmore', ! $detailx_show_title || ! empty( $detailx_template_args['more_button'] ), 'classic' ) ) {
					if ( empty( $detailx_template_args['no_links'] ) ) {
						do_action( 'detailx_action_before_post_readmore' );
						detailx_show_post_more_link( $detailx_template_args, '<div class="more-wrap">', '</div>' );
						do_action( 'detailx_action_after_post_readmore' );
					}
				}
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	if( in_array( $detailx_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
		ob_start();
		if (apply_filters('detailx_filter_show_blog_excerpt', empty($detailx_template_args['hide_excerpt']) && detailx_get_theme_option('excerpt_length') > 0, 'classic')) {
			detailx_show_post_content($detailx_template_args, '<div class="post_content_inner">', '</div>');
		}
		// More button
		if(! empty( $detailx_template_args['more_button'] )) {
			if ( empty( $detailx_template_args['no_links'] ) ) {
				do_action( 'detailx_action_before_post_readmore' );
				detailx_show_post_more_link( $detailx_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'detailx_action_after_post_readmore' );
			}
		}
		$detailx_content = ob_get_contents();
		ob_end_clean();
		detailx_show_layout($detailx_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->');
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
