<?php
/**
 * 'Band' template to display the content
 *
 * Used for index/archive/search.
 *
 * @package DETAILX
 * @since DETAILX 1.71.0
 */

$detailx_template_args = get_query_var( 'detailx_template_args' );
if ( ! is_array( $detailx_template_args ) ) {
	$detailx_template_args = array(
								'type'    => 'band',
								'columns' => 1
								);
}

$detailx_columns       = 1;

$detailx_expanded      = ! detailx_sidebar_present() && detailx_get_theme_option( 'expand_content' ) == 'expand';

$detailx_post_format   = get_post_format();
$detailx_post_format   = empty( $detailx_post_format ) ? 'standard' : str_replace( 'post-format-', '', $detailx_post_format );

if ( is_array( $detailx_template_args ) ) {
	$detailx_columns    = empty( $detailx_template_args['columns'] ) ? 1 : max( 1, $detailx_template_args['columns'] );
	$detailx_blog_style = array( $detailx_template_args['type'], $detailx_columns );
	if ( ! empty( $detailx_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $detailx_columns > 1 ) {
	    $detailx_columns_class = detailx_get_column_class( 1, $detailx_columns, ! empty( $detailx_template_args['columns_tablet']) ? $detailx_template_args['columns_tablet'] : '', ! empty($detailx_template_args['columns_mobile']) ? $detailx_template_args['columns_mobile'] : '' );
				?><div class="<?php echo esc_attr( $detailx_columns_class ); ?>"><?php
	}
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_band post_format_' . esc_attr( $detailx_post_format ) );
	detailx_add_blog_animation( $detailx_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$detailx_hover      = ! empty( $detailx_template_args['hover'] ) && ! detailx_is_inherit( $detailx_template_args['hover'] )
							? $detailx_template_args['hover']
							: detailx_get_theme_option( 'image_hover' );
	$detailx_components = ! empty( $detailx_template_args['meta_parts'] )
							? ( is_array( $detailx_template_args['meta_parts'] )
								? $detailx_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $detailx_template_args['meta_parts'] ) )
								)
							: detailx_array_get_keys_by_value( detailx_get_theme_option( 'meta_parts' ) );
	detailx_show_post_featured( apply_filters( 'detailx_filter_args_featured',
		array(
			'no_links'   => ! empty( $detailx_template_args['no_links'] ),
			'hover'      => $detailx_hover,
			'meta_parts' => $detailx_components,
			'thumb_bg'   => true,
			'thumb_ratio'   => '1:1',
			'thumb_size' => ! empty( $detailx_template_args['thumb_size'] )
								? $detailx_template_args['thumb_size']
								: detailx_get_thumb_size( 
								in_array( $detailx_post_format, array( 'gallery', 'audio', 'video' ) )
									? ( strpos( detailx_get_theme_option( 'body_style' ), 'full' ) !== false
										? 'full'
										: ( $detailx_expanded 
											? 'big' 
											: 'medium-square'
											)
										)
									: 'masonry-big'
								)
		),
		'content-band',
		$detailx_template_args
	) );

	?><div class="post_content_wrap"><?php

		// Title and post meta
		$detailx_show_title = get_the_title() != '';
		$detailx_show_meta  = count( $detailx_components ) > 0 && ! in_array( $detailx_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );
		if ( $detailx_show_title ) {
			?>
			<div class="post_header entry-header">
				<?php
				// Categories
				if ( apply_filters( 'detailx_filter_show_blog_categories', $detailx_show_meta && in_array( 'categories', $detailx_components ), array( 'categories' ), 'band' ) ) {
					do_action( 'detailx_action_before_post_category' );
					?>
					<div class="post_category">
						<?php
						detailx_show_post_meta( apply_filters(
															'detailx_filter_post_meta_args',
															array(
																'components' => 'categories',
																'seo'        => false,
																'echo'       => true,
																'cat_sep'    => false,
																),
															'hover_' . $detailx_hover, 1
															)
											);
						?>
					</div>
					<?php
					$detailx_components = detailx_array_delete_by_value( $detailx_components, 'categories' );
					do_action( 'detailx_action_after_post_category' );
				}
				// Post title
				if ( apply_filters( 'detailx_filter_show_blog_title', true, 'band' ) ) {
					do_action( 'detailx_action_before_post_title' );
					if ( empty( $detailx_template_args['no_links'] ) ) {
						the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
					} else {
						the_title( '<h4 class="post_title entry-title">', '</h4>' );
					}
					do_action( 'detailx_action_after_post_title' );
				}
				?>
			</div><!-- .post_header -->
			<?php
		}

		// Post content
		if ( ! isset( $detailx_template_args['excerpt_length'] ) && ! in_array( $detailx_post_format, array( 'gallery', 'audio', 'video' ) ) ) {
			$detailx_template_args['excerpt_length'] = 13;
		}
		if ( apply_filters( 'detailx_filter_show_blog_excerpt', empty( $detailx_template_args['hide_excerpt'] ) && detailx_get_theme_option( 'excerpt_length' ) > 0, 'band' ) ) {
			?>
			<div class="post_content entry-content">
				<?php
				// Post content area
				detailx_show_post_content( $detailx_template_args, '<div class="post_content_inner">', '</div>' );
				?>
			</div><!-- .entry-content -->
			<?php
		}
		// Post meta
		if ( apply_filters( 'detailx_filter_show_blog_meta', $detailx_show_meta, $detailx_components, 'band' ) ) {
			if ( count( $detailx_components ) > 0 ) {
				do_action( 'detailx_action_before_post_meta' );
				detailx_show_post_meta(
					apply_filters(
						'detailx_filter_post_meta_args', array(
							'components' => join( ',', $detailx_components ),
							'seo'        => false,
							'echo'       => true,
						), 'band', 1
					)
				);
				do_action( 'detailx_action_after_post_meta' );
			}
		}
		// More button
		if ( apply_filters( 'detailx_filter_show_blog_readmore', ! $detailx_show_title || ! empty( $detailx_template_args['more_button'] ), 'band' ) ) {
			if ( empty( $detailx_template_args['no_links'] ) ) {
				do_action( 'detailx_action_before_post_readmore' );
				detailx_show_post_more_link( $detailx_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'detailx_action_after_post_readmore' );
			}
		}
		?>
	</div>
</article>
<?php

if ( is_array( $detailx_template_args ) ) {
	if ( ! empty( $detailx_template_args['slider'] ) || $detailx_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
