<?php
/**
 * The template to display Admin notices
 *
 * @package DETAILX
 * @since DETAILX 1.0.1
 */

$detailx_theme_slug = get_option( 'template' );
$detailx_theme_obj  = wp_get_theme( $detailx_theme_slug );
?>
<div class="detailx_admin_notice detailx_welcome_notice notice notice-info is-dismissible" data-notice="admin">
	<?php
	// Theme image
	$detailx_theme_img = detailx_get_file_url( 'screenshot.jpg' );
	if ( '' != $detailx_theme_img ) {
		?>
		<div class="detailx_notice_image"><img src="<?php echo esc_url( $detailx_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'detailx' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="detailx_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'detailx' ),
				$detailx_theme_obj->get( 'Name' ) . ( DETAILX_THEME_FREE ? ' ' . __( 'Free', 'detailx' ) : '' ),
				$detailx_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="detailx_notice_text">
		<p class="detailx_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $detailx_theme_obj->description ) );
			?>
		</p>
		<p class="detailx_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'detailx' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="detailx_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=detailx_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'detailx' );
			?>
		</a>
	</div>
</div>
