<?php
/**
 * Skin Setup
 *
 * @package DETAILX
 * @since DETAILX 1.76.0
 */


//--------------------------------------------
// SKIN DEFAULTS
//--------------------------------------------

// Return theme's (skin's) default value for the specified parameter
if ( ! function_exists( 'detailx_theme_defaults' ) ) {
	function detailx_theme_defaults( $name='', $value='' ) {
		$defaults = array(
			'page_width'          => 1290,
			'page_boxed_extra'    => 60,
			'page_fullwide_max'   => 1920,
			'page_fullwide_extra' => 60,
			'sidebar_width'       => 410,
			'sidebar_gap'         => 40,
			'grid_gap'            => 30,
			'rad'                 => 0
		);
		if ( empty( $name ) ) {
			return $defaults;
		} else {
			if ( $value === '' && isset( $defaults[ $name ] ) ) {
				$value = $defaults[ $name ];
			}
			return $value;
		}
	}
}


// WOOCOMMERCE SETUP
//--------------------------------------------------

// Allow extended layouts for WooCommerce
if ( ! function_exists( 'detailx_skin_woocommerce_allow_extensions' ) ) {
	add_filter( 'detailx_filter_load_woocommerce_extensions', 'detailx_skin_woocommerce_allow_extensions' );
	function detailx_skin_woocommerce_allow_extensions( $allow ) {
		return true;
	}
}


// Theme init priorities:
// Action 'after_setup_theme'
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options. Attention! After this step you can use only basic options (not overriden)
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
// Action 'wp_loaded'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)

//--------------------------------------------
// SKIN SETTINGS
//--------------------------------------------
if ( ! function_exists( 'detailx_skin_setup' ) ) {
	add_action( 'after_setup_theme', 'detailx_skin_setup', 1 );
	function detailx_skin_setup() {

		$GLOBALS['DETAILX_STORAGE'] = array_merge( $GLOBALS['DETAILX_STORAGE'], array(

			// Key validator: market[env|loc]-vendor[axiom|ancora|themerex]
			'theme_pro_key'       => 'env-ancora',

			'theme_doc_url'       => '//detailx.ancorathemes.com/doc',

			'theme_demofiles_url' => '//demofiles.ancorathemes.com/detailx/',
			
			'theme_rate_url'      => '//themeforest.net/downloads',

			'theme_custom_url'    => '//themerex.net/offers/?utm_source=offers&utm_medium=click&utm_campaign=themeinstall',

			'theme_support_url'   => '//themerex.net/support/',

			'theme_download_url'  => '//themeforest.net/user/ancorathemes/portfolio',        // Ancora

			'theme_video_url'     => '//www.youtube.com/channel/UCdIjRh7-lPVHqTTKpaf8PLA',   // Ancora

			'theme_privacy_url'   => '//ancorathemes.com/privacy-policy/',                   // Ancora

			'portfolio_url'       => '//themeforest.net/user/ancorathemes/portfolio',        // Ancora

			// Comma separated slugs of theme-specific categories (for get relevant news in the dashboard widget)
			// (i.e. 'children,kindergarten')
			'theme_categories'    => '',
		) );
	}
}


// Add/remove/change Theme Settings
if ( ! function_exists( 'detailx_skin_setup_settings' ) ) {
	add_action( 'after_setup_theme', 'detailx_skin_setup_settings', 1 );
	function detailx_skin_setup_settings() {
		// Example: enable (true) / disable (false) thumbs in the prev/next navigation
		detailx_storage_set_array( 'settings', 'thumbs_in_navigation', false );
		detailx_storage_set_array2( 'required_plugins', 'woocommerce', 'install', true );
		detailx_storage_set_array2( 'required_plugins', 'ti-woocommerce-wishlist', 'install', true );
		detailx_storage_set_array2( 'required_plugins', 'woo-smart-quick-view', 'install', true );
		detailx_storage_set_array2( 'required_plugins', 'quickcal', 'install', true );
	}
}



//--------------------------------------------
// SKIN FONTS
//--------------------------------------------
if ( ! function_exists( 'detailx_skin_setup_fonts' ) ) {
	add_action( 'after_setup_theme', 'detailx_skin_setup_fonts', 1 );
	function detailx_skin_setup_fonts() {
		// Fonts to load when theme start
		// It can be:
		// - Google fonts (specify name, family and styles)
		// - Adobe fonts (specify name, family and link URL)
		// - uploaded fonts (specify name, family), placed in the folder css/font-face/font-name inside the skin folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		// example: font name 'TeX Gyre Termes', folder 'TeX-Gyre-Termes'
		detailx_storage_set(
			'load_fonts', array(
				array(
					'name'   => 'DM Sans',
					'family' => 'sans-serif',
					'link'   => '',
					'styles' => 'ital,wght@0,400;0,500;0,700;1,400;1,500;1,700'
				),
				array(
					'name'   => 'Barlow Condensed',
					'family' => 'sans-serif',
					'link'   => '',
					'styles' => 'ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700'
				),
			)
		);

		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		detailx_storage_set( 'load_fonts_subset', 'latin,latin-ext' );

		// Settings of the main tags.
		// Default value of 'font-family' may be specified as reference to the array $load_fonts (see above)
		// or as comma-separated string.
		// In the second case (if 'font-family' is specified manually as comma-separated string):
		//    1) Font name with spaces in the parameter 'font-family' will be enclosed in the quotes and no spaces after comma!
		//    2) If font-family inherit a value from the 'Main text' - specify 'inherit' as a value
		// example:
		// Correct:   'font-family' => detailx_get_load_fonts_family_string( $load_fonts[0] )
		// Correct:   'font-family' => 'Roboto,sans-serif'
		// Correct:   'font-family' => '"PT Serif",sans-serif'
		// Incorrect: 'font-family' => 'Roboto, sans-serif'
		// Incorrect: 'font-family' => 'PT Serif,sans-serif'

		$font_description = esc_html__( 'Font settings for the %s of the site. To ensure that the elements scale properly on mobile devices, please use only the following units: "rem", "em" or "ex"', 'detailx' );

		detailx_storage_set(
			'theme_fonts', array(
				'p'       => array(
					'title'           => esc_html__( 'Main text', 'detailx' ),
					'description'     => sprintf( $font_description, esc_html__( 'main text', 'detailx' ) ),
					'font-family'     => '"DM Sans",sans-serif',
					'font-size'       => '1rem',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.62em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0.1px',
					'margin-top'      => '0em',
					'margin-bottom'   => '1.57em',
				),
				'post'    => array(
					'title'           => esc_html__( 'Article text', 'detailx' ),
					'description'     => sprintf( $font_description, esc_html__( 'article text', 'detailx' ) ),
					'font-family'     => '',			// Example: '"PR Serif",serif',
					'font-size'       => '',			// Example: '1.286rem',
					'font-weight'     => '',			// Example: '400',
					'font-style'      => '',			// Example: 'normal',
					'line-height'     => '',			// Example: '1.75em',
					'text-decoration' => '',			// Example: 'none',
					'text-transform'  => '',			// Example: 'none',
					'letter-spacing'  => '',			// Example: '',
					'margin-top'      => '',			// Example: '0em',
					'margin-bottom'   => '',			// Example: '1.4em',
				),
				'h1'      => array(
					'title'           => esc_html__( 'Heading 1', 'detailx' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H1', 'detailx' ) ),
					'font-family'     => '"Barlow Condensed",sans-serif',
					'font-size'       => '3.167em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '-0.6px',
					'margin-top'      => '1.04em',
					'margin-bottom'   => '0.46em',
				),
				'h2'      => array(
					'title'           => esc_html__( 'Heading 2', 'detailx' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H2', 'detailx' ) ),
					'font-family'     => '"Barlow Condensed",sans-serif',
					'font-size'       => '2.611em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1.021em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '-0.5px',
					'margin-top'      => '0.7em',
					'margin-bottom'   => '0.52em',
				),
				'h3'      => array(
					'title'           => esc_html__( 'Heading 3', 'detailx' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H3', 'detailx' ) ),
					'font-family'     => '"Barlow Condensed",sans-serif',
					'font-size'       => '1.944em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1.086em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '-0.35px',
					'margin-top'      => '1.06em',
					'margin-bottom'   => '0.68em',
				),
				'h4'      => array(
					'title'           => esc_html__( 'Heading 4', 'detailx' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H4', 'detailx' ) ),
					'font-family'     => '"Barlow Condensed",sans-serif',
					'font-size'       => '1.556em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1.214em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.32em',
					'margin-bottom'   => '0.67em',
				),
				'h5'      => array(
					'title'           => esc_html__( 'Heading 5', 'detailx' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H5', 'detailx' ) ),
					'font-family'     => '"Barlow Condensed",sans-serif',
					'font-size'       => '1.333em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1.417em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.35em',
					'margin-bottom'   => '0.7em',
				),
				'h6'      => array(
					'title'           => esc_html__( 'Heading 6', 'detailx' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H6', 'detailx' ) ),
					'font-family'     => '"Barlow Condensed",sans-serif',
					'font-size'       => '1.167em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1.333em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '0px',
					'margin-top'      => '2.1em',
					'margin-bottom'   => '0.9em',
				),
				'logo'    => array(
					'title'           => esc_html__( 'Logo text', 'detailx' ),
					'description'     => sprintf( $font_description, esc_html__( 'text of the logo', 'detailx' ) ),
					'font-family'     => '"Barlow Condensed",sans-serif',
					'font-size'       => '1.7em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1.25em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '0px',
				),
				'button'  => array(
					'title'           => esc_html__( 'Buttons', 'detailx' ),
					'description'     => sprintf( $font_description, esc_html__( 'buttons', 'detailx' ) ),
					'font-family'     => '"DM Sans",sans-serif',
					'font-size'       => '14px',
					'font-weight'     => '500',
					'font-style'      => 'normal',
					'line-height'     => '21px',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '1.4px',
				),
				'input'   => array(
					'title'           => esc_html__( 'Input fields', 'detailx' ),
					'description'     => sprintf( $font_description, esc_html__( 'input fields, dropdowns and textareas', 'detailx' ) ),
					'font-family'     => 'inherit',
					'font-size'       => '16px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',     // Attention! Firefox don't allow line-height less then 1.5em in the select
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0.1px',
				),
				'info'    => array(
					'title'           => esc_html__( 'Post meta', 'detailx' ),
					'description'     => sprintf( $font_description, esc_html__( 'post meta (author, categories, publish date, counters, share, etc.)', 'detailx' ) ),
					'font-family'     => 'inherit',
					'font-size'       => '14px',  // Old value '13px' don't allow using 'font zoom' in the custom blog items
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.4em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0.4em',
					'margin-bottom'   => '',
				),
				'menu'    => array(
					'title'           => esc_html__( 'Main menu', 'detailx' ),
					'description'     => sprintf( $font_description, esc_html__( 'main menu items', 'detailx' ) ),
					'font-family'     => '"Barlow Condensed",sans-serif',
					'font-size'       => '17px',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '0px',
				),
				'submenu' => array(
					'title'           => esc_html__( 'Dropdown menu', 'detailx' ),
					'description'     => sprintf( $font_description, esc_html__( 'dropdown menu items', 'detailx' ) ),
					'font-family'     => '"DM Sans",sans-serif',
					'font-size'       => '15px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'other' => array(
					'title'           => esc_html__( 'Other', 'detailx' ),
					'description'     => sprintf( $font_description, esc_html__( 'specific elements', 'detailx' ) ),
					'font-family'     => '"DM Sans",sans-serif',
				),
			)
		);

		// Font presets
		detailx_storage_set(
			'font_presets', array(
				'karla' => array(
								'title'  => esc_html__( 'Karla', 'detailx' ),
								'load_fonts' => array(
													// Google font
													array(
														'name'   => 'Dancing Script',
														'family' => 'fantasy',
														'link'   => '',
														'styles' => '300,400,700',
													),
													// Google font
													array(
														'name'   => 'Sansita Swashed',
														'family' => 'fantasy',
														'link'   => '',
														'styles' => '300,400,700',
													),
												),
								'theme_fonts' => array(
													'p'       => array(
														'font-family'     => '"Dancing Script",fantasy',
														'font-size'       => '1.25rem',
													),
													'post'    => array(
														'font-family'     => '',
													),
													'h1'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
														'font-size'       => '4em',
													),
													'h2'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h3'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h4'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h5'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h6'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'logo'    => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'button'  => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'input'   => array(
														'font-family'     => 'inherit',
													),
													'info'    => array(
														'font-family'     => 'inherit',
													),
													'menu'    => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'submenu' => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
												),
							),
				'roboto' => array(
								'title'  => esc_html__( 'Roboto', 'detailx' ),
								'load_fonts' => array(
													// Google font
													array(
														'name'   => 'Noto Sans JP',
														'family' => 'serif',
														'link'   => '',
														'styles' => '300,300italic,400,400italic,700,700italic',
													),
													// Google font
													array(
														'name'   => 'Merriweather',
														'family' => 'sans-serif',
														'link'   => '',
														'styles' => '300,300italic,400,400italic,700,700italic',
													),
												),
								'theme_fonts' => array(
													'p'       => array(
														'font-family'     => '"Noto Sans JP",serif',
													),
													'post'    => array(
														'font-family'     => '',
													),
													'h1'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h2'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h3'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h4'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h5'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h6'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'logo'    => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'button'  => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'input'   => array(
														'font-family'     => 'inherit',
													),
													'info'    => array(
														'font-family'     => 'inherit',
													),
													'menu'    => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'submenu' => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
												),
							),
				'garamond' => array(
								'title'  => esc_html__( 'Garamond', 'detailx' ),
								'load_fonts' => array(
													// Adobe font
													array(
														'name'   => 'Europe',
														'family' => 'sans-serif',
														'link'   => 'https://use.typekit.net/qmj1tmx.css',
														'styles' => '',
													),
													// Adobe font
													array(
														'name'   => 'Sofia Pro',
														'family' => 'sans-serif',
														'link'   => 'https://use.typekit.net/qmj1tmx.css',
														'styles' => '',
													),
												),
								'theme_fonts' => array(
													'p'       => array(
														'font-family'     => '"Sofia Pro",sans-serif',
													),
													'post'    => array(
														'font-family'     => '',
													),
													'h1'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h2'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h3'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h4'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h5'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h6'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'logo'    => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'button'  => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'input'   => array(
														'font-family'     => 'inherit',
													),
													'info'    => array(
														'font-family'     => 'inherit',
													),
													'menu'    => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'submenu' => array(
														'font-family'     => 'Europe,sans-serif',
													),
												),
							),
			)
		);
	}
}


//--------------------------------------------
// COLOR SCHEMES
//--------------------------------------------
if ( ! function_exists( 'detailx_skin_setup_schemes' ) ) {
	add_action( 'after_setup_theme', 'detailx_skin_setup_schemes', 1 );
	function detailx_skin_setup_schemes() {

		// Theme colors for customizer
		// Attention! Inner scheme must be last in the array below
		detailx_storage_set(
			'scheme_color_groups', array(
				'main'    => array(
					'title'       => esc_html__( 'Main', 'detailx' ),
					'description' => esc_html__( 'Colors of the main content area', 'detailx' ),
				),
				'alter'   => array(
					'title'       => esc_html__( 'Alter', 'detailx' ),
					'description' => esc_html__( 'Colors of the alternative blocks (sidebars, etc.)', 'detailx' ),
				),
				'extra'   => array(
					'title'       => esc_html__( 'Extra', 'detailx' ),
					'description' => esc_html__( 'Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'detailx' ),
				),
				'inverse' => array(
					'title'       => esc_html__( 'Inverse', 'detailx' ),
					'description' => esc_html__( 'Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'detailx' ),
				),
				'input'   => array(
					'title'       => esc_html__( 'Input', 'detailx' ),
					'description' => esc_html__( 'Colors of the form fields (text field, textarea, select, etc.)', 'detailx' ),
				),
			)
		);

		detailx_storage_set(
			'scheme_color_names', array(
				'bg_color'    => array(
					'title'       => esc_html__( 'Background color', 'detailx' ),
					'description' => esc_html__( 'Background color of this block in the normal state', 'detailx' ),
				),
				'bg_hover'    => array(
					'title'       => esc_html__( 'Background hover', 'detailx' ),
					'description' => esc_html__( 'Background color of this block in the hovered state', 'detailx' ),
				),
				'bd_color'    => array(
					'title'       => esc_html__( 'Border color', 'detailx' ),
					'description' => esc_html__( 'Border color of this block in the normal state', 'detailx' ),
				),
				'bd_hover'    => array(
					'title'       => esc_html__( 'Border hover', 'detailx' ),
					'description' => esc_html__( 'Border color of this block in the hovered state', 'detailx' ),
				),
				'text'        => array(
					'title'       => esc_html__( 'Text', 'detailx' ),
					'description' => esc_html__( 'Color of the text inside this block', 'detailx' ),
				),
				'text_dark'   => array(
					'title'       => esc_html__( 'Text dark', 'detailx' ),
					'description' => esc_html__( 'Color of the dark text (bold, header, etc.) inside this block', 'detailx' ),
				),
				'text_light'  => array(
					'title'       => esc_html__( 'Text light', 'detailx' ),
					'description' => esc_html__( 'Color of the light text (post meta, etc.) inside this block', 'detailx' ),
				),
				'text_link'   => array(
					'title'       => esc_html__( 'Link', 'detailx' ),
					'description' => esc_html__( 'Color of the links inside this block', 'detailx' ),
				),
				'text_hover'  => array(
					'title'       => esc_html__( 'Link hover', 'detailx' ),
					'description' => esc_html__( 'Color of the hovered state of links inside this block', 'detailx' ),
				),
				'text_link2'  => array(
					'title'       => esc_html__( 'Accent 2', 'detailx' ),
					'description' => esc_html__( 'Color of the accented texts (areas) inside this block', 'detailx' ),
				),
				'text_hover2' => array(
					'title'       => esc_html__( 'Accent 2 hover', 'detailx' ),
					'description' => esc_html__( 'Color of the hovered state of accented texts (areas) inside this block', 'detailx' ),
				),
				'text_link3'  => array(
					'title'       => esc_html__( 'Accent 3', 'detailx' ),
					'description' => esc_html__( 'Color of the other accented texts (buttons) inside this block', 'detailx' ),
				),
				'text_hover3' => array(
					'title'       => esc_html__( 'Accent 3 hover', 'detailx' ),
					'description' => esc_html__( 'Color of the hovered state of other accented texts (buttons) inside this block', 'detailx' ),
				),
			)
		);

		// Default values for each color scheme
		$schemes = array(

			// Color scheme: 'default'
			'default' => array(
				'title'    => esc_html__( 'Default', 'detailx' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#F4F4F4', //
					'bd_color'         => '#D9D9D9', //

					// Text and links colors
					'text'             => '#615F5C', //
					'text_light'       => '#949087', //
					'text_dark'        => '#18171A', //
					'text_link'        => '#EA0A0B', //
					'text_hover'       => '#FF2020', //
					'text_link2'       => '#FF4311', //
					'text_hover2'      => '#FF5A20', //
					'text_link3'       => '#DFD000', //
					'text_hover3'      => '#F1E103', //
 
					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FFFFFF', //
					'alter_bg_hover'   => '#EEEEEE', //
					'alter_bd_color'   => '#D9D9D9', //
					'alter_bd_hover'   => '#C9C9C9', //
					'alter_text'       => '#615F5C', //
					'alter_light'      => '#949087', //
					'alter_dark'       => '#18171A', //
					'alter_link'       => '#EA0A0B', //
					'alter_hover'      => '#FF2020', //
					'alter_link2'      => '#FF4311', //
					'alter_hover2'     => '#FF5A20', //
					'alter_link3'      => '#DFD000', //
					'alter_hover3'     => '#F1E103', //
 
					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#19181B', //
					'extra_bg_hover'   => '#2C2B2E', //
					'extra_bd_color'   => '#363537', //
					'extra_bd_hover'   => '#4A494B', //
					'extra_text'       => '#949087', //
					'extra_light'      => '#8C8B92', //
					'extra_dark'       => '#FFFFFF', //
					'extra_link'       => '#EA0A0B', //
					'extra_hover'      => '#FFFFFF', //
					'extra_link2'      => '#80d572', //
					'extra_hover2'     => '#8be77c', //
					'extra_link3'      => '#ddb837', //
					'extra_hover3'     => '#eec432', //

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //
					'input_bg_hover'   => 'transparent', //
					'input_bd_color'   => '#C9C9C9', //
					'input_bd_hover'   => '#D9D9D9', //
					'input_text'       => '#615F5C', //
					'input_light'      => '#949087', //
					'input_dark'       => '#18171A', //

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1', //
					'inverse_bd_hover' => '#5aa4a9', //
					'inverse_text'     => '#1d1d1d', //
					'inverse_light'    => '#333333', //
					'inverse_dark'     => '#18171A', //
					'inverse_link'     => '#FFFFFF', //
					'inverse_hover'    => '#FFFFFF', //

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'dark'
			'dark'    => array(
				'title'    => esc_html__( 'Dark', 'detailx' ),
				'internal' => true,
				'colors'   => array(
					
					// Whole block border and background
					'bg_color'         => '#0D0C0F', // 
					'bd_color'         => '#363537', // 
					
					// Text and links colors
					'text'             => '#D6D6D8', // 
					'text_light'       => '#8C8B92', // 
					'text_dark'        => '#FFFFFF', // 
					'text_link'        => '#EA0A0B', // 
					'text_hover'       => '#FF2020', // 
					'text_link2'       => '#FF4311', // 
					'text_hover2'      => '#FF5A20', // 
					'text_link3'       => '#DFD000', // 
					'text_hover3'      => '#F1E103', // 
					
					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#232225', // 
					'alter_bg_hover'   => '#2C2B2E', //
					'alter_bd_color'   => '#363537', //
					'alter_bd_hover'   => '#4A494B', //
					'alter_text'       => '#D6D6D8', //
					'alter_light'      => '#8C8B92', //
					'alter_dark'       => '#FFFFFF', //
					'alter_link'       => '#EA0A0B', //
					'alter_hover'      => '#FF2020', //
					'alter_link2'      => '#FF4311', //
					'alter_hover2'     => '#FF5A20', //
					'alter_link3'      => '#DFD000', //
					'alter_hover3'     => '#F1E103', //
					
					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#19181B', //
					'extra_bg_hover'   => '#2C2B2E', //
					'extra_bd_color'   => '#363537', //
					'extra_bd_hover'   => '#4A494B', //
					'extra_text'       => '#D6D6D8', //
					'extra_light'      => '#8C8B92', //
					'extra_dark'       => '#FFFFFF',
					'extra_link'       => '#EA0A0B', //
					'extra_hover'      => '#ffffff',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',
					
					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //
					'input_bg_hover'   => 'transparent', //
					'input_bd_color'   => '#363537', //
					'input_bd_hover'   => '#4A494B', //
					'input_text'       => '#D6D6D8', //
					'input_light'      => '#8C8B92', //
					'input_dark'       => '#FFFFFF', //
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#e36650', //
					'inverse_bd_hover' => '#cb5b47', //
					'inverse_text'     => '#F4F4F4', //
					'inverse_light'    => '#6f6f6f', //
					'inverse_dark'     => '#19181B', //
					'inverse_link'     => '#FFFFFF', //
					'inverse_hover'    => '#232225', //
					
					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

            // Color scheme: 'light'
            'light' => array(
                'title'    => esc_html__( 'Light', 'detailx' ),
                'internal' => true,
                'colors'   => array(

                    // Whole block border and background
                    'bg_color'         => '#FFFFFF', //
                    'bd_color'         => '#D9D9D9', //

                    // Text and links colors
                    'text'             => '#615F5C', //
                    'text_light'       => '#949087', //
                    'text_dark'        => '#18171A', //
                    'text_link'        => '#EA0A0B', //
                    'text_hover'       => '#FF2020', //
                    'text_link2'       => '#FF4311', //
                    'text_hover2'      => '#FF5A20', //
                    'text_link3'       => '#DFD000', //
                    'text_hover3'      => '#F1E103', //
 
                    // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                    'alter_bg_color'   => '#F4F4F4', //
                    'alter_bg_hover'   => '#EEEEEE', //
                    'alter_bd_color'   => '#D9D9D9', //
                    'alter_bd_hover'   => '#C9C9C9', //
                    'alter_text'       => '#615F5C', //
                    'alter_light'      => '#949087', //
                    'alter_dark'       => '#18171A', //
                    'alter_link'       => '#EA0A0B', //
                    'alter_hover'      => '#FF2020', //
                    'alter_link2'      => '#FF4311', //
                    'alter_hover2'     => '#FF5A20', //
                    'alter_link3'      => '#DFD000', //
                    'alter_hover3'     => '#F1E103', //
 
                    // Extra blocks (submenu, tabs, color blocks, etc.)
                    'extra_bg_color'   => '#19181B', //
                    'extra_bg_hover'   => '#2C2B2E', //
                    'extra_bd_color'   => '#363537', //
                    'extra_bd_hover'   => '#4A494B', //
                    'extra_text'       => '#949087', //
                    'extra_light'      => '#8C8B92', //
                    'extra_dark'       => '#FFFFFF', //
                    'extra_link'       => '#EA0A0B', //
                    'extra_hover'      => '#FFFFFF', //
                    'extra_link2'      => '#80d572', //
                    'extra_hover2'     => '#8be77c', //
                    'extra_link3'      => '#ddb837', //
                    'extra_hover3'     => '#eec432', //

                    // Input fields (form's fields and textarea)
                    'input_bg_color'   => 'transparent', //
                    'input_bg_hover'   => 'transparent', //
                    'input_bd_color'   => '#D9D9D9', //
                    'input_bd_hover'   => '#C9C9C9', //
                    'input_text'       => '#615F5C', //
                    'input_light'      => '#949087', //
                    'input_dark'       => '#18171A', //

                    // Inverse blocks (text and links on the 'text_link' background)
                    'inverse_bd_color' => '#67bcc1', //
                    'inverse_bd_hover' => '#5aa4a9', //
                    'inverse_text'     => '#1d1d1d', //
                    'inverse_light'    => '#333333', //
                    'inverse_dark'     => '#18171A', //
                    'inverse_link'     => '#FFFFFF', //
                    'inverse_hover'    => '#FFFFFF', //

                    // Additional (skin-specific) colors.
                    // Attention! Set of colors must be equal in all color schemes.
                    //---> For example:
                    //---> 'new_color1'         => '#rrggbb',
                    //---> 'alter_new_color1'   => '#rrggbb',
                    //---> 'inverse_new_color1' => '#rrggbb',
                ),
            ),
			
			// Color scheme: 'orange'
			'orange' => array(
				'title'    => esc_html__( 'Orange', 'detailx' ),
				'internal' => true,
				'colors'   => array(
					
					// Whole block border and background
					'bg_color'         => '#F4F4F4', //
					'bd_color'         => '#D9D9D9', //
					
					// Text and links colors
					'text'             => '#747577', //
					'text_light'       => '#93969A', //
					'text_dark'        => '#121114', //
					'text_link'        => '#FE610D', //
					'text_hover'       => '#F25400', //
					'text_link2'       => '#0068D7', //
					'text_hover2'      => '#005CBE', //
					'text_link3'       => '#FDB731', //
					'text_hover3'      => '#F9AB15', //
					
					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FFFFFF', //
					'alter_bg_hover'   => '#EEEEEE', //
					'alter_bd_color'   => '#D9D9D9', //
					'alter_bd_hover'   => '#C9C9C9', //
					'alter_text'       => '#747577', //
					'alter_light'      => '#93969A', //
					'alter_dark'       => '#121114', //
					'alter_link'       => '#FE610D', //
					'alter_hover'      => '#F25400', //
					'alter_link2'      => '#0068D7', //
					'alter_hover2'     => '#005CBE', //
					'alter_link3'      => '#FDB731', //
					'alter_hover3'     => '#F9AB15', //
					
					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#121413', //
					'extra_bg_hover'   => '#2B2D2C', //
					'extra_bd_color'   => '#373A39', //
					'extra_bd_hover'   => '#484B4A', //
					'extra_text'       => '#93969A', //
					'extra_light'      => '#909491', //
					'extra_dark'       => '#FFFFFF', //
					'extra_link'       => '#FE610D', //
					'extra_hover'      => '#FFFFFF', //
					'extra_link2'      => '#80d572', //
					'extra_hover2'     => '#8be77c', //
					'extra_link3'      => '#ddb837', //
					'extra_hover3'     => '#eec432', //
					
					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //
					'input_bg_hover'   => 'transparent', //
					'input_bd_color'   => '#C9C9C9', //
					'input_bd_hover'   => '#D9D9D9', //
					'input_text'       => '#747577', //
					'input_light'      => '#93969A', //
					'input_dark'       => '#121114', //
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1', //
					'inverse_bd_hover' => '#5aa4a9', //
					'inverse_text'     => '#1d1d1d', //
					'inverse_light'    => '#333333', //
					'inverse_dark'     => '#121114', //
					'inverse_link'     => '#FFFFFF', //
					'inverse_hover'    => '#FFFFFF', //
					
					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),
			
			// Color scheme: 'orange-light'
			'orange-light' => array(
				'title'    => esc_html__( 'Orange Light', 'detailx' ),
				'internal' => true,
				'colors'   => array(
					
					// Whole block border and background
					'bg_color'         => '#FFFFFF', //
					'bd_color'         => '#D9D9D9', //
					
					// Text and links colors
					'text'             => '#747577', //
					'text_light'       => '#93969A', //
					'text_dark'        => '#121114', //
					'text_link'        => '#FE610D', //
					'text_hover'       => '#F25400', //
					'text_link2'       => '#0068D7', //
					'text_hover2'      => '#005CBE', //
					'text_link3'       => '#FDB731', //
					'text_hover3'      => '#F9AB15', //
					
					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#F4F4F4', //
					'alter_bg_hover'   => '#EEEEEE', //
					'alter_bd_color'   => '#D9D9D9', //
					'alter_bd_hover'   => '#C9C9C9', //
					'alter_text'       => '#747577', //
					'alter_light'      => '#93969A', //
					'alter_dark'       => '#121114', //
					'alter_link'       => '#FE610D', //
					'alter_hover'      => '#F25400', //
					'alter_link2'      => '#0068D7', //
					'alter_hover2'     => '#005CBE', //
					'alter_link3'      => '#FDB731', //
					'alter_hover3'     => '#F9AB15', //
					
					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#121413', //
					'extra_bg_hover'   => '#2B2D2C', //
					'extra_bd_color'   => '#373A39', //
					'extra_bd_hover'   => '#484B4A', //
					'extra_text'       => '#93969A', //
					'extra_light'      => '#909491', //
					'extra_dark'       => '#FFFFFF', //
					'extra_link'       => '#FE610D', //
					'extra_hover'      => '#FFFFFF', //
					'extra_link2'      => '#80d572', //
					'extra_hover2'     => '#8be77c', //
					'extra_link3'      => '#ddb837', //
					'extra_hover3'     => '#eec432', //
					
					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //
					'input_bg_hover'   => 'transparent', //
					'input_bd_color'   => '#C9C9C9', //
					'input_bd_hover'   => '#D9D9D9', //
					'input_text'       => '#747577', //
					'input_light'      => '#93969A', //
					'input_dark'       => '#121114', //
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1', //
					'inverse_bd_hover' => '#5aa4a9', //
					'inverse_text'     => '#1d1d1d', //
					'inverse_light'    => '#333333', //
					'inverse_dark'     => '#121114', //
					'inverse_link'     => '#FFFFFF', //
					'inverse_hover'    => '#FFFFFF', //
					
					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),
			
			// Color scheme: 'blue'
			'blue' => array(
				'title'    => esc_html__( 'Blue', 'detailx' ),
				'internal' => true,
				'colors'   => array(
					
					// Whole block border and background
					'bg_color'         => '#F0F6FA', //
					'bd_color'         => '#D8DEE6', //
					
					// Text and links colors
					'text'             => '#6B6D74', //
					'text_light'       => '#9A9DA5', //
					'text_dark'        => '#111319', //
					'text_link'        => '#1339B6', //
					'text_hover'       => '#304ACF', //
					'text_link2'       => '#00AFF5', //
					'text_hover2'      => '#24C0FF', //
					'text_link3'       => '#A4CC1C', //
					'text_hover3'      => '#B6DF2A', //
					
					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FFFFFF', //
					'alter_bg_hover'   => '#E3EDF2', //
					'alter_bd_color'   => '#D8DEE6', //
					'alter_bd_hover'   => '#CFD5DF', //
					'alter_text'       => '#6B6D74', //
					'alter_light'      => '#9A9DA5', //
					'alter_dark'       => '#111319', //
					'alter_link'       => '#1339B6', //
					'alter_hover'      => '#304ACF', //
					'alter_link2'      => '#00AFF5', //
					'alter_hover2'     => '#24C0FF', //
					'alter_link3'      => '#A4CC1C', //
					'alter_hover3'     => '#B6DF2A', //
					
					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#1E2128', //
					'extra_bg_hover'   => '#23262C', //
					'extra_bd_color'   => '#2D2F36', //
					'extra_bd_hover'   => '#383A41', //
					'extra_text'       => '#9A9DA5', //
					'extra_light'      => '#7F8594', //
					'extra_dark'       => '#FFFFFF', //
					'extra_link'       => '#1339B6', //
					'extra_hover'      => '#FFFFFF', //
					'extra_link2'      => '#80d572', //
					'extra_hover2'     => '#8be77c', //
					'extra_link3'      => '#ddb837', //
					'extra_hover3'     => '#eec432', //
					
					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //
					'input_bg_hover'   => 'transparent', //
					'input_bd_color'   => '#CFD5DF', //
					'input_bd_hover'   => '#D8DEE6', //
					'input_text'       => '#6B6D74', //
					'input_light'      => '#9A9DA5', //
					'input_dark'       => '#111319', //
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1', //
					'inverse_bd_hover' => '#5aa4a9', //
					'inverse_text'     => '#1d1d1d', //
					'inverse_light'    => '#333333', //
					'inverse_dark'     => '#111319', //
					'inverse_link'     => '#FFFFFF', //
					'inverse_hover'    => '#FFFFFF', //
					
					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),
			
			// Color scheme: 'blue-light'
			'blue-light' => array(
				'title'    => esc_html__( 'Blue Light', 'detailx' ),
				'internal' => true,
				'colors'   => array(
					
					// Whole block border and background
					'bg_color'         => '#FFFFFF', //
					'bd_color'         => '#D8DEE6', //
					
					// Text and links colors
					'text'             => '#6B6D74', //
					'text_light'       => '#9A9DA5', //
					'text_dark'        => '#111319', //
					'text_link'        => '#1339B6', //
					'text_hover'       => '#304ACF', //
					'text_link2'       => '#00AFF5', //
					'text_hover2'      => '#24C0FF', //
					'text_link3'       => '#A4CC1C', //
					'text_hover3'      => '#B6DF2A', //
					
					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#F0F6FA', //
					'alter_bg_hover'   => '#E3EDF2', //
					'alter_bd_color'   => '#D8DEE6', //
					'alter_bd_hover'   => '#CFD5DF', //
					'alter_text'       => '#6B6D74', //
					'alter_light'      => '#9A9DA5', //
					'alter_dark'       => '#111319', //
					'alter_link'       => '#1339B6', //
					'alter_hover'      => '#304ACF', //
					'alter_link2'      => '#00AFF5', //
					'alter_hover2'     => '#24C0FF', //
					'alter_link3'      => '#A4CC1C', //
					'alter_hover3'     => '#B6DF2A', //
					
					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#1E2128', //
					'extra_bg_hover'   => '#23262C', //
					'extra_bd_color'   => '#2D2F36', //
					'extra_bd_hover'   => '#383A41', //
					'extra_text'       => '#9A9DA5', //
					'extra_light'      => '#7F8594', //
					'extra_dark'       => '#FFFFFF', //
					'extra_link'       => '#1339B6', //
					'extra_hover'      => '#FFFFFF', //
					'extra_link2'      => '#80d572', //
					'extra_hover2'     => '#8be77c', //
					'extra_link3'      => '#ddb837', //
					'extra_hover3'     => '#eec432', //
					
					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //
					'input_bg_hover'   => 'transparent', //
					'input_bd_color'   => '#CFD5DF', //
					'input_bd_hover'   => '#D8DEE6', //
					'input_text'       => '#6B6D74', //
					'input_light'      => '#9A9DA5', //
					'input_dark'       => '#111319', //
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1', //
					'inverse_bd_hover' => '#5aa4a9', //
					'inverse_text'     => '#1d1d1d', //
					'inverse_light'    => '#333333', //
					'inverse_dark'     => '#111319', //
					'inverse_link'     => '#FFFFFF', //
					'inverse_hover'    => '#FFFFFF', //
					
					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),
		
		);
		detailx_storage_set( 'schemes', $schemes );
		detailx_storage_set( 'schemes_original', $schemes );

		// Add names of additional colors
		//---> For example:
		//---> detailx_storage_set_array( 'scheme_color_names', 'new_color1', array(
		//---> 	'title'       => __( 'New color 1', 'detailx' ),
		//---> 	'description' => __( 'Description of the new color 1', 'detailx' ),
		//---> ) );


		// Additional colors for each scheme
		// Parameters:	'color' - name of the color from the scheme that should be used as source for the transformation
		//				'alpha' - to make color transparent (0.0 - 1.0)
		//				'hue', 'saturation', 'brightness' - inc/dec value for each color's component
		detailx_storage_set(
			'scheme_colors_add', array(
				'bg_color_0'        => array(
					'color' => 'bg_color',
					'alpha' => 0,
				),
				'bg_color_02'       => array(
					'color' => 'bg_color',
					'alpha' => 0.2,
				),
				'bg_color_07'       => array(
					'color' => 'bg_color',
					'alpha' => 0.7,
				),
				'bg_color_08'       => array(
					'color' => 'bg_color',
					'alpha' => 0.8,
				),
				'bg_color_09'       => array(
					'color' => 'bg_color',
					'alpha' => 0.9,
				),
				'alter_bg_color_07' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.7,
				),
				'alter_bg_color_04' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.4,
				),
				'alter_bg_color_00' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0,
				),
				'alter_bg_color_02' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.2,
				),
				'alter_bd_color_02' => array(
					'color' => 'alter_bd_color',
					'alpha' => 0.2,
				),
                'alter_dark_015'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.15,
                ),
                'alter_dark_02'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.2,
                ),
                'alter_dark_05'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.5,
                ),
                'alter_dark_08'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.8,
                ),
				'alter_link_02'     => array(
					'color' => 'alter_link',
					'alpha' => 0.2,
				),
				'alter_link_07'     => array(
					'color' => 'alter_link',
					'alpha' => 0.7,
				),
				'extra_bg_color_05' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.5,
				),
				'extra_bg_color_07' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.7,
				),
				'extra_link_02'     => array(
					'color' => 'extra_link',
					'alpha' => 0.2,
				),
				'extra_link_07'     => array(
					'color' => 'extra_link',
					'alpha' => 0.7,
				),
                'text_dark_003'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.03,
                ),
                'text_dark_005'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.05,
                ),
                'text_dark_008'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.08,
                ),
				'text_dark_015'      => array(
					'color' => 'text_dark',
					'alpha' => 0.15,
				),
				'text_dark_02'      => array(
					'color' => 'text_dark',
					'alpha' => 0.2,
				),
                'text_dark_03'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.3,
                ),
                'text_dark_05'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.5,
                ),
				'text_dark_07'      => array(
					'color' => 'text_dark',
					'alpha' => 0.7,
				),
                'text_dark_08'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.8,
                ),
                'text_link_007'      => array(
                    'color' => 'text_link',
                    'alpha' => 0.07,
                ),
				'text_link_02'      => array(
					'color' => 'text_link',
					'alpha' => 0.2,
				),
                'text_link_03'      => array(
                    'color' => 'text_link',
                    'alpha' => 0.3,
                ),
				'text_link_04'      => array(
					'color' => 'text_link',
					'alpha' => 0.4,
				),
				'text_link_07'      => array(
					'color' => 'text_link',
					'alpha' => 0.7,
				),
				'text_link2_08'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.8,
                ),
                'text_link2_007'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.07,
                ),
				'text_link2_02'      => array(
					'color' => 'text_link2',
					'alpha' => 0.2,
				),
                'text_link2_03'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.3,
                ),
				'text_link2_05'      => array(
					'color' => 'text_link2',
					'alpha' => 0.5,
				),
                'text_link3_007'      => array(
                    'color' => 'text_link3',
                    'alpha' => 0.07,
                ),
				'text_link3_02'      => array(
					'color' => 'text_link3',
					'alpha' => 0.2,
				),
                'text_link3_03'      => array(
                    'color' => 'text_link3',
                    'alpha' => 0.3,
                ),
                'inverse_text_03'      => array(
                    'color' => 'inverse_text',
                    'alpha' => 0.3,
                ),
                'inverse_link_08'      => array(
                    'color' => 'inverse_link',
                    'alpha' => 0.8,
                ),
                'inverse_hover_08'      => array(
                    'color' => 'inverse_hover',
                    'alpha' => 0.8,
                ),
				'text_dark_blend'   => array(
					'color'      => 'text_dark',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'text_link_blend'   => array(
					'color'      => 'text_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'alter_link_blend'  => array(
					'color'      => 'alter_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
			)
		);

		// Simple scheme editor: lists the colors to edit in the "Simple" mode.
		// For each color you can set the array of 'slave' colors and brightness factors that are used to generate new values,
		// when 'main' color is changed
		// Leave 'slave' arrays empty if your scheme does not have a color dependency
		detailx_storage_set(
			'schemes_simple', array(
				'text_link'        => array(),
				'text_hover'       => array(),
				'text_link2'       => array(),
				'text_hover2'      => array(),
				'text_link3'       => array(),
				'text_hover3'      => array(),
				'alter_link'       => array(),
				'alter_hover'      => array(),
				'alter_link2'      => array(),
				'alter_hover2'     => array(),
				'alter_link3'      => array(),
				'alter_hover3'     => array(),
				'extra_link'       => array(),
				'extra_hover'      => array(),
				'extra_link2'      => array(),
				'extra_hover2'     => array(),
				'extra_link3'      => array(),
				'extra_hover3'     => array(),
			)
		);

		// Parameters to set order of schemes in the css
		detailx_storage_set(
			'schemes_sorted', array(
				'color_scheme',
				'header_scheme',
				'menu_scheme',
				'sidebar_scheme',
				'footer_scheme',
			)
		);

		// Color presets
		detailx_storage_set(
			'color_presets', array(
				'autumn' => array(
								'title'  => esc_html__( 'Autumn', 'detailx' ),
								'colors' => array(
												'default' => array(
																	'text_link'  => '#d83938',
																	'text_hover' => '#f2b232',
																	),
												'dark' => array(
																	'text_link'  => '#d83938',
																	'text_hover' => '#f2b232',
																	)
												)
							),
				'green' => array(
								'title'  => esc_html__( 'Natural Green', 'detailx' ),
								'colors' => array(
												'default' => array(
																	'text_link'  => '#75ac78',
																	'text_hover' => '#378e6d',
																	),
												'dark' => array(
																	'text_link'  => '#75ac78',
																	'text_hover' => '#378e6d',
																	)
												)
							),
			)
		);
	}
}

// Enqueue extra styles for frontend
if ( ! function_exists( 'detailx_clone_frontend_scripts' ) ) {
	add_action( 'wp_enqueue_scripts', 'detailx_clone_frontend_scripts', 2300 );
	function detailx_clone_frontend_scripts() {
		$extra_styles_url = detailx_get_file_url( detailx_skins_get_current_skin_dir() . 'extra-styles.css' );
		if ( '' != $extra_styles_url ) {
			wp_enqueue_style( 'detailx-extra-skin-' . esc_attr( detailx_skins_get_current_skin_name() ), $extra_styles_url, array(), null );
		}
		$cars_url = detailx_get_file_url( detailx_skins_get_current_skin_dir() . 'cars.css' );
		if ( '' != $cars_url ) {
			wp_enqueue_style( 'detailx-cars-skin-' . esc_attr( detailx_skins_get_current_skin_name() ), $cars_url, array(), null );
		}
	}
}

// Custom styles
$detailx_skin_path = detailx_get_file_dir( detailx_skins_get_current_skin_dir() . 'extra-styles.php' );
if ( ! empty( $detailx_skin_path ) ) {
	require_once $detailx_skin_path;
}


// Activation methods
if ( ! function_exists( 'detailx_skin_filter_activation_methods2' ) ) {
	add_filter( 'trx_addons_filter_activation_methods', 'detailx_skin_filter_activation_methods2', 11, 1 );
	function detailx_skin_filter_activation_methods2( $args ) {
		$args['elements_key'] = true;
		return $args;
	}
}

add_filter('trx_addons_filter_not_selected_text', 'detailx_skin_woocommerce_filter_change_all_label');
if( ! function_exists('detailx_skin_woocommerce_filter_change_all_label') ) {
	function detailx_skin_woocommerce_filter_change_all_label($label) {
		if ( detailx_exists_woocommerce() ) {
			if( get_taxonomy( 'product_cat' ) && is_shop() ) {
				$label = esc_html__('All', 'detailx');
			}
		}
		return $label;
	}
}

// Filter to add/remove components of ThemeREX Addons when current skin is active
if ( ! function_exists( 'detailx_clone_trx_addons_default_components' ) ) {
	add_filter( 'trx_addons_filter_load_options', 'detailx_clone_trx_addons_default_components', 20 );
	function detailx_clone_trx_addons_default_components( $components ) {
		$components['components_cpt_cars'] = 1;
		
		return $components;
	}
}

// Change thumb size
if ( ! function_exists( 'detailx_clone_trx_addons_thumb_size' ) ) {
	add_filter( 'trx_addons_filter_thumb_size', 'detailx_clone_trx_addons_thumb_size', 10, 3 );
	function detailx_clone_trx_addons_thumb_size( $thumb_size = '', $type = '', $args=array() ) {
		if ( detailx_exists_trx_addons() && defined( 'TRX_ADDONS_CPT_CARS_AGENTS_PT' ) && is_post_type_archive( TRX_ADDONS_CPT_CARS_AGENTS_PT ) && $type == 'team-default' ) {
			$thumb_size = detailx_get_thumb_size('rectangle');
		}
		else if ( $type == 'cars-default' ) {
			$thumb_size = detailx_get_thumb_size(
				$args['columns'] > 1
					? 'big'
					: 'huge'
			);
		}
		else if ( $type == 'cars-agent' ) {
			$thumb_size = detailx_get_thumb_size('masonry-big');
		}
		return $thumb_size;
	}
}

// Add cat_sep in meta single
if ( ! function_exists( 'detailx_clone_filter_post_meta_args_single' ) ) {
	add_filter( 'detailx_filter_post_meta_args', 'detailx_clone_filter_post_meta_args_single', 2, 2 );
	function detailx_clone_filter_post_meta_args_single( $arg, $type ) {
		if ( isset( $arg['sc'] ) && 'cars_single' == $arg['sc'] ) {
			$arg['theme_specific'] = false;
			$arg['components']     = 'date,views,share';
		}
		
		return $arg;
	}
}

// Hide single car style "Tabs"
if ( !function_exists( 'detailx_cpt_cars_remove_single_styles' ) ) {
	add_filter('trx_addons_filter_cpt_single_styles', 'detailx_cpt_cars_remove_single_styles', 10, 2);
	function detailx_cpt_cars_remove_single_styles( $list, $cpt ) {
		if( $cpt === 'cpt_cars' ) {
			unset( $list['tabs'] );
		}
		return $list;
	}
}


if ( ! function_exists( 'detailx_skin_filter_car_item_button_simple' ) ) {
    add_filter( 'trx_addons_filter_car_item_button_simple', 'detailx_skin_filter_car_item_button_simple' );
	function detailx_skin_filter_car_item_button_simple() {
		echo '';
	}
}
