<?php
// Add plugin-specific fonts to the custom CSS
if ( ! function_exists( 'detailx_elm_get_css' ) ) {
    add_filter( 'detailx_filter_get_css', 'detailx_elm_get_css', 10, 2 );
    function detailx_elm_get_css( $css, $args ) {

        if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
            $fonts         = $args['fonts'];
            $css['fonts'] .= <<<CSS
.elementor-widget-progress .elementor-title,
.elementor-widget-progress .elementor-progress-percentage,
.elementor-widget-toggle .elementor-toggle-title,
.elementor-widget-tabs .elementor-tab-title,
.elementor-widget-progress .elementor-title, .elementor-progress-bar,  
.elementor-widget-counter .elementor-counter-number-wrapper {
	{$fonts['h5_font-family']}
}
.custom_icon_btn.elementor-widget-button .elementor-button .elementor-button-text,
.elementor-widget-counter .elementor-counter-title, 
.elementor-widget-icon-box .elementor-widget-container .elementor-icon-box-title small {
    {$fonts['p_font-family']}
}

CSS;
        }

        return $css;
    }
}


// Add theme-specific CSS-animations
if ( ! function_exists( 'detailx_elm_add_theme_animations' ) ) {
	add_filter( 'elementor/controls/animations/additional_animations', 'detailx_elm_add_theme_animations' );
	function detailx_elm_add_theme_animations( $animations ) {
		/* To add a theme-specific animations to the list:
			1) Merge to the array 'animations': array(
													esc_html__( 'Theme Specific', 'detailx' ) => array(
														'ta_custom_1' => esc_html__( 'Custom 1', 'detailx' )
													)
												)
			2) Add a CSS rules for the class '.ta_custom_1' to create a custom entrance animation
		*/
		$animations = array_merge(
						$animations,
						array(
							esc_html__( 'Theme Specific', 'detailx' ) => array(
									'ta_under_strips' => esc_html__( 'Under the strips', 'detailx' ),
									'detailx-fadeinup' => esc_html__( 'DetailX - Fade In Up', 'detailx' ),
									'detailx-fadeinright' => esc_html__( 'DetailX - Fade In Right', 'detailx' ),
									'detailx-fadeinleft' => esc_html__( 'DetailX - Fade In Left', 'detailx' ),
									'detailx-fadeindown' => esc_html__( 'DetailX - Fade In Down', 'detailx' ),
									'detailx-fadein' => esc_html__( 'DetailX - Fade In', 'detailx' ),
									'detailx-infinite-rotate' => esc_html__( 'DetailX - Infinite Rotate', 'detailx' ),
								)
							)
						);

		return $animations;
	}
}
