<?php
/**
 * The template to display single post
 *
 * @package DETAILX
 * @since DETAILX 1.0
 */

// Full post loading
$full_post_loading          = detailx_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = detailx_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = detailx_get_theme_option( 'posts_navigation_scroll_which_block' );

// Position of the related posts
$detailx_related_position   = detailx_get_theme_option( 'related_position' );

// Type of the prev/next post navigation
$detailx_posts_navigation   = detailx_get_theme_option( 'posts_navigation' );
$detailx_prev_post          = false;
$detailx_prev_post_same_cat = detailx_get_theme_option( 'posts_navigation_scroll_same_cat' );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( detailx_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	detailx_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'detailx_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $detailx_posts_navigation ) {
		$detailx_prev_post = get_previous_post( $detailx_prev_post_same_cat );  // Get post from same category
		if ( ! $detailx_prev_post && $detailx_prev_post_same_cat ) {
			$detailx_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $detailx_prev_post ) {
			$detailx_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $detailx_prev_post ) ) {
		detailx_sc_layouts_showed( 'featured', false );
		detailx_sc_layouts_showed( 'title', false );
		detailx_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $detailx_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'detailx_filter_get_template_part', 'templates/content', 'single-' . detailx_get_theme_option( 'single_style' ) ), 'single-' . detailx_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $detailx_related_position, 'inside' ) === 0 ) {
		$detailx_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'detailx_action_related_posts' );
		$detailx_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $detailx_related_content ) ) {
			$detailx_related_position_inside = max( 0, min( 9, detailx_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $detailx_related_position_inside ) {
				$detailx_related_position_inside = mt_rand( 1, 9 );
			}

			$detailx_p_number         = 0;
			$detailx_related_inserted = false;
			$detailx_in_block         = false;
			$detailx_content_start    = strpos( $detailx_content, '<div class="post_content' );
			$detailx_content_end      = strrpos( $detailx_content, '</div>' );

			for ( $i = max( 0, $detailx_content_start ); $i < min( strlen( $detailx_content ) - 3, $detailx_content_end ); $i++ ) {
				if ( $detailx_content[ $i ] != '<' ) {
					continue;
				}
				if ( $detailx_in_block ) {
					if ( strtolower( substr( $detailx_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$detailx_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $detailx_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $detailx_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$detailx_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $detailx_content[ $i + 1 ] && in_array( $detailx_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$detailx_p_number++;
					if ( $detailx_related_position_inside == $detailx_p_number ) {
						$detailx_related_inserted = true;
						$detailx_content = ( $i > 0 ? substr( $detailx_content, 0, $i ) : '' )
											. $detailx_related_content
											. substr( $detailx_content, $i );
					}
				}
			}
			if ( ! $detailx_related_inserted ) {
				if ( $detailx_content_end > 0 ) {
					$detailx_content = substr( $detailx_content, 0, $detailx_content_end ) . $detailx_related_content . substr( $detailx_content, $detailx_content_end );
				} else {
					$detailx_content .= $detailx_related_content;
				}
			}
		}

		detailx_show_layout( $detailx_content );
	}

	// Comments
	do_action( 'detailx_action_before_comments' );
	comments_template();
	do_action( 'detailx_action_after_comments' );

	// Related posts
	if ( 'below_content' == $detailx_related_position
		&& ( 'scroll' != $detailx_posts_navigation || detailx_get_theme_option( 'posts_navigation_scroll_hide_related' ) == 0 )
		&& ( ! $full_post_loading || detailx_get_theme_option( 'open_full_post_hide_related' ) == 0 )
	) {
		do_action( 'detailx_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $detailx_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $detailx_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $detailx_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $detailx_prev_post ) ); ?>"
			<?php do_action( 'detailx_action_nav_links_single_scroll_data', $detailx_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
