<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package DETAILX
 * @since DETAILX 1.0
 */

if ( detailx_sidebar_present() ) {
	
	$detailx_sidebar_type = detailx_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $detailx_sidebar_type && ! detailx_is_layouts_available() ) {
		$detailx_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $detailx_sidebar_type ) {
		// Default sidebar with widgets
		$detailx_sidebar_name = detailx_get_theme_option( 'sidebar_widgets' );
		detailx_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $detailx_sidebar_name ) ) {
			dynamic_sidebar( $detailx_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$detailx_sidebar_id = detailx_get_custom_sidebar_id();
		do_action( 'detailx_action_show_layout', $detailx_sidebar_id );
	}
	$detailx_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $detailx_out ) ) {
		$detailx_sidebar_position    = detailx_get_theme_option( 'sidebar_position' );
		$detailx_sidebar_position_ss = detailx_get_theme_option( 'sidebar_position_ss' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $detailx_sidebar_position );
			echo ' sidebar_' . esc_attr( $detailx_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $detailx_sidebar_type );

			$detailx_sidebar_scheme = apply_filters( 'detailx_filter_sidebar_scheme', detailx_get_theme_option( 'sidebar_scheme' ) );
			if ( ! empty( $detailx_sidebar_scheme ) && ! detailx_is_inherit( $detailx_sidebar_scheme ) && 'custom' != $detailx_sidebar_type ) {
				echo ' scheme_' . esc_attr( $detailx_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<a id="sidebar_skip_link_anchor" class="detailx_skip_link_anchor" href="#"></a>
			<?php

			do_action( 'detailx_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $detailx_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$detailx_title = apply_filters( 'detailx_filter_sidebar_control_title', 'float' == $detailx_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'detailx' ) : '' );
				$detailx_text  = apply_filters( 'detailx_filter_sidebar_control_text', 'above' == $detailx_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'detailx' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $detailx_title ); ?>"><?php echo esc_html( $detailx_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'detailx_action_before_sidebar', 'sidebar' );
				detailx_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $detailx_out ) );
				do_action( 'detailx_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'detailx_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
