<?php
/* Essential Grid support functions
------------------------------------------------------------------------------- */


// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'detailx_essential_grid_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'detailx_essential_grid_theme_setup9', 9 );
	function detailx_essential_grid_theme_setup9() {
		if ( detailx_exists_essential_grid() ) {
			add_action( 'wp_enqueue_scripts', 'detailx_essential_grid_frontend_scripts', 1100 );
			add_action( 'trx_addons_action_load_scripts_front_essential_grid', 'detailx_essential_grid_frontend_scripts', 10, 1 );
			add_filter( 'detailx_filter_merge_styles', 'detailx_essential_grid_merge_styles' );
		}
		if ( is_admin() ) {
			add_filter( 'detailx_filter_tgmpa_required_plugins', 'detailx_essential_grid_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'detailx_essential_grid_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('detailx_filter_tgmpa_required_plugins',	'detailx_essential_grid_tgmpa_required_plugins');
	function detailx_essential_grid_tgmpa_required_plugins( $list = array() ) {
		if ( detailx_storage_isset( 'required_plugins', 'essential-grid' ) && detailx_storage_get_array( 'required_plugins', 'essential-grid', 'install' ) !== false && detailx_is_theme_activated() ) {
			$path = detailx_get_plugin_source_path( 'plugins/essential-grid/essential-grid.zip' );
			if ( ! empty( $path ) || detailx_get_theme_setting( 'tgmpa_upload' ) ) {
				$list[] = array(
					'name'     => detailx_storage_get_array( 'required_plugins', 'essential-grid', 'title' ),
					'slug'     => 'essential-grid',
					'source'   => ! empty( $path ) ? $path : 'upload://essential-grid.zip',
					'version'  => '2.2.4.2',
					'required' => false,
				);
			}
		}
		return $list;
	}
}

// Check if plugin installed and activated
if ( ! function_exists( 'detailx_exists_essential_grid' ) ) {
	function detailx_exists_essential_grid() {
		return defined( 'EG_PLUGIN_PATH' ) || defined( 'ESG_PLUGIN_PATH' );
	}
}

// Enqueue styles for frontend
if ( ! function_exists( 'detailx_essential_grid_frontend_scripts' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'detailx_essential_grid_frontend_scripts', 1100 );
	//Handler of the add_action( 'trx_addons_action_load_scripts_front_essential_grid', 'detailx_essential_grid_frontend_scripts', 10, 1 );
	function detailx_essential_grid_frontend_scripts( $force = false ) {
		detailx_enqueue_optimized( 'essential_grid', $force, array(
			'css' => array(
				'detailx-essential-grid' => array( 'src' => 'plugins/essential-grid/essential-grid.css' ),
			)
		) );
	}
}

// Merge custom styles
if ( ! function_exists( 'detailx_essential_grid_merge_styles' ) ) {
	//Handler of the add_filter('detailx_filter_merge_styles', 'detailx_essential_grid_merge_styles');
	function detailx_essential_grid_merge_styles( $list ) {
		$list[ 'plugins/essential-grid/essential-grid.css' ] = false;
		return $list;
	}
}
