<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package DETAILX
 * @since DETAILX 1.0
 */

$detailx_template = apply_filters( 'detailx_filter_get_template_part', detailx_blog_archive_get_template() );

if ( ! empty( $detailx_template ) && 'index' != $detailx_template ) {

	get_template_part( $detailx_template );

} else {

	detailx_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$detailx_stickies   = is_home()
								|| ( in_array( detailx_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) detailx_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$detailx_post_type  = detailx_get_theme_option( 'post_type' );
		$detailx_args       = array(
								'blog_style'     => detailx_get_theme_option( 'blog_style' ),
								'post_type'      => $detailx_post_type,
								'taxonomy'       => detailx_get_post_type_taxonomy( $detailx_post_type ),
								'parent_cat'     => detailx_get_theme_option( 'parent_cat' ),
								'posts_per_page' => detailx_get_theme_option( 'posts_per_page' ),
								'sticky'         => detailx_get_theme_option( 'sticky_style' ) == 'columns'
															&& is_array( $detailx_stickies )
															&& count( $detailx_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		detailx_blog_archive_start();

		do_action( 'detailx_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'detailx_action_before_page_author' );
			get_template_part( apply_filters( 'detailx_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'detailx_action_after_page_author' );
		}

		if ( detailx_get_theme_option( 'show_filters' ) ) {
			do_action( 'detailx_action_before_page_filters' );
			detailx_show_filters( $detailx_args );
			do_action( 'detailx_action_after_page_filters' );
		} else {
			do_action( 'detailx_action_before_page_posts' );
			detailx_show_posts( array_merge( $detailx_args, array( 'cat' => $detailx_args['parent_cat'] ) ) );
			do_action( 'detailx_action_after_page_posts' );
		}

		do_action( 'detailx_action_blog_archive_end' );

		detailx_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'detailx_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'detailx_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
