<?php
/**
 * The Header: Logo and main menu
 *
 * @package DETAILX
 * @since DETAILX 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( detailx_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'detailx_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'detailx_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('detailx_action_body_wrap_attributes'); ?>>

		<?php do_action( 'detailx_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'detailx_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('detailx_action_page_wrap_attributes'); ?>>

			<?php do_action( 'detailx_action_page_wrap_start' ); ?>

			<?php
			$detailx_full_post_loading = ( detailx_is_singular( 'post' ) || detailx_is_singular( 'attachment' ) ) && detailx_get_value_gp( 'action' ) == 'full_post_loading';
			$detailx_prev_post_loading = ( detailx_is_singular( 'post' ) || detailx_is_singular( 'attachment' ) ) && detailx_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $detailx_full_post_loading && ! $detailx_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="detailx_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'detailx_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to content", 'detailx' ); ?></a>
				<?php if ( detailx_sidebar_present() ) { ?>
				<a class="detailx_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'detailx_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to sidebar", 'detailx' ); ?></a>
				<?php } ?>
				<a class="detailx_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'detailx_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to footer", 'detailx' ); ?></a>

				<?php
				do_action( 'detailx_action_before_header' );

				// Header
				$detailx_header_type = detailx_get_theme_option( 'header_type' );
				if ( 'custom' == $detailx_header_type && ! detailx_is_layouts_available() ) {
					$detailx_header_type = 'default';
				}
				get_template_part( apply_filters( 'detailx_filter_get_template_part', "templates/header-" . sanitize_file_name( $detailx_header_type ) ) );

				// Side menu
				if ( in_array( detailx_get_theme_option( 'menu_side' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'detailx_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				get_template_part( apply_filters( 'detailx_filter_get_template_part', 'templates/header-navi-mobile' ) );

				do_action( 'detailx_action_after_header' );

			}
			?>

			<?php do_action( 'detailx_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( detailx_is_off( detailx_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $detailx_header_type ) ) {
						$detailx_header_type = detailx_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $detailx_header_type && detailx_is_layouts_available() ) {
						$detailx_header_id = detailx_get_custom_header_id();
						if ( $detailx_header_id > 0 ) {
							$detailx_header_meta = detailx_get_custom_layout_meta( $detailx_header_id );
							if ( ! empty( $detailx_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$detailx_footer_type = detailx_get_theme_option( 'footer_type' );
					if ( 'custom' == $detailx_footer_type && detailx_is_layouts_available() ) {
						$detailx_footer_id = detailx_get_custom_footer_id();
						if ( $detailx_footer_id ) {
							$detailx_footer_meta = detailx_get_custom_layout_meta( $detailx_footer_id );
							if ( ! empty( $detailx_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'detailx_action_page_content_wrap_class', $detailx_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'detailx_filter_is_prev_post_loading', $detailx_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( detailx_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'detailx_action_page_content_wrap_data', $detailx_prev_post_loading );
			?>>
				<?php
				do_action( 'detailx_action_page_content_wrap', $detailx_full_post_loading || $detailx_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'detailx_filter_single_post_header', detailx_is_singular( 'post' ) || detailx_is_singular( 'attachment' ) ) ) {
					if ( $detailx_prev_post_loading ) {
						if ( detailx_get_theme_option( 'posts_navigation_scroll_which_block' ) != 'article' ) {
							do_action( 'detailx_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$detailx_path = apply_filters( 'detailx_filter_get_template_part', 'templates/single-styles/' . detailx_get_theme_option( 'single_style' ) );
					if ( detailx_get_file_dir( $detailx_path . '.php' ) != '' ) {
						get_template_part( $detailx_path );
					}
				}

				// Widgets area above page
				$detailx_body_style   = detailx_get_theme_option( 'body_style' );
				$detailx_widgets_name = detailx_get_theme_option( 'widgets_above_page' );
				$detailx_show_widgets = ! detailx_is_off( $detailx_widgets_name ) && is_active_sidebar( $detailx_widgets_name );
				if ( $detailx_show_widgets ) {
					if ( 'fullscreen' != $detailx_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					detailx_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $detailx_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'detailx_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $detailx_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'detailx_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'detailx_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<a id="content_skip_link_anchor" class="detailx_skip_link_anchor" href="#"></a>
						<?php
						// Single posts banner between prev/next posts
						if ( ( detailx_is_singular( 'post' ) || detailx_is_singular( 'attachment' ) )
							&& $detailx_prev_post_loading 
							&& detailx_get_theme_option( 'posts_navigation_scroll_which_block' ) == 'article'
						) {
							do_action( 'detailx_action_between_posts' );
						}

						// Widgets area above content
						detailx_create_widgets_area( 'widgets_above_content' );

						do_action( 'detailx_action_page_content_start_text' );
