<div class="front_page_section front_page_section_contacts<?php
	$detailx_scheme = detailx_get_theme_option( 'front_page_contacts_scheme' );
	if ( ! empty( $detailx_scheme ) && ! detailx_is_inherit( $detailx_scheme ) ) {
		echo ' scheme_' . esc_attr( $detailx_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( detailx_get_theme_option( 'front_page_contacts_paddings' ) );
	if ( detailx_get_theme_option( 'front_page_contacts_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$detailx_css      = '';
		$detailx_bg_image = detailx_get_theme_option( 'front_page_contacts_bg_image' );
		if ( ! empty( $detailx_bg_image ) ) {
			$detailx_css .= 'background-image: url(' . esc_url( detailx_get_attachment_url( $detailx_bg_image ) ) . ');';
		}
		if ( ! empty( $detailx_css ) ) {
			echo ' style="' . esc_attr( $detailx_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$detailx_anchor_icon = detailx_get_theme_option( 'front_page_contacts_anchor_icon' );
	$detailx_anchor_text = detailx_get_theme_option( 'front_page_contacts_anchor_text' );
if ( ( ! empty( $detailx_anchor_icon ) || ! empty( $detailx_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_contacts"'
									. ( ! empty( $detailx_anchor_icon ) ? ' icon="' . esc_attr( $detailx_anchor_icon ) . '"' : '' )
									. ( ! empty( $detailx_anchor_text ) ? ' title="' . esc_attr( $detailx_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_contacts_inner
	<?php
	if ( detailx_get_theme_option( 'front_page_contacts_fullheight' ) ) {
		echo ' detailx-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$detailx_css      = '';
			$detailx_bg_mask  = detailx_get_theme_option( 'front_page_contacts_bg_mask' );
			$detailx_bg_color_type = detailx_get_theme_option( 'front_page_contacts_bg_color_type' );
			if ( 'custom' == $detailx_bg_color_type ) {
				$detailx_bg_color = detailx_get_theme_option( 'front_page_contacts_bg_color' );
			} elseif ( 'scheme_bg_color' == $detailx_bg_color_type ) {
				$detailx_bg_color = detailx_get_scheme_color( 'bg_color', $detailx_scheme );
			} else {
				$detailx_bg_color = '';
			}
			if ( ! empty( $detailx_bg_color ) && $detailx_bg_mask > 0 ) {
				$detailx_css .= 'background-color: ' . esc_attr(
					1 == $detailx_bg_mask ? $detailx_bg_color : detailx_hex2rgba( $detailx_bg_color, $detailx_bg_mask )
				) . ';';
			}
			if ( ! empty( $detailx_css ) ) {
				echo ' style="' . esc_attr( $detailx_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_contacts_content_wrap content_wrap">
			<?php

			// Title and description
			$detailx_caption     = detailx_get_theme_option( 'front_page_contacts_caption' );
			$detailx_description = detailx_get_theme_option( 'front_page_contacts_description' );
			if ( ! empty( $detailx_caption ) || ! empty( $detailx_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				// Caption
				if ( ! empty( $detailx_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_contacts_caption front_page_block_<?php echo ! empty( $detailx_caption ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( $detailx_caption, 'detailx_kses_content' );
					?>
					</h2>
					<?php
				}

				// Description
				if ( ! empty( $detailx_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_contacts_description front_page_block_<?php echo ! empty( $detailx_description ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( wpautop( $detailx_description ), 'detailx_kses_content' );
					?>
					</div>
					<?php
				}
			}

			// Content (text)
			$detailx_content = detailx_get_theme_option( 'front_page_contacts_content' );
			$detailx_layout  = detailx_get_theme_option( 'front_page_contacts_layout' );
			if ( 'columns' == $detailx_layout && ( ! empty( $detailx_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_columns front_page_section_contacts_columns columns_wrap">
					<div class="column-1_3">
				<?php
			}

			if ( ( ! empty( $detailx_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_content front_page_section_contacts_content front_page_block_<?php echo ! empty( $detailx_content ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( $detailx_content, 'detailx_kses_content' );
					?>
				</div>
				<?php
			}

			if ( 'columns' == $detailx_layout && ( ! empty( $detailx_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div><div class="column-2_3">
				<?php
			}

			// Shortcode output
			$detailx_sc = detailx_get_theme_option( 'front_page_contacts_shortcode' );
			if ( ! empty( $detailx_sc ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_output front_page_section_contacts_output front_page_block_<?php echo ! empty( $detailx_sc ) ? 'filled' : 'empty'; ?>">
					<?php
					detailx_show_layout( do_shortcode( $detailx_sc ) );
					?>
				</div>
				<?php
			}

			if ( 'columns' == $detailx_layout && ( ! empty( $detailx_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div></div>
				<?php
			}
			?>

		</div>
	</div>
</div>
