<div class="front_page_section front_page_section_about<?php
	$detailx_scheme = detailx_get_theme_option( 'front_page_about_scheme' );
	if ( ! empty( $detailx_scheme ) && ! detailx_is_inherit( $detailx_scheme ) ) {
		echo ' scheme_' . esc_attr( $detailx_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( detailx_get_theme_option( 'front_page_about_paddings' ) );
	if ( detailx_get_theme_option( 'front_page_about_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$detailx_css      = '';
		$detailx_bg_image = detailx_get_theme_option( 'front_page_about_bg_image' );
		if ( ! empty( $detailx_bg_image ) ) {
			$detailx_css .= 'background-image: url(' . esc_url( detailx_get_attachment_url( $detailx_bg_image ) ) . ');';
		}
		if ( ! empty( $detailx_css ) ) {
			echo ' style="' . esc_attr( $detailx_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$detailx_anchor_icon = detailx_get_theme_option( 'front_page_about_anchor_icon' );
	$detailx_anchor_text = detailx_get_theme_option( 'front_page_about_anchor_text' );
if ( ( ! empty( $detailx_anchor_icon ) || ! empty( $detailx_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_about"'
									. ( ! empty( $detailx_anchor_icon ) ? ' icon="' . esc_attr( $detailx_anchor_icon ) . '"' : '' )
									. ( ! empty( $detailx_anchor_text ) ? ' title="' . esc_attr( $detailx_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_about_inner
	<?php
	if ( detailx_get_theme_option( 'front_page_about_fullheight' ) ) {
		echo ' detailx-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$detailx_css           = '';
			$detailx_bg_mask       = detailx_get_theme_option( 'front_page_about_bg_mask' );
			$detailx_bg_color_type = detailx_get_theme_option( 'front_page_about_bg_color_type' );
			if ( 'custom' == $detailx_bg_color_type ) {
				$detailx_bg_color = detailx_get_theme_option( 'front_page_about_bg_color' );
			} elseif ( 'scheme_bg_color' == $detailx_bg_color_type ) {
				$detailx_bg_color = detailx_get_scheme_color( 'bg_color', $detailx_scheme );
			} else {
				$detailx_bg_color = '';
			}
			if ( ! empty( $detailx_bg_color ) && $detailx_bg_mask > 0 ) {
				$detailx_css .= 'background-color: ' . esc_attr(
					1 == $detailx_bg_mask ? $detailx_bg_color : detailx_hex2rgba( $detailx_bg_color, $detailx_bg_mask )
				) . ';';
			}
			if ( ! empty( $detailx_css ) ) {
				echo ' style="' . esc_attr( $detailx_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_about_content_wrap content_wrap">
			<?php
			// Caption
			$detailx_caption = detailx_get_theme_option( 'front_page_about_caption' );
			if ( ! empty( $detailx_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<h2 class="front_page_section_caption front_page_section_about_caption front_page_block_<?php echo ! empty( $detailx_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $detailx_caption, 'detailx_kses_content' ); ?></h2>
				<?php
			}

			// Description (text)
			$detailx_description = detailx_get_theme_option( 'front_page_about_description' );
			if ( ! empty( $detailx_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_description front_page_section_about_description front_page_block_<?php echo ! empty( $detailx_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $detailx_description ), 'detailx_kses_content' ); ?></div>
				<?php
			}

			// Content
			$detailx_content = detailx_get_theme_option( 'front_page_about_content' );
			if ( ! empty( $detailx_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_content front_page_section_about_content front_page_block_<?php echo ! empty( $detailx_content ) ? 'filled' : 'empty'; ?>">
					<?php
					$detailx_page_content_mask = '%%CONTENT%%';
					if ( strpos( $detailx_content, $detailx_page_content_mask ) !== false ) {
						$detailx_content = preg_replace(
							'/(\<p\>\s*)?' . $detailx_page_content_mask . '(\s*\<\/p\>)/i',
							sprintf(
								'<div class="front_page_section_about_source">%s</div>',
								apply_filters( 'the_content', get_the_content() )
							),
							$detailx_content
						);
					}
					detailx_show_layout( $detailx_content );
					?>
				</div>
				<?php
			}
			?>
		</div>
	</div>
</div>
