<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package DETAILX
 * @since DETAILX 1.0
 */

							do_action( 'detailx_action_page_content_end_text' );
							
							// Widgets area below the content
							detailx_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'detailx_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'detailx_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'detailx_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'detailx_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$detailx_body_style = detailx_get_theme_option( 'body_style' );
					$detailx_widgets_name = detailx_get_theme_option( 'widgets_below_page' );
					$detailx_show_widgets = ! detailx_is_off( $detailx_widgets_name ) && is_active_sidebar( $detailx_widgets_name );
					$detailx_show_related = detailx_is_single() && detailx_get_theme_option( 'related_position' ) == 'below_page';
					if ( $detailx_show_widgets || $detailx_show_related ) {
						if ( 'fullscreen' != $detailx_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $detailx_show_related ) {
							do_action( 'detailx_action_related_posts' );
						}

						// Widgets area below page content
						if ( $detailx_show_widgets ) {
							detailx_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $detailx_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'detailx_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'detailx_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! detailx_is_singular( 'post' ) && ! detailx_is_singular( 'attachment' ) ) || ! in_array ( detailx_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<a id="footer_skip_link_anchor" class="detailx_skip_link_anchor" href="#"></a>
				<?php

				do_action( 'detailx_action_before_footer' );

				// Footer
				$detailx_footer_type = detailx_get_theme_option( 'footer_type' );
				if ( 'custom' == $detailx_footer_type && ! detailx_is_layouts_available() ) {
					$detailx_footer_type = 'default';
				}
				get_template_part( apply_filters( 'detailx_filter_get_template_part', "templates/footer-" . sanitize_file_name( $detailx_footer_type ) ) );

				do_action( 'detailx_action_after_footer' );

			}
			?>

			<?php do_action( 'detailx_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'detailx_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'detailx_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>