<?php /** * Functions and definitions * * @link 
 https://developer.wordpress.org/themes/basics/theme-functions/ * * @package Razzi 
 */

require_once get_template_directory() . '/inc/class-razzi-theme.php';

\Razzi\Theme::instance();


// Display product names in the WooCommerce admin order list
function show_product_names_in_order_list($columns) {
    $columns['product_names'] = 'Products';
    return $columns;
}
add_filter('manage_edit-shop_order_columns', 'show_product_names_in_order_list');

function show_product_names_in_order_column($column, $post_id) {
    if ($column == 'product_names') {
        $order = wc_get_order($post_id);
        $items = $order->get_items();
        $product_names = [];

        foreach ($items as $item) {
            $product_names[] = $item->get_name();
        }

        echo implode(', ', $product_names);
    }
}


add_action('manage_shop_order_posts_custom_column', 'show_product_names_in_order_column', 10, 2);

// Display shipping phone number in the WooCommerce admin order list
function show_shipping_phone_in_order_list($columns) {
    $columns['shipping_phone'] = 'Shipping Phone';
    return $columns;
}
add_filter('manage_edit-shop_order_columns', 'show_shipping_phone_in_order_list');

function show_shipping_phone_in_order_column($column, $post_id) {
    if ($column == 'shipping_phone') {
        $order = wc_get_order($post_id);
        $shipping_phone = $order->get_billing_phone();
        echo $shipping_phone;
    }
}
add_action('manage_shop_order_posts_custom_column', 'show_shipping_phone_in_order_column', 10, 2);


// Add notice to the checkout page before order notes
add_action( 'woocommerce_before_order_notes', 'ts_notice_shipping' );

// Add notice to individual product pages
add_action( 'woocommerce_single_product_summary', 'ts_notice_shipping', 20 );

function ts_notice_shipping() {
    echo '<h3 style="font-size:18px; color: red;" class="allow">Please allow 5-7 business days for delivery after order processing.</h3>
    <h3 style="color: red;">Important Notice</h3>
    <p style="color: red;">Please note that delivery times may vary during high-demand periods or due to unforeseen circumstances. Additionally, as Saturdays and Sundays are non-working days, delivery dates may vary accordingly. We appreciate your understanding in such cases.</p>
    <p style="color: red;">If you have any questions or concerns regarding shipping and delivery, please feel free to <a href="tel:+91 9962700810">contact our customer support</a>.</p>';
}


add_action('wp_footer', 'add_fb_initiate_checkout_script');
function add_fb_initiate_checkout_script() {
    if (is_checkout()) {
        $cart_total = WC()->cart->get_total('edit'); // Raw total without formatting
        $cart_total = floatval(preg_replace('/[^0-9.]/', '', $cart_total)); // Strip symbols
        ?>
        <script>
          var cartTotalValue = <?php echo json_encode($cart_total); ?>;
          fbq('track', 'InitiateCheckout', {
            value: cartTotalValue,
            currency: 'INR'
          });
        </script>
        <?php
    }
}

add_action('wp_head', 'add_global_gtag');
function add_global_gtag() {
    ?>
    <!-- Global site tag (gtag.js) - Google Ads -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=AW-16539905885"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());

      gtag('config', 'AW-16539905885');
    </script>
    <?php
}

add_action('wp_footer', 'add_woocommerce_conversion_snippets');
function add_woocommerce_conversion_snippets() {
    // Add to Cart - optional, shown on Cart page load
    if (is_cart()) {
        ?>
        <!-- Event snippet for Add to cart conversion page -->
        <script>
          gtag('event', 'conversion', {
              'send_to': 'AW-16539905885/SBIQCNXigM8aEN3e6849'
          });
        </script>
        <?php
    }

    // Begin Checkout
    if (is_checkout() && !is_wc_endpoint_url('order-received')) {
        ?>
        <!-- Event snippet for Begin checkout conversion page -->
        <script>
          gtag('event', 'conversion', {
              'send_to': 'AW-16539905885/YOucCK7rgM8aEN3e6849'
          }); 
        </script>
        <?php
    }

    // Order Received Page
    if (is_order_received_page()) {
        $order_id = absint(get_query_var('order-received'));
        if ($order_id) {
            ?>
            <!-- Event snippet for Order Received conversion page -->
            <script>
              gtag('event', 'conversion', {
                  'send_to': 'AW-16539905885/W3XlCNLigM8aEN3e6849',
                  'transaction_id': '<?php echo esc_js($order_id); ?>'
              });
            </script>
            <?php
        }
    }
}