<?php

namespace Simple_History\Dropins;

use Simple_History\Helpers;

/**
 * Loads the new GUI based on React.
 */
class React_Dropin extends Dropin {
	/** @inheritdoc */
	public function loaded() {
		add_action( 'simple_history/history_page/gui_wrap_top', [ $this, 'output_element_page' ], 1 );
		add_action( 'simple_history/dashboard/before_gui', [ $this, 'output_element_dashboard' ], 1 );
		add_action( 'simple_history/enqueue_admin_scripts', [ $this, 'enqueue_admin_scripts' ] );
	}

	/**
	 * Enqueue scripts generated by wp-scripts.
	 */
	public function enqueue_admin_scripts() {
		// Bail if not a Simple History page so no unneeded scripts are loaded.
		if ( ! Helpers::is_on_our_own_pages() ) {
			return;
		}

		$asset_file = include SIMPLE_HISTORY_PATH . 'build/index.asset.php';

		// Load the WP components CSS or some components will be unstyled.
		wp_enqueue_style( 'wp-components' );

		wp_register_script(
			'simple_history_wp_scripts',
			SIMPLE_HISTORY_DIR_URL . 'build/index.js',
			$asset_file['dependencies'],
			$asset_file['version'],
			true
		);

		wp_enqueue_script( 'simple_history_wp_scripts' );
		wp_set_script_translations( 'simple_history_wp_scripts', 'simple-history' );
	}

	/**
	 * Output HTML element on the history page for React to mount on.
	 */
	public function output_element_page() {
		?>
		<div 
			id="simple-history-react-root" 
			class="SimpleHistoryReactRoot is-page"
			style="<?php echo esc_attr( $this->get_css_style_vars() ); ?>"
		>Loading</div>
		<?php
	}

	/**
	 * Output HTML element on the dashboard for React to mount on.
	 */
	public function output_element_dashboard() {
		$this->get_current_theme_colors();
		?>
		<div 
			id="simple-history-react-root" 
			class="SimpleHistoryReactRoot is-dashboard" 
			style="<?php echo esc_attr( $this->get_css_style_vars() ); ?>"
		>Loading</div>
		<?php
	}

	/**
	 * Generate css style attributes to use at the react root element.
	 * This is to override the Gutenberg colors that are not the same as the admin theme colors.
	 * For example the blue color in the Gutenberg editor is not the same as the admin theme color.
	 *
	 * @return string
	 */
	private function get_css_style_vars() {
		$colors = $this->get_current_theme_colors();

		$css_vars = [
			'--wp-admin-theme-color' => $colors['link'],
		];

		$css_vars_string = '';
		foreach ( $css_vars as $key => $value ) {
			$css_vars_string = $css_vars_string . $key . ':' . $value . ';';
		}

		return $css_vars_string;
	}

	/**
	 * Get the current theme colors.
	 *
	 * @return array<string, string> An associative array containing the theme colors.
	 */
	private function get_current_theme_colors() {
		$color_scheme = get_user_option( 'admin_color' );

		$colors = [
			'default' => [
				'link' => '#0073aa',
				'link_focus' => '#135e96',
			],
			// "modern" is the only one with a different color scheme.
			'modern' => [
				'link' => '#3858e9',
				'link_focus' => '#183ad6',
			],
		];

		if ( $color_scheme === 'modern' ) {
			$colors = $colors['modern'];
		} else {
			$colors = $colors['default'];
		}

		return $colors;
	}
}
