(function(){"use strict";var t=this,i=t.Chart,e=function(t){this.canvas=t.canvas,this.ctx=t;var i=function(t,i){return t["offset"+i]?t["offset"+i]:document.defaultView.getComputedStyle(t).getPropertyValue(i)};this.width=i(t.canvas,"Width")||t.canvas.width,this.height=i(t.canvas,"Height")||t.canvas.height;return this.width=t.canvas.width,this.height=t.canvas.height,this.aspectRatio=this.width/this.height,o.retinaScale(this),this};e.defaults={global:{animation:!0,animationSteps:60,animationEasing:"easeOutQuart",showScale:!0,scaleOverride:!1,scaleSteps:null,scaleStepWidth:null,scaleStartValue:null,scaleLineColor:"rgba(0,0,0,.1)",scaleLineWidth:1,scaleShowLabels:!0,scaleLabel:"<%=value%>",scaleIntegersOnly:!0,scaleBeginAtZero:!1,scaleFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",scaleFontSize:12,scaleFontStyle:"normal",scaleFontColor:"#666",responsive:!1,maintainAspectRatio:!0,showTooltips:!0,customTooltips:!1,tooltipEvents:["mousemove","touchstart","touchmove","mouseout"],tooltipFillColor:"rgba(0,0,0,0.8)",tooltipFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",tooltipFontSize:14,tooltipFontStyle:"normal",tooltipFontColor:"#fff",tooltipTitleFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",tooltipTitleFontSize:14,tooltipTitleFontStyle:"bold",tooltipTitleFontColor:"#fff",tooltipTitleTemplate:"<%= label%>",tooltipYPadding:6,tooltipXPadding:6,tooltipCaretSize:8,tooltipCornerRadius:6,tooltipXOffset:10,tooltipTemplate:"<%if (label){%><%=label%>: <%}%><%= value %>",multiTooltipTemplate:"<%= datasetLabel %>: <%= value %>",multiTooltipKeyBackground:"#fff",segmentColorDefault:["#A6CEE3","#1F78B4","#B2DF8A","#33A02C","#FB9A99","#E31A1C","#FDBF6F","#FF7F00","#CAB2D6","#6A3D9A","#B4B482","#B15928"],segmentHighlightColorDefaults:["#CEF6FF","#47A0DC","#DAFFB2","#5BC854","#FFC2C1","#FF4244","#FFE797","#FFA728","#F2DAFE","#9265C2","#DCDCAA","#D98150"],onAnimationProgress:function(){},onAnimationComplete:function(){}}},e.types={};var s,n,o=e.helpers={},a=o.each=function(t,i,e){var s,n=Array.prototype.slice.call(arguments,3);if(t)if(t.length===+t.length)for(s=0;s<t.length;s++)i.apply(e,[t[s],s].concat(n));else for(var o in t)i.apply(e,[t[o],o].concat(n))},h=o.clone=function(t){var i={};return a(t,(function(e,s){t.hasOwnProperty(s)&&(i[s]=e)})),i},l=o.extend=function(t){return a(Array.prototype.slice.call(arguments,1),(function(i){a(i,(function(e,s){i.hasOwnProperty(s)&&(t[s]=e)}))})),t},r=o.merge=function(t,i){var e=Array.prototype.slice.call(arguments,0);return e.unshift({}),l.apply(null,e)},c=o.indexOf=function(t,i){if(Array.prototype.indexOf)return t.indexOf(i);for(var e=0;e<t.length;e++)if(t[e]===i)return e;return-1},u=(o.where=function(t,i){var e=[];return o.each(t,(function(t){i(t)&&e.push(t)})),e},o.findNextWhere=function(t,i,e){e||(e=-1);for(var s=e+1;s<t.length;s++){var n=t[s];if(i(n))return n}},o.findPreviousWhere=function(t,i,e){e||(e=t.length);for(var s=e-1;s>=0;s--){var n=t[s];if(i(n))return n}},o.inherits=function(t){var i=this,e=t&&t.hasOwnProperty("constructor")?t.constructor:function(){return i.apply(this,arguments)},s=function(){this.constructor=e};return s.prototype=i.prototype,e.prototype=new s,e.extend=u,t&&l(e.prototype,t),e.__super__=i.prototype,e}),d=o.noop=function(){},p=o.uid=(s=0,function(){return"chart-"+s++}),f=o.warn=function(t){window.console&&"function"==typeof window.console.warn&&console.warn(t)},g=o.amd="function"==typeof define&&define.amd,m=o.isNumber=function(t){return!isNaN(parseFloat(t))&&isFinite(t)},v=o.max=function(t){return Math.max.apply(Math,t)},S=o.min=function(t){return Math.min.apply(Math,t)},C=(o.cap=function(t,i,e){if(m(i)){if(t>i)return i}else if(m(e)&&t<e)return e;return t},o.getDecimalPlaces=function(t){if(t%1!=0&&m(t)){var i=t.toString();if(i.indexOf("e-")<0)return i.split(".")[1].length;if(i.indexOf(".")<0)return parseInt(i.split("e-")[1]);var e=i.split(".")[1].split("e-");return e[0].length+parseInt(e[1])}return 0}),x=o.radians=function(t){return t*(Math.PI/180)},y=(o.getAngleFromPoint=function(t,i){var e=i.x-t.x,s=i.y-t.y,n=Math.sqrt(e*e+s*s),o=2*Math.PI+Math.atan2(s,e);return e<0&&s<0&&(o+=2*Math.PI),{angle:o,distance:n}},o.aliasPixel=function(t){return t%2==0?0:.5}),b=(o.splineCurve=function(t,i,e,s){var n=Math.sqrt(Math.pow(i.x-t.x,2)+Math.pow(i.y-t.y,2)),o=Math.sqrt(Math.pow(e.x-i.x,2)+Math.pow(e.y-i.y,2)),a=s*n/(n+o),h=s*o/(n+o);return{inner:{x:i.x-a*(e.x-t.x),y:i.y-a*(e.y-t.y)},outer:{x:i.x+h*(e.x-t.x),y:i.y+h*(e.y-t.y)}}},o.calculateOrderOfMagnitude=function(t){return Math.floor(Math.log(t)/Math.LN10)}),w=(o.calculateScaleRange=function(t,i,e,s,n){var o=Math.floor(i/(1.5*e)),h=2>=o,l=[];a(t,(function(t){null==t||l.push(t)}));var r=S(l),c=v(l);c===r&&(c+=.5,r>=.5&&!s?r-=.5:c+=.5);for(var u=Math.abs(c-r),d=b(u),p=Math.ceil(c/(1*Math.pow(10,d)))*Math.pow(10,d),f=s?0:Math.floor(r/(1*Math.pow(10,d)))*Math.pow(10,d),g=p-f,m=Math.pow(10,d),C=Math.round(g/m);(C>o||2*C<o)&&!h;)if(C>o)m*=2,(C=Math.round(g/m))%1!=0&&(h=!0);else if(n&&d>=0){if(m/2%1!=0)break;m/=2,C=Math.round(g/m)}else m/=2,C=Math.round(g/m);return h&&(m=g/(C=2)),{steps:C,stepValue:m,min:f,max:f+C*m}},o.template=function(t,i){if(t instanceof Function)return t(i);var e,s,n,o={};return s=i,n=/\W/.test(e=t)?new Function("obj","var p=[],print=function(){p.push.apply(p,arguments);};with(obj){p.push('"+e.replace(/[\r\t\n]/g," ").split("<%").join("\t").replace(/((^|%>)[^\t]*)'/g,"$1\r").replace(/\t=(.*?)%>/g,"',$1,'").split("\t").join("');").split("%>").join("p.push('").split("\r").join("\\'")+"');}return p.join('');"):o[e]=o[e],s?n(s):n}),P=(o.generateLabels=function(t,i,e,s){var n=new Array(i);return t&&a(n,(function(i,o){n[o]=w(t,{value:e+s*(o+1)})})),n},o.easingEffects={linear:function(t){return t},easeInQuad:function(t){return t*t},easeOutQuad:function(t){return-1*t*(t-2)},easeInOutQuad:function(t){return(t/=.5)<1?.5*t*t:-.5*(--t*(t-2)-1)},easeInCubic:function(t){return t*t*t},easeOutCubic:function(t){return 1*((t=t/1-1)*t*t+1)},easeInOutCubic:function(t){return(t/=.5)<1?.5*t*t*t:.5*((t-=2)*t*t+2)},easeInQuart:function(t){return t*t*t*t},easeOutQuart:function(t){return-1*((t=t/1-1)*t*t*t-1)},easeInOutQuart:function(t){return(t/=.5)<1?.5*t*t*t*t:-.5*((t-=2)*t*t*t-2)},easeInQuint:function(t){return 1*(t/=1)*t*t*t*t},easeOutQuint:function(t){return 1*((t=t/1-1)*t*t*t*t+1)},easeInOutQuint:function(t){return(t/=.5)<1?.5*t*t*t*t*t:.5*((t-=2)*t*t*t*t+2)},easeInSine:function(t){return-1*Math.cos(t/1*(Math.PI/2))+1},easeOutSine:function(t){return 1*Math.sin(t/1*(Math.PI/2))},easeInOutSine:function(t){return-.5*(Math.cos(Math.PI*t/1)-1)},easeInExpo:function(t){return 0===t?1:1*Math.pow(2,10*(t/1-1))},easeOutExpo:function(t){return 1===t?1:1*(1-Math.pow(2,-10*t/1))},easeInOutExpo:function(t){return 0===t?0:1===t?1:(t/=.5)<1?.5*Math.pow(2,10*(t-1)):.5*(2-Math.pow(2,-10*--t))},easeInCirc:function(t){return t>=1?t:-1*(Math.sqrt(1-(t/=1)*t)-1)},easeOutCirc:function(t){return 1*Math.sqrt(1-(t=t/1-1)*t)},easeInOutCirc:function(t){return(t/=.5)<1?-.5*(Math.sqrt(1-t*t)-1):.5*(Math.sqrt(1-(t-=2)*t)+1)},easeInElastic:function(t){var i=1.70158,e=0,s=1;return 0===t?0:1==(t/=1)?1:(e||(e=.3),s<Math.abs(1)?(s=1,i=e/4):i=e/(2*Math.PI)*Math.asin(1/s),-s*Math.pow(2,10*(t-=1))*Math.sin((1*t-i)*(2*Math.PI)/e))},easeOutElastic:function(t){var i=1.70158,e=0,s=1;return 0===t?0:1==(t/=1)?1:(e||(e=.3),s<Math.abs(1)?(s=1,i=e/4):i=e/(2*Math.PI)*Math.asin(1/s),s*Math.pow(2,-10*t)*Math.sin((1*t-i)*(2*Math.PI)/e)+1)},easeInOutElastic:function(t){var i=1.70158,e=0,s=1;return 0===t?0:2==(t/=.5)?1:(e||(e=.3*1.5*1),s<Math.abs(1)?(s=1,i=e/4):i=e/(2*Math.PI)*Math.asin(1/s),t<1?s*Math.pow(2,10*(t-=1))*Math.sin((1*t-i)*(2*Math.PI)/e)*-.5:s*Math.pow(2,-10*(t-=1))*Math.sin((1*t-i)*(2*Math.PI)/e)*.5+1)},easeInBack:function(t){var i=1.70158;return 1*(t/=1)*t*((i+1)*t-i)},easeOutBack:function(t){var i=1.70158;return 1*((t=t/1-1)*t*((i+1)*t+i)+1)},easeInOutBack:function(t){var i=1.70158;return(t/=.5)<1?t*t*((1+(i*=1.525))*t-i)*.5:.5*((t-=2)*t*((1+(i*=1.525))*t+i)+2)},easeInBounce:function(t){return 1-P.easeOutBounce(1-t)},easeOutBounce:function(t){return(t/=1)<1/2.75?7.5625*t*t*1:t<2/2.75?1*(7.5625*(t-=1.5/2.75)*t+.75):t<2.5/2.75?1*(7.5625*(t-=2.25/2.75)*t+.9375):1*(7.5625*(t-=2.625/2.75)*t+.984375)},easeInOutBounce:function(t){return t<.5?.5*P.easeInBounce(2*t):.5*P.easeOutBounce(2*t-1)+.5}}),L=o.requestAnimFrame=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(t){return window.setTimeout(t,1e3/60)},k=(o.cancelAnimFrame=window.cancelAnimationFrame||window.webkitCancelAnimationFrame||window.mozCancelAnimationFrame||window.oCancelAnimationFrame||window.msCancelAnimationFrame||function(t){return window.clearTimeout(t,1e3/60)},o.animationLoop=function(t,i,e,s,n,o){var a=0,h=P[e]||P.linear,l=function(){var e=++a/i,r=h(e);t.call(o,r,e,a),s.call(o,r,e),a<i?o.animationFrame=L(l):n.apply(o)};L(l)},o.getRelativePosition=function(t){var i,e,s=t.originalEvent||t,n=(t.currentTarget||t.srcElement).getBoundingClientRect();return s.touches?(i=s.touches[0].clientX-n.left,e=s.touches[0].clientY-n.top):(i=s.clientX-n.left,e=s.clientY-n.top),{x:i,y:e}},o.addEvent=function(t,i,e){t.addEventListener?t.addEventListener(i,e):t.attachEvent?t.attachEvent("on"+i,e):t["on"+i]=e}),F=o.removeEvent=function(t,i,e){t.removeEventListener?t.removeEventListener(i,e,!1):t.detachEvent?t.detachEvent("on"+i,e):t["on"+i]=d},A=(o.bindEvents=function(t,i,e){t.events||(t.events={}),a(i,(function(i){t.events[i]=function(){e.apply(t,arguments)},k(t.chart.canvas,i,t.events[i])}))},o.unbindEvents=function(t,i){a(i,(function(i,e){F(t.chart.canvas,e,i)}))}),R=o.getMaximumWidth=function(t){var i=t.parentNode,e=parseInt(M(i,"padding-left"))+parseInt(M(i,"padding-right"));return i?i.clientWidth-e:0},T=o.getMaximumHeight=function(t){var i=t.parentNode,e=parseInt(M(i,"padding-bottom"))+parseInt(M(i,"padding-top"));return i?i.clientHeight-e:0},M=o.getStyle=function(t,i){return t.currentStyle?t.currentStyle[i]:document.defaultView.getComputedStyle(t,null).getPropertyValue(i)},W=(o.getMaximumSize=o.getMaximumWidth,o.retinaScale=function(t){var i=t.ctx,e=t.canvas.width,s=t.canvas.height;window.devicePixelRatio&&(i.canvas.style.width=e+"px",i.canvas.style.height=s+"px",i.canvas.height=s*window.devicePixelRatio,i.canvas.width=e*window.devicePixelRatio,i.scale(window.devicePixelRatio,window.devicePixelRatio))}),z=o.clear=function(t){t.ctx.clearRect(0,0,t.width,t.height)},B=o.fontString=function(t,i,e){return i+" "+t+"px "+e},O=o.longestText=function(t,i,e){t.font=i;var s=0;return a(e,(function(i){var e=t.measureText(i).width;s=e>s?e:s})),s},I=o.drawRoundedRectangle=function(t,i,e,s,n,o){t.beginPath(),t.moveTo(i+o,e),t.lineTo(i+s-o,e),t.quadraticCurveTo(i+s,e,i+s,e+o),t.lineTo(i+s,e+n-o),t.quadraticCurveTo(i+s,e+n,i+s-o,e+n),t.lineTo(i+o,e+n),t.quadraticCurveTo(i,e+n,i,e+n-o),t.lineTo(i,e+o),t.quadraticCurveTo(i,e,i+o,e),t.closePath()};e.instances={},l((e.Type=function(t,i,s){this.options=i,this.chart=s,this.id=p(),e.instances[this.id]=this,i.responsive&&this.resize(),this.initialize.call(this,t)}).prototype,{initialize:function(){return this},clear:function(){return z(this.chart),this},stop:function(){return e.animationService.cancelAnimation(this),this},resize:function(t){this.stop();var i=this.chart.canvas,e=R(this.chart.canvas),s=this.options.maintainAspectRatio?e/this.chart.aspectRatio:T(this.chart.canvas);return i.width=this.chart.width=e,i.height=this.chart.height=s,W(this.chart),"function"==typeof t&&t.apply(this,Array.prototype.slice.call(arguments,1)),this},reflow:d,render:function(t){if(t&&this.reflow(),this.options.animation&&!t){var i=new e.Animation;i.numSteps=this.options.animationSteps,i.easing=this.options.animationEasing,i.render=function(t,i){var e=o.easingEffects[i.easing],s=i.currentStep/i.numSteps,n=e(s);t.draw(n,s,i.currentStep)},i.onAnimationProgress=this.options.onAnimationProgress,i.onAnimationComplete=this.options.onAnimationComplete,e.animationService.addAnimation(this,i)}else this.draw(),this.options.onAnimationComplete.call(this);return this},generateLegend:function(){return o.template(this.options.legendTemplate,{datasets:this.datasets})},destroy:function(){this.stop(),this.clear(),A(this,this.events);var t=this.chart.canvas;t.width=this.chart.width,t.height=this.chart.height,t.style.removeProperty?(t.style.removeProperty("width"),t.style.removeProperty("height")):(t.style.removeAttribute("width"),t.style.removeAttribute("height")),delete e.instances[this.id]},showTooltip:function(t,i){if(void 0===this.activeElements&&(this.activeElements=[]),function(t){var i=!1;return t.length!==this.activeElements.length?i=!0:(a(t,(function(t,e){t!==this.activeElements[e]&&(i=!0)}),this),i)}.call(this,t)||i){if(this.activeElements=t,this.draw(),this.options.customTooltips&&this.options.customTooltips(!1),t.length>0)if(this.datasets&&this.datasets.length>1){for(var s,n,h=this.datasets.length-1;h>=0&&(s=this.datasets[h].points||this.datasets[h].bars||this.datasets[h].segments,-1===(n=c(s,t[0])));h--);var l=[],r=[],u=function(t){var i,e,s,a,h,c=[],u=[],d=[];return o.each(this.datasets,(function(t){(i=t.points||t.bars||t.segments)[n]&&i[n].hasValue()&&c.push(i[n])})),o.each(c,(function(t){u.push(t.x),d.push(t.y),l.push(o.template(this.options.multiTooltipTemplate,t)),r.push({fill:t._saved.fillColor||t.fillColor,stroke:t._saved.strokeColor||t.strokeColor})}),this),h=S(d),s=v(d),a=S(u),e=v(u),{x:a>this.chart.width/2?a:e,y:(h+s)/2}}.call(this,n);new e.MultiTooltip({x:u.x,y:u.y,xPadding:this.options.tooltipXPadding,yPadding:this.options.tooltipYPadding,xOffset:this.options.tooltipXOffset,fillColor:this.options.tooltipFillColor,textColor:this.options.tooltipFontColor,fontFamily:this.options.tooltipFontFamily,fontStyle:this.options.tooltipFontStyle,fontSize:this.options.tooltipFontSize,titleTextColor:this.options.tooltipTitleFontColor,titleFontFamily:this.options.tooltipTitleFontFamily,titleFontStyle:this.options.tooltipTitleFontStyle,titleFontSize:this.options.tooltipTitleFontSize,cornerRadius:this.options.tooltipCornerRadius,labels:l,legendColors:r,legendColorBackground:this.options.multiTooltipKeyBackground,title:w(this.options.tooltipTitleTemplate,t[0]),chart:this.chart,ctx:this.chart.ctx,custom:this.options.customTooltips}).draw()}else a(t,(function(t){var i=t.tooltipPosition();new e.Tooltip({x:Math.round(i.x),y:Math.round(i.y),xPadding:this.options.tooltipXPadding,yPadding:this.options.tooltipYPadding,fillColor:this.options.tooltipFillColor,textColor:this.options.tooltipFontColor,fontFamily:this.options.tooltipFontFamily,fontStyle:this.options.tooltipFontStyle,fontSize:this.options.tooltipFontSize,caretHeight:this.options.tooltipCaretSize,cornerRadius:this.options.tooltipCornerRadius,text:w(this.options.tooltipTemplate,t),chart:this.chart,custom:this.options.customTooltips}).draw()}),this);return this}},toBase64Image:function(){return this.chart.canvas.toDataURL.apply(this.chart.canvas,arguments)}}),e.Type.extend=function(t){var i=this,s=function(){return i.apply(this,arguments)};if(s.prototype=h(i.prototype),l(s.prototype,t),s.extend=e.Type.extend,t.name||i.prototype.name){var n=t.name||i.prototype.name,o=e.defaults[i.prototype.name]?h(e.defaults[i.prototype.name]):{};e.defaults[n]=l(o,t.defaults),e.types[n]=s,e.prototype[n]=function(t,i){var o=r(e.defaults.global,e.defaults[n],i||{});return new s(t,o,this)}}else f("Name not provided for this chart, so it hasn't been registered");return i},e.Element=function(t){l(this,t),this.initialize.apply(this,arguments),this.save()},l(e.Element.prototype,{initialize:function(){},restore:function(t){return t?a(t,(function(t){this[t]=this._saved[t]}),this):l(this,this._saved),this},save:function(){return this._saved=h(this),delete this._saved._saved,this},update:function(t){return a(t,(function(t,i){this._saved[i]=this[i],this[i]=t}),this),this},transition:function(t,i){return a(t,(function(t,e){this[e]=(t-this._saved[e])*i+this._saved[e]}),this),this},tooltipPosition:function(){return{x:this.x,y:this.y}},hasValue:function(){return m(this.value)}}),e.Element.extend=u,e.Point=e.Element.extend({display:!0,inRange:function(t,i){var e=this.hitDetectionRadius+this.radius;return Math.pow(t-this.x,2)+Math.pow(i-this.y,2)<Math.pow(e,2)},draw:function(){if(this.display){var t=this.ctx;t.beginPath(),t.arc(this.x,this.y,this.radius,0,2*Math.PI),t.closePath(),t.strokeStyle=this.strokeColor,t.lineWidth=this.strokeWidth,t.fillStyle=this.fillColor,t.fill(),t.stroke()}}}),e.Arc=e.Element.extend({inRange:function(t,i){var e=o.getAngleFromPoint(this,{x:t,y:i}),s=e.angle%(2*Math.PI),n=(2*Math.PI+this.startAngle)%(2*Math.PI),a=(2*Math.PI+this.endAngle)%(2*Math.PI)||360,h=a<n?s<=a||s>=n:s>=n&&s<=a,l=e.distance>=this.innerRadius&&e.distance<=this.outerRadius;return h&&l},tooltipPosition:function(){var t=this.startAngle+(this.endAngle-this.startAngle)/2,i=(this.outerRadius-this.innerRadius)/2+this.innerRadius;return{x:this.x+Math.cos(t)*i,y:this.y+Math.sin(t)*i}},draw:function(t){var i=this.ctx;i.beginPath(),i.arc(this.x,this.y,this.outerRadius<0?0:this.outerRadius,this.startAngle,this.endAngle),i.arc(this.x,this.y,this.innerRadius<0?0:this.innerRadius,this.endAngle,this.startAngle,!0),i.closePath(),i.strokeStyle=this.strokeColor,i.lineWidth=this.strokeWidth,i.fillStyle=this.fillColor,i.fill(),i.lineJoin="bevel",this.showStroke&&i.stroke()}}),e.Rectangle=e.Element.extend({draw:function(){var t=this.ctx,i=this.width/2,e=this.x-i,s=this.x+i,n=this.base-(this.base-this.y),o=this.strokeWidth/2;this.showStroke&&(e+=o,s-=o,n+=o),t.beginPath(),t.fillStyle=this.fillColor,t.strokeStyle=this.strokeColor,t.lineWidth=this.strokeWidth,t.moveTo(e,this.base),t.lineTo(e,n),t.lineTo(s,n),t.lineTo(s,this.base),t.fill(),this.showStroke&&t.stroke()},height:function(){return this.base-this.y},inRange:function(t,i){return t>=this.x-this.width/2&&t<=this.x+this.width/2&&i>=this.y&&i<=this.base}}),e.Animation=e.Element.extend({currentStep:null,numSteps:60,easing:"",render:null,onAnimationProgress:null,onAnimationComplete:null}),e.Tooltip=e.Element.extend({draw:function(){var t=this.chart.ctx;t.font=B(this.fontSize,this.fontStyle,this.fontFamily),this.xAlign="center",this.yAlign="above";var i=this.caretPadding=2,e=t.measureText(this.text).width+2*this.xPadding,s=this.fontSize+2*this.yPadding,n=s+this.caretHeight+i;this.x+e/2>this.chart.width?this.xAlign="left":this.x-e/2<0&&(this.xAlign="right"),this.y-n<0&&(this.yAlign="below");var o=this.x-e/2,a=this.y-n;if(t.fillStyle=this.fillColor,this.custom)this.custom(this);else{switch(this.yAlign){case"above":t.beginPath(),t.moveTo(this.x,this.y-i),t.lineTo(this.x+this.caretHeight,this.y-(i+this.caretHeight)),t.lineTo(this.x-this.caretHeight,this.y-(i+this.caretHeight)),t.closePath(),t.fill();break;case"below":a=this.y+i+this.caretHeight,t.beginPath(),t.moveTo(this.x,this.y+i),t.lineTo(this.x+this.caretHeight,this.y+i+this.caretHeight),t.lineTo(this.x-this.caretHeight,this.y+i+this.caretHeight),t.closePath(),t.fill()}switch(this.xAlign){case"left":o=this.x-e+(this.cornerRadius+this.caretHeight);break;case"right":o=this.x-(this.cornerRadius+this.caretHeight)}I(t,o,a,e,s,this.cornerRadius),t.fill(),t.fillStyle=this.textColor,t.textAlign="center",t.textBaseline="middle",t.fillText(this.text,o+e/2,a+s/2)}}}),e.MultiTooltip=e.Element.extend({initialize:function(){this.font=B(this.fontSize,this.fontStyle,this.fontFamily),this.titleFont=B(this.titleFontSize,this.titleFontStyle,this.titleFontFamily),this.titleHeight=this.title?1.5*this.titleFontSize:0,this.height=this.labels.length*this.fontSize+(this.labels.length-1)*(this.fontSize/2)+2*this.yPadding+this.titleHeight,this.ctx.font=this.titleFont;var t=this.ctx.measureText(this.title).width,i=O(this.ctx,this.font,this.labels)+this.fontSize+3,e=v([i,t]);this.width=e+2*this.xPadding;var s=this.height/2;this.y-s<0?this.y=s:this.y+s>this.chart.height&&(this.y=this.chart.height-s),this.x>this.chart.width/2?this.x-=this.xOffset+this.width:this.x+=this.xOffset},getLineHeight:function(t){var i=this.y-this.height/2+this.yPadding,e=t-1;return 0===t?i+this.titleHeight/3:i+(1.5*this.fontSize*e+this.fontSize/2)+this.titleHeight},draw:function(){if(this.custom)this.custom(this);else{I(this.ctx,this.x,this.y-this.height/2,this.width,this.height,this.cornerRadius);var t=this.ctx;t.fillStyle=this.fillColor,t.fill(),t.closePath(),t.textAlign="left",t.textBaseline="middle",t.fillStyle=this.titleTextColor,t.font=this.titleFont,t.fillText(this.title,this.x+this.xPadding,this.getLineHeight(0)),t.font=this.font,o.each(this.labels,(function(i,e){t.fillStyle=this.textColor,t.fillText(i,this.x+this.xPadding+this.fontSize+3,this.getLineHeight(e+1)),t.fillStyle=this.legendColorBackground,t.fillRect(this.x+this.xPadding,this.getLineHeight(e+1)-this.fontSize/2,this.fontSize,this.fontSize),t.fillStyle=this.legendColors[e].fill,t.fillRect(this.x+this.xPadding,this.getLineHeight(e+1)-this.fontSize/2,this.fontSize,this.fontSize)}),this)}}}),e.Scale=e.Element.extend({initialize:function(){this.fit()},buildYLabels:function(){this.yLabels=[];for(var t=C(this.stepValue),i=0;i<=this.steps;i++)this.yLabels.push(w(this.templateString,{value:(this.min+i*this.stepValue).toFixed(t)}));this.yLabelWidth=this.display&&this.showLabels?O(this.ctx,this.font,this.yLabels)+10:0},addXLabel:function(t){this.xLabels.push(t),this.valuesCount++,this.fit()},removeXLabel:function(){this.xLabels.shift(),this.valuesCount--,this.fit()},fit:function(){this.startPoint=this.display?this.fontSize:0,this.endPoint=this.display?this.height-1.5*this.fontSize-5:this.height,this.startPoint+=this.padding,this.endPoint-=this.padding;var t,i=this.endPoint,e=this.endPoint-this.startPoint;for(this.calculateYRange(e),this.buildYLabels(),this.calculateXLabelRotation();e>this.endPoint-this.startPoint;)e=this.endPoint-this.startPoint,t=this.yLabelWidth,this.calculateYRange(e),this.buildYLabels(),t<this.yLabelWidth&&(this.endPoint=i,this.calculateXLabelRotation())},calculateXLabelRotation:function(){this.ctx.font=this.font;var t,i=this.ctx.measureText(this.xLabels[0]).width,e=this.ctx.measureText(this.xLabels[this.xLabels.length-1]).width;if(this.xScalePaddingRight=e/2+3,this.xScalePaddingLeft=i/2>this.yLabelWidth?i/2:this.yLabelWidth,this.xLabelRotation=0,this.display){var s,n=O(this.ctx,this.font,this.xLabels);this.xLabelWidth=n;for(var o=Math.floor(this.calculateX(1)-this.calculateX(0))-6;this.xLabelWidth>o&&0===this.xLabelRotation||this.xLabelWidth>o&&this.xLabelRotation<=90&&this.xLabelRotation>0;)(s=Math.cos(x(this.xLabelRotation)))*e,(t=s*i)+this.fontSize/2>this.yLabelWidth&&(this.xScalePaddingLeft=t+this.fontSize/2),this.xScalePaddingRight=this.fontSize/2,this.xLabelRotation++,this.xLabelWidth=s*n;this.xLabelRotation>0&&(this.endPoint-=Math.sin(x(this.xLabelRotation))*n+3)}else this.xLabelWidth=0,this.xScalePaddingRight=this.padding,this.xScalePaddingLeft=this.padding},calculateYRange:d,drawingArea:function(){return this.startPoint-this.endPoint},calculateY:function(t){var i=this.drawingArea()/(this.min-this.max);return this.endPoint-i*(t-this.min)},calculateX:function(t){this.xLabelRotation;var i=(this.width-(this.xScalePaddingLeft+this.xScalePaddingRight))/Math.max(this.valuesCount-(this.offsetGridLines?0:1),1),e=i*t+this.xScalePaddingLeft;return this.offsetGridLines&&(e+=i/2),Math.round(e)},update:function(t){o.extend(this,t),this.fit()},draw:function(){var t=this.ctx,i=(this.endPoint-this.startPoint)/this.steps,e=Math.round(this.xScalePaddingLeft);this.display&&(t.fillStyle=this.textColor,t.font=this.font,a(this.yLabels,(function(s,n){var a=this.endPoint-i*n,h=Math.round(a),l=this.showHorizontalLines;t.textAlign="right",t.textBaseline="middle",this.showLabels&&t.fillText(s,e-10,a),0!==n||l||(l=!0),l&&t.beginPath(),n>0?(t.lineWidth=this.gridLineWidth,t.strokeStyle=this.gridLineColor):(t.lineWidth=this.lineWidth,t.strokeStyle=this.lineColor),h+=o.aliasPixel(t.lineWidth),l&&(t.moveTo(e,h),t.lineTo(this.width,h),t.stroke(),t.closePath()),t.lineWidth=this.lineWidth,t.strokeStyle=this.lineColor,t.beginPath(),t.moveTo(e-5,h),t.lineTo(e,h),t.stroke(),t.closePath()}),this),a(this.xLabels,(function(i,e){var s=this.calculateX(e)+y(this.lineWidth),n=this.calculateX(e-(this.offsetGridLines?.5:0))+y(this.lineWidth),o=this.xLabelRotation>0,a=this.showVerticalLines;0!==e||a||(a=!0),a&&t.beginPath(),e>0?(t.lineWidth=this.gridLineWidth,t.strokeStyle=this.gridLineColor):(t.lineWidth=this.lineWidth,t.strokeStyle=this.lineColor),a&&(t.moveTo(n,this.endPoint),t.lineTo(n,this.startPoint-3),t.stroke(),t.closePath()),t.lineWidth=this.lineWidth,t.strokeStyle=this.lineColor,t.beginPath(),t.moveTo(n,this.endPoint),t.lineTo(n,this.endPoint+5),t.stroke(),t.closePath(),t.save(),t.translate(s,o?this.endPoint+12:this.endPoint+8),t.rotate(-1*x(this.xLabelRotation)),t.font=this.font,t.textAlign=o?"right":"center",t.textBaseline=o?"middle":"top",t.fillText(i,0,0),t.restore()}),this))}}),e.RadialScale=e.Element.extend({initialize:function(){this.size=S([this.height,this.width]),this.drawingArea=this.display?this.size/2-(this.fontSize/2+this.backdropPaddingY):this.size/2},calculateCenterOffset:function(t){var i=this.drawingArea/(this.max-this.min);return(t-this.min)*i},update:function(){this.lineArc?this.drawingArea=this.display?this.size/2-(this.fontSize/2+this.backdropPaddingY):this.size/2:this.setScaleSize(),this.buildYLabels()},buildYLabels:function(){this.yLabels=[];for(var t=C(this.stepValue),i=0;i<=this.steps;i++)this.yLabels.push(w(this.templateString,{value:(this.min+i*this.stepValue).toFixed(t)}))},getCircumference:function(){return 2*Math.PI/this.valuesCount},setScaleSize:function(){var t,i,e,s,n,o,a,h,l,r,c,u,d=S([this.height/2-this.pointLabelFontSize-5,this.width/2]),p=this.width,f=0;for(this.ctx.font=B(this.pointLabelFontSize,this.pointLabelFontStyle,this.pointLabelFontFamily),i=0;i<this.valuesCount;i++)t=this.getPointPosition(i,d),e=this.ctx.measureText(w(this.templateString,{value:this.labels[i]})).width+5,0===i||i===this.valuesCount/2?(s=e/2,t.x+s>p&&(p=t.x+s,n=i),t.x-s<f&&(f=t.x-s,a=i)):i<this.valuesCount/2?t.x+e>p&&(p=t.x+e,n=i):i>this.valuesCount/2&&t.x-e<f&&(f=t.x-e,a=i);l=f,r=Math.ceil(p-this.width),o=this.getIndexAngle(n),h=this.getIndexAngle(a),c=r/Math.sin(o+Math.PI/2),u=l/Math.sin(h+Math.PI/2),c=m(c)?c:0,u=m(u)?u:0,this.drawingArea=d-(u+c)/2,this.setCenterPoint(u,c)},setCenterPoint:function(t,i){var e=this.width-i-this.drawingArea,s=t+this.drawingArea;this.xCenter=(s+e)/2,this.yCenter=this.height/2},getIndexAngle:function(t){return t*(2*Math.PI/this.valuesCount)-Math.PI/2},getPointPosition:function(t,i){var e=this.getIndexAngle(t);return{x:Math.cos(e)*i+this.xCenter,y:Math.sin(e)*i+this.yCenter}},draw:function(){if(this.display){var t=this.ctx;if(a(this.yLabels,(function(i,e){if(e>0){var s,n=e*(this.drawingArea/this.steps),o=this.yCenter-n;if(this.lineWidth>0)if(t.strokeStyle=this.lineColor,t.lineWidth=this.lineWidth,this.lineArc)t.beginPath(),t.arc(this.xCenter,this.yCenter,n,0,2*Math.PI),t.closePath(),t.stroke();else{t.beginPath();for(var a=0;a<this.valuesCount;a++)s=this.getPointPosition(a,this.calculateCenterOffset(this.min+e*this.stepValue)),0===a?t.moveTo(s.x,s.y):t.lineTo(s.x,s.y);t.closePath(),t.stroke()}if(this.showLabels){if(t.font=B(this.fontSize,this.fontStyle,this.fontFamily),this.showLabelBackdrop){var h=t.measureText(i).width;t.fillStyle=this.backdropColor,t.fillRect(this.xCenter-h/2-this.backdropPaddingX,o-this.fontSize/2-this.backdropPaddingY,h+2*this.backdropPaddingX,this.fontSize+2*this.backdropPaddingY)}t.textAlign="center",t.textBaseline="middle",t.fillStyle=this.fontColor,t.fillText(i,this.xCenter,o)}}}),this),!this.lineArc){t.lineWidth=this.angleLineWidth,t.strokeStyle=this.angleLineColor;for(var i=this.valuesCount-1;i>=0;i--){var e=null,s=null;if(this.angleLineWidth>0&&(e=this.calculateCenterOffset(this.max),s=this.getPointPosition(i,e),t.beginPath(),t.moveTo(this.xCenter,this.yCenter),t.lineTo(s.x,s.y),t.stroke(),t.closePath()),this.backgroundColors&&this.backgroundColors.length==this.valuesCount){null==e&&(e=this.calculateCenterOffset(this.max)),null==s&&(s=this.getPointPosition(i,e));var n=this.getPointPosition(0===i?this.valuesCount-1:i-1,e),o=this.getPointPosition(i===this.valuesCount-1?0:i+1,e),h={x:(n.x+s.x)/2,y:(n.y+s.y)/2},l={x:(s.x+o.x)/2,y:(s.y+o.y)/2};t.beginPath(),t.moveTo(this.xCenter,this.yCenter),t.lineTo(h.x,h.y),t.lineTo(s.x,s.y),t.lineTo(l.x,l.y),t.fillStyle=this.backgroundColors[i],t.fill(),t.closePath()}var r=this.getPointPosition(i,this.calculateCenterOffset(this.max)+5);t.font=B(this.pointLabelFontSize,this.pointLabelFontStyle,this.pointLabelFontFamily),t.fillStyle=this.pointLabelFontColor;var c=this.labels.length,u=this.labels.length/2,d=u/2,p=i<d||i>c-d,f=i===d||i===c-d;t.textAlign=0===i||i===u?"center":i<u?"left":"right",t.textBaseline=f?"middle":p?"bottom":"top",t.fillText(this.labels[i],r.x,r.y)}}}}}),e.animationService={frameDuration:17,animations:[],dropFrames:0,addAnimation:function(t,i){for(var e=0;e<this.animations.length;++e)if(this.animations[e].chartInstance===t)return void(this.animations[e].animationObject=i);this.animations.push({chartInstance:t,animationObject:i}),1==this.animations.length&&o.requestAnimFrame.call(window,this.digestWrapper)},cancelAnimation:function(t){var i=o.findNextWhere(this.animations,(function(i){return i.chartInstance===t}));i&&this.animations.splice(i,1)},digestWrapper:function(){e.animationService.startDigest.call(e.animationService)},startDigest:function(){var t=Date.now(),i=0;this.dropFrames>1&&(i=Math.floor(this.dropFrames),this.dropFrames-=i);for(var e=0;e<this.animations.length;e++)null===this.animations[e].animationObject.currentStep&&(this.animations[e].animationObject.currentStep=0),this.animations[e].animationObject.currentStep+=1+i,this.animations[e].animationObject.currentStep>this.animations[e].animationObject.numSteps&&(this.animations[e].animationObject.currentStep=this.animations[e].animationObject.numSteps),this.animations[e].animationObject.render(this.animations[e].chartInstance,this.animations[e].animationObject),this.animations[e].animationObject.currentStep==this.animations[e].animationObject.numSteps&&(this.animations[e].animationObject.onAnimationComplete.call(this.animations[e].chartInstance),this.animations.splice(e,1),e--);var s=(Date.now()-t-this.frameDuration)/this.frameDuration;s>1&&(this.dropFrames+=s),this.animations.length>0&&o.requestAnimFrame.call(window,this.digestWrapper)}},o.addEvent(window,"resize",(function(){clearTimeout(n),n=setTimeout((function(){a(e.instances,(function(t){t.options.responsive&&t.resize(t.render,!0)}))}),50)})),g?define("Chart",[],(function(){return e})):"object"==typeof module&&module.exports&&(module.exports=e),t.Chart=e,e.noConflict=function(){return t.Chart=i,e}}).call(this),function(){"use strict";var t=this.Chart,i=t.helpers;t.Type.extend({name:"Bar",defaults:{scaleBeginAtZero:!0,scaleShowGridLines:!0,scaleGridLineColor:"rgba(0,0,0,.05)",scaleGridLineWidth:1,scaleShowHorizontalLines:!0,scaleShowVerticalLines:!0,barShowStroke:!0,barStrokeWidth:2,barValueSpacing:5,barDatasetSpacing:1,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<datasets.length; i++){%><li><span style="background-color:<%=datasets[i].fillColor%>"><%if(datasets[i].label){%><%=datasets[i].label%><%}%></span></li><%}%></ul>'},initialize:function(e){var s=this.options;this.ScaleClass=t.Scale.extend({offsetGridLines:!0,calculateBarX:function(t,i,e){var n=this.calculateBaseWidth(),o=this.calculateX(e)-n/2,a=this.calculateBarWidth(t);return o+a*i+i*s.barDatasetSpacing+a/2},calculateBaseWidth:function(){return this.calculateX(1)-this.calculateX(0)-2*s.barValueSpacing},calculateBarWidth:function(t){return(this.calculateBaseWidth()-(t-1)*s.barDatasetSpacing)/t}}),this.datasets=[],this.options.showTooltips&&i.bindEvents(this,this.options.tooltipEvents,(function(t){var e="mouseout"!==t.type?this.getBarsAtEvent(t):[];this.eachBars((function(t){t.restore(["fillColor","strokeColor"])})),i.each(e,(function(t){t.fillColor=t.highlightFill,t.strokeColor=t.highlightStroke})),this.showTooltip(e)})),this.BarClass=t.Rectangle.extend({strokeWidth:this.options.barStrokeWidth,showStroke:this.options.barShowStroke,ctx:this.chart.ctx}),i.each(e.datasets,(function(t,s){var n={label:t.label||null,fillColor:t.fillColor,strokeColor:t.strokeColor,bars:[]};this.datasets.push(n),i.each(t.data,(function(i,s){n.bars.push(new this.BarClass({value:i,label:e.labels[s],datasetLabel:t.label,strokeColor:"string"!=typeof t.strokeColor?t.strokeColor[s]:t.strokeColor,fillColor:"string"!=typeof t.fillColor?t.fillColor[s]:t.fillColor,highlightFill:t.highlightFill&&"string"!=typeof t.highlightFill?t.highlightFill[s]||t.highlightFill:"string"!=typeof t.fillColor?t.fillColor[s]:t.fillColor,highlightStroke:t.highlightStroke&&"string"!=typeof t.highlightStroke?t.highlightStroke[s]||t.highlightStroke:"string"!=typeof t.strokeColor?t.strokeColor[s]:t.strokeColor}))}),this)}),this),this.buildScale(e.labels),this.BarClass.prototype.base=this.scale.endPoint,this.eachBars((function(t,e,s){i.extend(t,{width:this.scale.calculateBarWidth(this.datasets.length),x:this.scale.calculateBarX(this.datasets.length,s,e),y:this.scale.endPoint}),t.save()}),this),this.render()},update:function(){this.scale.update(),i.each(this.activeElements,(function(t){t.restore(["fillColor","strokeColor"])})),this.eachBars((function(t){t.save()})),this.render()},eachBars:function(t){i.each(this.datasets,(function(e,s){i.each(e.bars,t,this,s)}),this)},getBarsAtEvent:function(t){for(var e,s=[],n=i.getRelativePosition(t),o=function(t){s.push(t.bars[e])},a=0;a<this.datasets.length;a++)for(e=0;e<this.datasets[a].bars.length;e++)if(this.datasets[a].bars[e].inRange(n.x,n.y))return i.each(this.datasets,o),s;return s},buildScale:function(t){var e=this,s={templateString:this.options.scaleLabel,height:this.chart.height,width:this.chart.width,ctx:this.chart.ctx,textColor:this.options.scaleFontColor,fontSize:this.options.scaleFontSize,fontStyle:this.options.scaleFontStyle,fontFamily:this.options.scaleFontFamily,valuesCount:t.length,beginAtZero:this.options.scaleBeginAtZero,integersOnly:this.options.scaleIntegersOnly,calculateYRange:function(t){var s,n=i.calculateScaleRange((s=[],e.eachBars((function(t){s.push(t.value)})),s),t,this.fontSize,this.beginAtZero,this.integersOnly);i.extend(this,n)},xLabels:t,font:i.fontString(this.options.scaleFontSize,this.options.scaleFontStyle,this.options.scaleFontFamily),lineWidth:this.options.scaleLineWidth,lineColor:this.options.scaleLineColor,showHorizontalLines:this.options.scaleShowHorizontalLines,showVerticalLines:this.options.scaleShowVerticalLines,gridLineWidth:this.options.scaleShowGridLines?this.options.scaleGridLineWidth:0,gridLineColor:this.options.scaleShowGridLines?this.options.scaleGridLineColor:"rgba(0,0,0,0)",padding:this.options.showScale?0:this.options.barShowStroke?this.options.barStrokeWidth:0,showLabels:this.options.scaleShowLabels,display:this.options.showScale};this.options.scaleOverride&&i.extend(s,{calculateYRange:i.noop,steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+this.options.scaleSteps*this.options.scaleStepWidth}),this.scale=new this.ScaleClass(s)},addData:function(t,e){i.each(t,(function(t,i){this.datasets[i].bars.push(new this.BarClass({value:t,label:e,datasetLabel:this.datasets[i].label,x:this.scale.calculateBarX(this.datasets.length,i,this.scale.valuesCount+1),y:this.scale.endPoint,width:this.scale.calculateBarWidth(this.datasets.length),base:this.scale.endPoint,strokeColor:this.datasets[i].strokeColor,fillColor:this.datasets[i].fillColor}))}),this),this.scale.addXLabel(e),this.update()},removeData:function(){this.scale.removeXLabel(),i.each(this.datasets,(function(t){t.bars.shift()}),this),this.update()},reflow:function(){i.extend(this.BarClass.prototype,{y:this.scale.endPoint,base:this.scale.endPoint});var t=i.extend({height:this.chart.height,width:this.chart.width});this.scale.update(t)},draw:function(t){var e=t||1;this.clear();this.chart.ctx;this.scale.draw(e),i.each(this.datasets,(function(t,s){i.each(t.bars,(function(t,i){t.hasValue()&&(t.base=this.scale.endPoint,t.transition({x:this.scale.calculateBarX(this.datasets.length,s,i),y:this.scale.calculateY(t.value),width:this.scale.calculateBarWidth(this.datasets.length)},e).draw())}),this)}),this)}})}.call(this),function(){"use strict";var t=this.Chart,i=t.helpers,e={segmentShowStroke:!0,segmentStrokeColor:"#fff",segmentStrokeWidth:2,percentageInnerCutout:50,animationSteps:100,animationEasing:"easeOutBounce",animateRotate:!0,animateScale:!1,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<segments.length; i++){%><li><span style="background-color:<%=segments[i].fillColor%>"><%if(segments[i].label){%><%=segments[i].label%><%}%></span></li><%}%></ul>'};t.Type.extend({name:"Doughnut",defaults:e,initialize:function(e){this.segments=[],this.outerRadius=(i.min([this.chart.width,this.chart.height])-this.options.segmentStrokeWidth/2)/2,this.SegmentArc=t.Arc.extend({ctx:this.chart.ctx,x:this.chart.width/2,y:this.chart.height/2}),this.options.showTooltips&&i.bindEvents(this,this.options.tooltipEvents,(function(t){var e="mouseout"!==t.type?this.getSegmentsAtEvent(t):[];i.each(this.segments,(function(t){t.restore(["fillColor"])})),i.each(e,(function(t){t.fillColor=t.highlightColor})),this.showTooltip(e)})),this.calculateTotal(e),i.each(e,(function(t,i){t.color||(t.color="hsl("+360*i/e.length+", 100%, 50%)"),this.addData(t,i,!0)}),this),this.render()},getSegmentsAtEvent:function(t){var e=[],s=i.getRelativePosition(t);return i.each(this.segments,(function(t){t.inRange(s.x,s.y)&&e.push(t)}),this),e},addData:function(i,e,s){var n=void 0!==e?e:this.segments.length;void 0===i.color&&(i.color=t.defaults.global.segmentColorDefault[n%t.defaults.global.segmentColorDefault.length],i.highlight=t.defaults.global.segmentHighlightColorDefaults[n%t.defaults.global.segmentHighlightColorDefaults.length]),this.segments.splice(n,0,new this.SegmentArc({value:i.value,outerRadius:this.options.animateScale?0:this.outerRadius,innerRadius:this.options.animateScale?0:this.outerRadius/100*this.options.percentageInnerCutout,fillColor:i.color,highlightColor:i.highlight||i.color,showStroke:this.options.segmentShowStroke,strokeWidth:this.options.segmentStrokeWidth,strokeColor:this.options.segmentStrokeColor,startAngle:1.5*Math.PI,circumference:this.options.animateRotate?0:this.calculateCircumference(i.value),label:i.label})),s||(this.reflow(),this.update())},calculateCircumference:function(t){return this.total>0?2*Math.PI*(t/this.total):0},calculateTotal:function(t){this.total=0,i.each(t,(function(t){this.total+=Math.abs(t.value)}),this)},update:function(){this.calculateTotal(this.segments),i.each(this.activeElements,(function(t){t.restore(["fillColor"])})),i.each(this.segments,(function(t){t.save()})),this.render()},removeData:function(t){var e=i.isNumber(t)?t:this.segments.length-1;this.segments.splice(e,1),this.reflow(),this.update()},reflow:function(){i.extend(this.SegmentArc.prototype,{x:this.chart.width/2,y:this.chart.height/2}),this.outerRadius=(i.min([this.chart.width,this.chart.height])-this.options.segmentStrokeWidth/2)/2,i.each(this.segments,(function(t){t.update({outerRadius:this.outerRadius,innerRadius:this.outerRadius/100*this.options.percentageInnerCutout})}),this)},draw:function(t){var e=t||1;this.clear(),i.each(this.segments,(function(t,i){t.transition({circumference:this.calculateCircumference(t.value),outerRadius:this.outerRadius,innerRadius:this.outerRadius/100*this.options.percentageInnerCutout},e),t.endAngle=t.startAngle+t.circumference,t.draw(),0===i&&(t.startAngle=1.5*Math.PI),i<this.segments.length-1&&(this.segments[i+1].startAngle=t.endAngle)}),this)}}),t.types.Doughnut.extend({name:"Pie",defaults:i.merge(e,{percentageInnerCutout:0})})}.call(this),function(){"use strict";var t=this.Chart,i=t.helpers;t.Type.extend({name:"Line",defaults:{scaleShowGridLines:!0,scaleGridLineColor:"rgba(0,0,0,.05)",scaleGridLineWidth:1,scaleShowHorizontalLines:!0,scaleShowVerticalLines:!0,bezierCurve:!0,bezierCurveTension:.4,pointDot:!0,pointDotRadius:4,pointDotStrokeWidth:1,pointHitDetectionRadius:20,datasetStroke:!0,datasetStrokeWidth:2,datasetFill:!0,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<datasets.length; i++){%><li><span style="background-color:<%=datasets[i].strokeColor%>"><%if(datasets[i].label){%><%=datasets[i].label%><%}%></span></li><%}%></ul>',offsetGridLines:!1},initialize:function(e){this.PointClass=t.Point.extend({offsetGridLines:this.options.offsetGridLines,strokeWidth:this.options.pointDotStrokeWidth,radius:this.options.pointDotRadius,display:this.options.pointDot,hitDetectionRadius:this.options.pointHitDetectionRadius,ctx:this.chart.ctx,inRange:function(t){return Math.pow(t-this.x,2)<Math.pow(this.radius+this.hitDetectionRadius,2)}}),this.datasets=[],this.options.showTooltips&&i.bindEvents(this,this.options.tooltipEvents,(function(t){var e="mouseout"!==t.type?this.getPointsAtEvent(t):[];this.eachPoints((function(t){t.restore(["fillColor","strokeColor"])})),i.each(e,(function(t){t.fillColor=t.highlightFill,t.strokeColor=t.highlightStroke})),this.showTooltip(e)})),i.each(e.datasets,(function(t){var s={label:t.label||null,fillColor:t.fillColor,strokeColor:t.strokeColor,pointColor:t.pointColor,pointStrokeColor:t.pointStrokeColor,points:[]};this.datasets.push(s),i.each(t.data,(function(i,n){s.points.push(new this.PointClass({value:i,label:e.labels[n],datasetLabel:t.label,strokeColor:t.pointStrokeColor,fillColor:t.pointColor,highlightFill:t.pointHighlightFill||t.pointColor,highlightStroke:t.pointHighlightStroke||t.pointStrokeColor}))}),this),this.buildScale(e.labels),this.eachPoints((function(t,e){i.extend(t,{x:this.scale.calculateX(e),y:this.scale.endPoint}),t.save()}),this)}),this),this.render()},update:function(){this.scale.update(),i.each(this.activeElements,(function(t){t.restore(["fillColor","strokeColor"])})),this.eachPoints((function(t){t.save()})),this.render()},eachPoints:function(t){i.each(this.datasets,(function(e){i.each(e.points,t,this)}),this)},getPointsAtEvent:function(t){var e=[],s=i.getRelativePosition(t);return i.each(this.datasets,(function(t){i.each(t.points,(function(t){t.inRange(s.x,s.y)&&e.push(t)}))}),this),e},buildScale:function(e){var s=this,n={templateString:this.options.scaleLabel,height:this.chart.height,width:this.chart.width,ctx:this.chart.ctx,textColor:this.options.scaleFontColor,offsetGridLines:this.options.offsetGridLines,fontSize:this.options.scaleFontSize,fontStyle:this.options.scaleFontStyle,fontFamily:this.options.scaleFontFamily,valuesCount:e.length,beginAtZero:this.options.scaleBeginAtZero,integersOnly:this.options.scaleIntegersOnly,calculateYRange:function(t){var e,n=i.calculateScaleRange((e=[],s.eachPoints((function(t){e.push(t.value)})),e),t,this.fontSize,this.beginAtZero,this.integersOnly);i.extend(this,n)},xLabels:e,font:i.fontString(this.options.scaleFontSize,this.options.scaleFontStyle,this.options.scaleFontFamily),lineWidth:this.options.scaleLineWidth,lineColor:this.options.scaleLineColor,showHorizontalLines:this.options.scaleShowHorizontalLines,showVerticalLines:this.options.scaleShowVerticalLines,gridLineWidth:this.options.scaleShowGridLines?this.options.scaleGridLineWidth:0,gridLineColor:this.options.scaleShowGridLines?this.options.scaleGridLineColor:"rgba(0,0,0,0)",padding:this.options.showScale?0:this.options.pointDotRadius+this.options.pointDotStrokeWidth,showLabels:this.options.scaleShowLabels,display:this.options.showScale};this.options.scaleOverride&&i.extend(n,{calculateYRange:i.noop,steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+this.options.scaleSteps*this.options.scaleStepWidth}),this.scale=new t.Scale(n)},addData:function(t,e){i.each(t,(function(t,i){this.datasets[i].points.push(new this.PointClass({value:t,label:e,datasetLabel:this.datasets[i].label,x:this.scale.calculateX(this.scale.valuesCount+1),y:this.scale.endPoint,strokeColor:this.datasets[i].pointStrokeColor,fillColor:this.datasets[i].pointColor}))}),this),this.scale.addXLabel(e),this.update()},removeData:function(){this.scale.removeXLabel(),i.each(this.datasets,(function(t){t.points.shift()}),this),this.update()},reflow:function(){var t=i.extend({height:this.chart.height,width:this.chart.width});this.scale.update(t)},draw:function(t){var e=t||1;this.clear();var s=this.chart.ctx,n=function(t){return null!==t.value},o=function(t,e,s){return i.findPreviousWhere(e,n,s)||t};this.scale&&(this.scale.draw(e),i.each(this.datasets,(function(t){var a=i.where(t.points,n);i.each(t.points,(function(t,i){t.hasValue()&&t.transition({y:this.scale.calculateY(t.value),x:this.scale.calculateX(i)},e)}),this),this.options.bezierCurve&&i.each(a,(function(t,e){var s=e>0&&e<a.length-1?this.options.bezierCurveTension:0;t.controlPoints=i.splineCurve(o(t,a,e),t,function(t,e,s){return i.findNextWhere(e,n,s)||t}(t,a,e),s),t.controlPoints.outer.y>this.scale.endPoint?t.controlPoints.outer.y=this.scale.endPoint:t.controlPoints.outer.y<this.scale.startPoint&&(t.controlPoints.outer.y=this.scale.startPoint),t.controlPoints.inner.y>this.scale.endPoint?t.controlPoints.inner.y=this.scale.endPoint:t.controlPoints.inner.y<this.scale.startPoint&&(t.controlPoints.inner.y=this.scale.startPoint)}),this),s.lineWidth=this.options.datasetStrokeWidth,s.strokeStyle=t.strokeColor,s.beginPath(),i.each(a,(function(t,i){if(0===i)s.moveTo(t.x,t.y);else if(this.options.bezierCurve){var e=o(t,a,i);s.bezierCurveTo(e.controlPoints.outer.x,e.controlPoints.outer.y,t.controlPoints.inner.x,t.controlPoints.inner.y,t.x,t.y)}else s.lineTo(t.x,t.y)}),this),this.options.datasetStroke&&s.stroke(),this.options.datasetFill&&a.length>0&&(s.lineTo(a[a.length-1].x,this.scale.endPoint),s.lineTo(a[0].x,this.scale.endPoint),s.fillStyle=t.fillColor,s.closePath(),s.fill()),i.each(a,(function(t){t.draw()}))}),this))}})}.call(this),function(){"use strict";var t=this.Chart,i=t.helpers;t.Type.extend({name:"PolarArea",defaults:{scaleShowLabelBackdrop:!0,scaleBackdropColor:"rgba(255,255,255,0.75)",scaleBeginAtZero:!0,scaleBackdropPaddingY:2,scaleBackdropPaddingX:2,scaleShowLine:!0,segmentShowStroke:!0,segmentStrokeColor:"#fff",segmentStrokeWidth:2,animationSteps:100,animationEasing:"easeOutBounce",animateRotate:!0,animateScale:!1,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<segments.length; i++){%><li><span style="background-color:<%=segments[i].fillColor%>"><%if(segments[i].label){%><%=segments[i].label%><%}%></span></li><%}%></ul>'},initialize:function(e){this.segments=[],this.SegmentArc=t.Arc.extend({showStroke:this.options.segmentShowStroke,strokeWidth:this.options.segmentStrokeWidth,strokeColor:this.options.segmentStrokeColor,ctx:this.chart.ctx,innerRadius:0,x:this.chart.width/2,y:this.chart.height/2}),this.scale=new t.RadialScale({display:this.options.showScale,fontStyle:this.options.scaleFontStyle,fontSize:this.options.scaleFontSize,fontFamily:this.options.scaleFontFamily,fontColor:this.options.scaleFontColor,showLabels:this.options.scaleShowLabels,showLabelBackdrop:this.options.scaleShowLabelBackdrop,backdropColor:this.options.scaleBackdropColor,backdropPaddingY:this.options.scaleBackdropPaddingY,backdropPaddingX:this.options.scaleBackdropPaddingX,lineWidth:this.options.scaleShowLine?this.options.scaleLineWidth:0,lineColor:this.options.scaleLineColor,lineArc:!0,width:this.chart.width,height:this.chart.height,xCenter:this.chart.width/2,yCenter:this.chart.height/2,ctx:this.chart.ctx,templateString:this.options.scaleLabel,valuesCount:e.length}),this.updateScaleRange(e),this.scale.update(),i.each(e,(function(t,i){this.addData(t,i,!0)}),this),this.options.showTooltips&&i.bindEvents(this,this.options.tooltipEvents,(function(t){var e="mouseout"!==t.type?this.getSegmentsAtEvent(t):[];i.each(this.segments,(function(t){t.restore(["fillColor"])})),i.each(e,(function(t){t.fillColor=t.highlightColor})),this.showTooltip(e)})),this.render()},getSegmentsAtEvent:function(t){var e=[],s=i.getRelativePosition(t);return i.each(this.segments,(function(t){t.inRange(s.x,s.y)&&e.push(t)}),this),e},addData:function(t,i,e){var s=i||this.segments.length;this.segments.splice(s,0,new this.SegmentArc({fillColor:t.color,highlightColor:t.highlight||t.color,label:t.label,value:t.value,outerRadius:this.options.animateScale?0:this.scale.calculateCenterOffset(t.value),circumference:this.options.animateRotate?0:this.scale.getCircumference(),startAngle:1.5*Math.PI})),e||(this.reflow(),this.update())},removeData:function(t){var e=i.isNumber(t)?t:this.segments.length-1;this.segments.splice(e,1),this.reflow(),this.update()},calculateTotal:function(t){this.total=0,i.each(t,(function(t){this.total+=t.value}),this),this.scale.valuesCount=this.segments.length},updateScaleRange:function(t){var e=[];i.each(t,(function(t){e.push(t.value)}));var s=this.options.scaleOverride?{steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+this.options.scaleSteps*this.options.scaleStepWidth}:i.calculateScaleRange(e,i.min([this.chart.width,this.chart.height])/2,this.options.scaleFontSize,this.options.scaleBeginAtZero,this.options.scaleIntegersOnly);i.extend(this.scale,s,{size:i.min([this.chart.width,this.chart.height]),xCenter:this.chart.width/2,yCenter:this.chart.height/2})},update:function(){this.calculateTotal(this.segments),i.each(this.segments,(function(t){t.save()})),this.reflow(),this.render()},reflow:function(){i.extend(this.SegmentArc.prototype,{x:this.chart.width/2,y:this.chart.height/2}),this.updateScaleRange(this.segments),this.scale.update(),i.extend(this.scale,{xCenter:this.chart.width/2,yCenter:this.chart.height/2}),i.each(this.segments,(function(t){t.update({outerRadius:this.scale.calculateCenterOffset(t.value)})}),this)},draw:function(t){var e=t||1;this.clear(),i.each(this.segments,(function(t,i){t.transition({circumference:this.scale.getCircumference(),outerRadius:this.scale.calculateCenterOffset(t.value)},e),t.endAngle=t.startAngle+t.circumference,0===i&&(t.startAngle=1.5*Math.PI),i<this.segments.length-1&&(this.segments[i+1].startAngle=t.endAngle),t.draw()}),this),this.scale.draw()}})}.call(this),function(){"use strict";var t=this.Chart,i=t.helpers;t.Type.extend({name:"Radar",defaults:{scaleShowLine:!0,angleShowLineOut:!0,scaleShowLabels:!1,scaleBeginAtZero:!0,angleLineColor:"rgba(0,0,0,.1)",angleLineWidth:1,pointLabelFontFamily:"'Arial'",pointLabelFontStyle:"normal",pointLabelFontSize:10,pointLabelFontColor:"#666",pointDot:!0,pointDotRadius:3,pointDotStrokeWidth:1,pointHitDetectionRadius:20,datasetStroke:!0,datasetStrokeWidth:2,datasetFill:!0,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<datasets.length; i++){%><li><span style="background-color:<%=datasets[i].strokeColor%>"><%if(datasets[i].label){%><%=datasets[i].label%><%}%></span></li><%}%></ul>'},initialize:function(e){this.PointClass=t.Point.extend({strokeWidth:this.options.pointDotStrokeWidth,radius:this.options.pointDotRadius,display:this.options.pointDot,hitDetectionRadius:this.options.pointHitDetectionRadius,ctx:this.chart.ctx}),this.datasets=[],this.buildScale(e),this.options.showTooltips&&i.bindEvents(this,this.options.tooltipEvents,(function(t){var e="mouseout"!==t.type?this.getPointsAtEvent(t):[];this.eachPoints((function(t){t.restore(["fillColor","strokeColor"])})),i.each(e,(function(t){t.fillColor=t.highlightFill,t.strokeColor=t.highlightStroke})),this.showTooltip(e)})),i.each(e.datasets,(function(t){var s={label:t.label||null,fillColor:t.fillColor,strokeColor:t.strokeColor,pointColor:t.pointColor,pointStrokeColor:t.pointStrokeColor,points:[]};this.datasets.push(s),i.each(t.data,(function(i,n){var o;this.scale.animation||(o=this.scale.getPointPosition(n,this.scale.calculateCenterOffset(i))),s.points.push(new this.PointClass({value:i,label:e.labels[n],datasetLabel:t.label,x:this.options.animation?this.scale.xCenter:o.x,y:this.options.animation?this.scale.yCenter:o.y,strokeColor:t.pointStrokeColor,fillColor:t.pointColor,highlightFill:t.pointHighlightFill||t.pointColor,highlightStroke:t.pointHighlightStroke||t.pointStrokeColor}))}),this)}),this),this.render()},eachPoints:function(t){i.each(this.datasets,(function(e){i.each(e.points,t,this)}),this)},getPointsAtEvent:function(t){var e=i.getRelativePosition(t),s=i.getAngleFromPoint({x:this.scale.xCenter,y:this.scale.yCenter},e),n=2*Math.PI/this.scale.valuesCount,o=Math.round((s.angle-1.5*Math.PI)/n),a=[];return(o>=this.scale.valuesCount||o<0)&&(o=0),s.distance<=this.scale.drawingArea&&i.each(this.datasets,(function(t){a.push(t.points[o])})),a},buildScale:function(i){this.scale=new t.RadialScale({display:this.options.showScale,fontStyle:this.options.scaleFontStyle,fontSize:this.options.scaleFontSize,fontFamily:this.options.scaleFontFamily,fontColor:this.options.scaleFontColor,showLabels:this.options.scaleShowLabels,showLabelBackdrop:this.options.scaleShowLabelBackdrop,backdropColor:this.options.scaleBackdropColor,backgroundColors:this.options.scaleBackgroundColors,backdropPaddingY:this.options.scaleBackdropPaddingY,backdropPaddingX:this.options.scaleBackdropPaddingX,lineWidth:this.options.scaleShowLine?this.options.scaleLineWidth:0,lineColor:this.options.scaleLineColor,angleLineColor:this.options.angleLineColor,angleLineWidth:this.options.angleShowLineOut?this.options.angleLineWidth:0,pointLabelFontColor:this.options.pointLabelFontColor,pointLabelFontSize:this.options.pointLabelFontSize,pointLabelFontFamily:this.options.pointLabelFontFamily,pointLabelFontStyle:this.options.pointLabelFontStyle,height:this.chart.height,width:this.chart.width,xCenter:this.chart.width/2,yCenter:this.chart.height/2,ctx:this.chart.ctx,templateString:this.options.scaleLabel,labels:i.labels,valuesCount:i.datasets[0].data.length}),this.scale.setScaleSize(),this.updateScaleRange(i.datasets),this.scale.buildYLabels()},updateScaleRange:function(t){var e,s=(e=[],i.each(t,(function(t){t.data?e=e.concat(t.data):i.each(t.points,(function(t){e.push(t.value)}))})),e),n=this.options.scaleOverride?{steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+this.options.scaleSteps*this.options.scaleStepWidth}:i.calculateScaleRange(s,i.min([this.chart.width,this.chart.height])/2,this.options.scaleFontSize,this.options.scaleBeginAtZero,this.options.scaleIntegersOnly);i.extend(this.scale,n)},addData:function(t,e){this.scale.valuesCount++,i.each(t,(function(t,i){var s=this.scale.getPointPosition(this.scale.valuesCount,this.scale.calculateCenterOffset(t));this.datasets[i].points.push(new this.PointClass({value:t,label:e,datasetLabel:this.datasets[i].label,x:s.x,y:s.y,strokeColor:this.datasets[i].pointStrokeColor,fillColor:this.datasets[i].pointColor}))}),this),this.scale.labels.push(e),this.reflow(),this.update()},removeData:function(){this.scale.valuesCount--,this.scale.labels.shift(),i.each(this.datasets,(function(t){t.points.shift()}),this),this.reflow(),this.update()},update:function(){this.eachPoints((function(t){t.save()})),this.reflow(),this.render()},reflow:function(){i.extend(this.scale,{width:this.chart.width,height:this.chart.height,size:i.min([this.chart.width,this.chart.height]),xCenter:this.chart.width/2,yCenter:this.chart.height/2}),this.updateScaleRange(this.datasets),this.scale.setScaleSize(),this.scale.buildYLabels()},draw:function(t){var e=t||1,s=this.chart.ctx;this.clear(),this.scale.draw(),i.each(this.datasets,(function(t){i.each(t.points,(function(t,i){t.hasValue()&&t.transition(this.scale.getPointPosition(i,this.scale.calculateCenterOffset(t.value)),e)}),this),s.lineWidth=this.options.datasetStrokeWidth,s.strokeStyle=t.strokeColor,s.beginPath(),i.each(t.points,(function(t,i){0===i?s.moveTo(t.x,t.y):s.lineTo(t.x,t.y)}),this),s.closePath(),s.stroke(),s.fillStyle=t.fillColor,this.options.datasetFill&&s.fill(),i.each(t.points,(function(t){t.hasValue()&&t.draw()}))}),this)}})}.call(this);