<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if (! class_exists ( 'WindoorPlusFooterPostType' ) ) {

	class WindoorPlusFooterPostType {

        private static $_instance = null;

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

		function __construct() {

			add_action ( 'init', array( $this, 'windoor_register_cpt' ) );
			add_filter ( 'template_include', array ( $this, 'windoor_template_include' ) );
		}

		function windoor_register_cpt() {

			$labels = array (
				'name'				 => __( 'Footers', 'windoor-plus' ),
				'singular_name'		 => __( 'Footer', 'windoor-plus' ),
				'menu_name'			 => __( 'Footers', 'windoor-plus' ),
				'add_new'			 => __( 'Add Footer', 'windoor-plus' ),
				'add_new_item'		 => __( 'Add New Footer', 'windoor-plus' ),
				'edit'				 => __( 'Edit Footer', 'windoor-plus' ),
				'edit_item'			 => __( 'Edit Footer', 'windoor-plus' ),
				'new_item'			 => __( 'New Footer', 'windoor-plus' ),
				'view'				 => __( 'View Footer', 'windoor-plus' ),
				'view_item' 		 => __( 'View Footer', 'windoor-plus' ),
				'search_items' 		 => __( 'Search Footers', 'windoor-plus' ),
				'not_found' 		 => __( 'No Footers found', 'windoor-plus' ),
				'not_found_in_trash' => __( 'No Footers found in Trash', 'windoor-plus' ),
			);

			$args = array (
				'labels' 				=> $labels,
				'public' 				=> true,
				'exclude_from_search'	=> true,
				'show_in_nav_menus' 	=> false,
				'show_in_rest' 			=> true,
				'menu_position'			=> 26,
				'menu_icon' 			=> 'dashicons-editor-insertmore',
				'hierarchical' 			=> false,
				'supports' 				=> array ( 'title', 'editor', 'revisions' ),
			);

			register_post_type ( 'wdt_footers', $args );
		}

		function windoor_template_include($template) {
			if ( is_singular( 'wdt_footers' ) ) {
				if ( ! file_exists ( get_stylesheet_directory () . '/single-wdt_footers.php' ) ) {
					$template = WINDOOR_PLUS_DIR_PATH . 'post-types/templates/single-wdt_footers.php';
				}
			}

			return $template;
		}
	}
}

WindoorPlusFooterPostType::instance();