<?php

namespace WindoorElementor\Widgets;
use WindoorElementor\Widgets\Windoor_Shop_Widget_Product_Summary;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;


class Windoor_Shop_Widget_Product_Summary_Extend extends Windoor_Shop_Widget_Product_Summary {

	function dynamic_register_controls() {

		$this->start_controls_section( 'product_summary_extend_section', array(
			'label' => esc_html__( 'Social Options', 'windoor-pro' ),
		) );

			$this->add_control( 'share_follow_type', array(
				'label'   => esc_html__( 'Share / Follow Type', 'windoor-pro' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'share',
				'options' => array(
					''       => esc_html__('None', 'windoor-pro'),
					'share'  => esc_html__('Share', 'windoor-pro'),
					'follow' => esc_html__('Follow', 'windoor-pro'),
				),
				'description' => esc_html__( 'Choose between Share / Follow you would like to use.', 'windoor-pro' ),
			) );

			$this->add_control( 'social_icon_style', array(
				'label'   => esc_html__( 'Social Icon Style', 'windoor-pro' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					'simple'        => esc_html__( 'Simple', 'windoor-pro' ),
					'bgfill'        => esc_html__( 'BG Fill', 'windoor-pro' ),
					'brdrfill'      => esc_html__( 'Border Fill', 'windoor-pro' ),
					'skin-bgfill'   => esc_html__( 'Skin BG Fill', 'windoor-pro' ),
					'skin-brdrfill' => esc_html__( 'Skin Border Fill', 'windoor-pro' ),
				),
				'description' => esc_html__( 'This option is applicable for all buttons used in product summary.', 'windoor-pro' ),
				'condition'   => array( 'share_follow_type' => array ('share', 'follow') )
			) );

			$this->add_control( 'social_icon_radius', array(
				'label'   => esc_html__( 'Social Icon Radius', 'windoor-pro' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					'square'  => esc_html__( 'Square', 'windoor-pro' ),
					'rounded' => esc_html__( 'Rounded', 'windoor-pro' ),
					'circle'  => esc_html__( 'Circle', 'windoor-pro' ),
				),
				'condition'   => array(
					'social_icon_style' => array ('bgfill', 'brdrfill', 'skin-bgfill', 'skin-brdrfill'),
					'share_follow_type' => array ('share', 'follow')
				),
			) );

			$this->add_control( 'social_icon_inline_alignment', array(
				'label'        => esc_html__( 'Social Icon Inline Alignment', 'windoor-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'yes', 'windoor-pro' ),
				'label_off'    => esc_html__( 'no', 'windoor-pro' ),
				'default'      => '',
				'return_value' => 'true',
				'description'  => esc_html__( 'This option is applicable for all buttons used in product summary.', 'windoor-pro' ),
				'condition'   => array( 'share_follow_type' => array ('share', 'follow') )
			) );

		$this->end_controls_section();

	}

}