<?php

/**
 * WooCommerce - Recently Viewed Products - Include Class
 */


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if( !class_exists( 'Windoor_Shop_Others_Recently_Viewed_Products_Include' ) ) {

    class Windoor_Shop_Others_Recently_Viewed_Products_Include {

        private static $_instance = null;

        public static function instance() {

            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;

        }

        function __construct() {

			add_action( 'windoor_hook_bottom', array( $this, 'windoor_shop_recently_viewed_products_content' ) );
			add_action( 'wp', array( $this, 'windoor_shop_set_recently_viewed_products' ) );

		}

		/**
         * Recently Viewed Products Content
         */
			function windoor_shop_recently_viewed_products_content() {

				$settings = windoor_woo_others()->woo_default_settings();
				extract($settings);

				if($enable_recently_viewed_products) {

					$viewed_products = (isset($_COOKIE['wdt_shop_recently_viewed']) && !empty($_COOKIE['wdt_shop_recently_viewed'])) ? explode(',', $_COOKIE['wdt_shop_recently_viewed']) : array ();
					$viewed_products = array_reverse(array_filter($viewed_products));

					if(!empty($viewed_products)) {

						$query_args = array(
							'posts_per_page' => 10,
							'no_found_rows'  => 1,
							'post_status'    => 'publish',
							'post_type'      => 'product',
							'post__in'       => $viewed_products,
							'orderby'        => 'post__in',
						);

						if ( 'yes' === get_option( 'woocommerce_hide_out_of_stock_items' ) ) {
							$query_args['tax_query'] = array(
								array(
									'taxonomy' => 'product_visibility',
									'field'    => 'name',
									'terms'    => 'outofstock',
									'operator' => 'NOT IN',
								),
							);
						}

						$products = new WP_Query( $query_args );

						if ( $products->have_posts() ) {

							echo '<div class="wdt-shop-recently-viewed-products-holder">';

								echo '<div class="wdt-shop-recently-viewed-products-toggle-icon">';
									echo '<span class="open">';
										echo '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="548px" height="547.999px" viewBox="0 0 548 547.999" style="enable-background:new 0 0 548 547.999;" xml:space="preserve"><g><path d="M409.545,185.969l-179.165-7.724c-5.12-0.247-9.439,3.748-9.658,8.86c-0.219,5.115,3.748,9.439,8.855,9.659l167.04,7.204
											l-32.842,102.468H217.621l-26.404-143.769c-0.579-3.155-2.749-5.783-5.727-6.954l-43.245-16.99
											c-4.77-1.862-10.142,0.474-12.016,5.239c-1.869,4.765,0.474,10.146,5.239,12.015l38.447,15.105L200.79,317.38
											c0.807,4.396,4.639,7.594,9.112,7.594h4.459l-10.179,28.273c-0.852,2.366-0.501,4.998,0.945,7.061
											c1.449,2.054,3.804,3.281,6.319,3.281h7.138c-4.424,4.924-7.138,11.411-7.138,18.533c0,15.331,12.473,27.797,27.799,27.797
											c15.332,0,27.804-12.471,27.804-27.797c0-7.122-2.719-13.609-7.141-18.533h60.616c-4.425,4.924-7.141,11.411-7.141,18.533
											c0,15.331,12.47,27.797,27.797,27.797s27.802-12.471,27.802-27.797c0-7.122-2.721-13.609-7.141-18.533h8.695
											c4.266,0,7.719-3.458,7.719-7.724c0-4.267-3.458-7.72-7.719-7.72H222.438l8.34-23.167h139.761c4.027,0,7.593-2.6,8.82-6.44
											l38.615-120.474c0.887-2.751,0.43-5.757-1.223-8.128C415.099,187.556,412.434,186.093,409.545,185.969z M341.192,369.764
											c6.813,0,12.349,5.544,12.349,12.354s-5.545,12.354-12.349,12.354c-6.814,0-12.358-5.544-12.358-12.354
											C328.833,375.304,334.373,369.764,341.192,369.764z M239.251,369.764c6.814,0,12.358,5.544,12.358,12.354
											s-5.544,12.354-12.358,12.354c-6.81,0-12.354-5.544-12.354-12.354C226.897,375.304,232.437,369.764,239.251,369.764z
											 M385.211,63.391l13.497-23.38c2.487-4.31,7.999-5.778,12.288-3.292c4.308,2.485,5.778,7.985,3.291,12.291l-13.488,23.379
											c-1.671,2.887-4.695,4.501-7.804,4.501c-1.525,0-3.08-0.387-4.489-1.204C384.204,73.196,382.728,67.696,385.211,63.391z
											 M472.323,159.502c-2.488-4.3-1.013-9.805,3.29-12.293l23.382-13.495c4.294-2.485,9.811-1.018,12.293,3.292
											c2.483,4.301,1.009,9.808-3.295,12.293l-23.382,13.495c-1.419,0.821-2.959,1.208-4.49,1.208
											C477.013,164.003,473.989,162.389,472.323,159.502z M548,274.004c0,4.971-4.033,8.999-9.003,8.999h-26.995
											c-4.961,0-8.998-4.028-8.998-8.999c0-4.97,4.037-8.998,8.998-8.998h26.995C543.966,265.006,548,269.034,548,274.004z
											 M511.288,411.002c-1.671,2.884-4.694,4.499-7.803,4.499c-1.526,0-3.076-0.393-4.49-1.204L475.613,400.8
											c-4.303-2.492-5.778-7.99-3.29-12.293c2.478-4.304,7.999-5.778,12.288-3.295l23.382,13.497
											C512.296,401.191,513.771,406.698,511.288,411.002z M414.288,498.999c2.487,4.299,1.017,9.806-3.291,12.289
											c-1.414,0.821-2.963,1.213-4.494,1.213c-3.099,0-6.133-1.614-7.799-4.503l-13.492-23.378c-2.487-4.303-1.018-9.811,3.285-12.293
											c4.304-2.482,9.811-1.022,12.294,3.285L414.288,498.999z M282.993,512.002l0.01,26.994c0,4.971-4.028,9.003-9.003,9.003
											c-4.966,0-8.998-4.027-8.998-8.998l-0.005-26.994c0-4.966,4.023-9.003,8.998-9.003
											C278.965,503.004,282.993,507.031,282.993,512.002z M162.786,484.611L149.3,507.998c-1.668,2.889-4.695,4.503-7.81,4.503
											c-1.524,0-3.073-0.392-4.483-1.213c-4.305-2.483-5.783-7.98-3.297-12.289l13.49-23.387c2.49-4.308,8.006-5.768,12.298-3.295
											C163.793,474.801,165.275,480.308,162.786,484.611z M75.677,388.497c2.49,4.303,1.017,9.811-3.288,12.293l-23.384,13.507
											c-1.414,0.812-2.964,1.204-4.487,1.204c-3.111,0-6.13-1.615-7.804-4.499c-2.485-4.304-1.013-9.811,3.293-12.293l23.379-13.497
											C67.691,382.72,73.191,384.194,75.677,388.497z M36.002,283.003H9.003c-4.968,0-9.003-4.028-9.003-8.999
											c0-4.97,4.028-8.998,9.003-8.998l26.999-0.005c4.97,0,8.998,4.028,8.998,8.999C45,278.97,40.972,283.003,36.002,283.003z
											 M75.686,159.502c-1.673,2.887-4.693,4.497-7.808,4.497c-1.526,0-3.073-0.388-4.487-1.204L40.001,149.3
											c-4.301-2.492-5.778-7.992-3.292-12.298c2.49-4.296,7.99-5.777,12.295-3.292l23.384,13.495
											C76.694,149.685,78.167,155.197,75.686,159.502z M133.709,49.004c-2.49-4.301-1.013-9.81,3.288-12.291
											c4.305-2.485,9.817-1.013,12.291,3.288l13.506,23.385c2.485,4.305,1.013,9.81-3.292,12.291c-1.418,0.821-2.963,1.213-4.492,1.213
											c-3.102,0-6.133-1.615-7.799-4.501L133.709,49.004z M265.001,35.997V8.998C265.001,4.028,269.034,0,274,0
											c4.971,0,9.003,4.028,9.003,8.998v26.999c0,4.975-4.032,9.003-9.003,9.003C269.034,45,265.001,40.972,265.001,35.997z"/></g>
									<g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg>';
									echo '</span>';
									echo '<span class="close">';
										echo '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
										width="446.853px" height="446.853px" viewBox="0 0 446.853 446.853" style="enable-background:new 0 0 446.853 446.853;"
										xml:space="preserve"><g><path d="M444.274,93.36c-2.558-3.666-6.674-5.932-11.145-6.123L155.942,75.289c-7.953-0.348-14.599,5.792-14.939,13.708
										   c-0.338,7.913,5.792,14.599,13.707,14.939l258.421,11.14L362.32,273.61H136.205L95.354,51.179
										   c-0.898-4.875-4.245-8.942-8.861-10.753L19.586,14.141c-7.374-2.887-15.695,0.735-18.591,8.1c-2.891,7.369,0.73,15.695,8.1,18.591
										   l59.491,23.371l41.572,226.335c1.253,6.804,7.183,11.746,14.104,11.746h6.896l-15.747,43.74c-1.318,3.664-0.775,7.733,1.468,10.916
										   c2.24,3.184,5.883,5.078,9.772,5.078h11.045c-6.844,7.617-11.045,17.646-11.045,28.675c0,23.718,19.299,43.012,43.012,43.012
										   s43.012-19.294,43.012-43.012c0-11.028-4.201-21.058-11.044-28.675h93.777c-6.847,7.617-11.047,17.646-11.047,28.675
										   c0,23.718,19.294,43.012,43.012,43.012c23.719,0,43.012-19.294,43.012-43.012c0-11.028-4.2-21.058-11.042-28.675h13.432
										   c6.6,0,11.948-5.349,11.948-11.947c0-6.6-5.349-11.948-11.948-11.948H143.651l12.902-35.843h216.221
										   c6.235,0,11.752-4.028,13.651-9.96l59.739-186.387C447.536,101.679,446.832,97.028,444.274,93.36z M169.664,409.814
										   c-10.543,0-19.117-8.573-19.117-19.116s8.574-19.117,19.117-19.117s19.116,8.574,19.116,19.117S180.207,409.814,169.664,409.814z
											M327.373,409.814c-10.543,0-19.116-8.573-19.116-19.116s8.573-19.117,19.116-19.117s19.116,8.574,19.116,19.117
										   S337.916,409.814,327.373,409.814z"/></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg>';
									echo '</span>';
								echo '</div>';

								echo '<div class="wdt-shop-recently-viewed-products-wrapper">';

									echo '<div class="wdt-shop-recently-viewed-products-title">';
										echo esc_html__('Recently Viewed', 'windoor-pro');
									echo '</div>';

									echo '<div class="wdt-shop-recently-viewed-products-container swiper-container wdt-recently-viewed-products">';

										echo '<div class="swiper-wrapper">';
											while ( $products->have_posts() ) {
												$products->the_post();

												global $product;

												echo '<div class="wdt-shop-recently-viewed-product swiper-slide">';
													echo '<div class="wdt-shop-recently-viewed-product-item">';
														echo '<a href="'.esc_url( $product->get_permalink() ).'">'.$product->get_image( 'thumbnail' ).'</a>';
													echo '</div>';
													echo '<div class="wdt-shop-recently-viewed-product-info">';

														echo '<div class="title"><a href="'.esc_url( $product->get_permalink() ).'">'.$product->get_title().'</a></div>';
														echo '<div class="price">'.$product->get_price_html().'</div>';

														ob_start();
														woocommerce_template_loop_add_to_cart();
														$add_to_cart = ob_get_clean();

														// Add to Cart
														if( !empty($add_to_cart) ) {

															$add_to_cart = str_replace('class="','class="wdt-button too-small ',$add_to_cart);
															echo '<div class="wcct_btn_wrapper wc_btn_inline" data-tooltip="'.esc_attr__('Add To Cart', 'windoor-pro' ).'">'.windoor_html_output($add_to_cart).'</div>';

														}

													echo '</div>';
												echo '</div>';

											}
										echo '</div>';

										echo '<div class="wdt-products-pagination-holder">';
											echo '<div class="wdt-products-bullet-pagination"></div>';
										echo '</div>';

									echo '</div>';

								echo '</div>';

							echo '</div>';

						}

						wp_reset_postdata();

					} else {

						echo '<div class="wdt-shop-recently-viewed-products-holder">';

							echo '<div class="wdt-shop-recently-viewed-products-toggle-icon">';
								echo '<span class="open">';
									echo '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="548px" height="547.999px" viewBox="0 0 548 547.999" style="enable-background:new 0 0 548 547.999;" xml:space="preserve"><g><path d="M409.545,185.969l-179.165-7.724c-5.12-0.247-9.439,3.748-9.658,8.86c-0.219,5.115,3.748,9.439,8.855,9.659l167.04,7.204
										l-32.842,102.468H217.621l-26.404-143.769c-0.579-3.155-2.749-5.783-5.727-6.954l-43.245-16.99
										c-4.77-1.862-10.142,0.474-12.016,5.239c-1.869,4.765,0.474,10.146,5.239,12.015l38.447,15.105L200.79,317.38
										c0.807,4.396,4.639,7.594,9.112,7.594h4.459l-10.179,28.273c-0.852,2.366-0.501,4.998,0.945,7.061
										c1.449,2.054,3.804,3.281,6.319,3.281h7.138c-4.424,4.924-7.138,11.411-7.138,18.533c0,15.331,12.473,27.797,27.799,27.797
										c15.332,0,27.804-12.471,27.804-27.797c0-7.122-2.719-13.609-7.141-18.533h60.616c-4.425,4.924-7.141,11.411-7.141,18.533
										c0,15.331,12.47,27.797,27.797,27.797s27.802-12.471,27.802-27.797c0-7.122-2.721-13.609-7.141-18.533h8.695
										c4.266,0,7.719-3.458,7.719-7.724c0-4.267-3.458-7.72-7.719-7.72H222.438l8.34-23.167h139.761c4.027,0,7.593-2.6,8.82-6.44
										l38.615-120.474c0.887-2.751,0.43-5.757-1.223-8.128C415.099,187.556,412.434,186.093,409.545,185.969z M341.192,369.764
										c6.813,0,12.349,5.544,12.349,12.354s-5.545,12.354-12.349,12.354c-6.814,0-12.358-5.544-12.358-12.354
										C328.833,375.304,334.373,369.764,341.192,369.764z M239.251,369.764c6.814,0,12.358,5.544,12.358,12.354
										s-5.544,12.354-12.358,12.354c-6.81,0-12.354-5.544-12.354-12.354C226.897,375.304,232.437,369.764,239.251,369.764z
										M385.211,63.391l13.497-23.38c2.487-4.31,7.999-5.778,12.288-3.292c4.308,2.485,5.778,7.985,3.291,12.291l-13.488,23.379
										c-1.671,2.887-4.695,4.501-7.804,4.501c-1.525,0-3.08-0.387-4.489-1.204C384.204,73.196,382.728,67.696,385.211,63.391z
										M472.323,159.502c-2.488-4.3-1.013-9.805,3.29-12.293l23.382-13.495c4.294-2.485,9.811-1.018,12.293,3.292
										c2.483,4.301,1.009,9.808-3.295,12.293l-23.382,13.495c-1.419,0.821-2.959,1.208-4.49,1.208
										C477.013,164.003,473.989,162.389,472.323,159.502z M548,274.004c0,4.971-4.033,8.999-9.003,8.999h-26.995
										c-4.961,0-8.998-4.028-8.998-8.999c0-4.97,4.037-8.998,8.998-8.998h26.995C543.966,265.006,548,269.034,548,274.004z
										M511.288,411.002c-1.671,2.884-4.694,4.499-7.803,4.499c-1.526,0-3.076-0.393-4.49-1.204L475.613,400.8
										c-4.303-2.492-5.778-7.99-3.29-12.293c2.478-4.304,7.999-5.778,12.288-3.295l23.382,13.497
										C512.296,401.191,513.771,406.698,511.288,411.002z M414.288,498.999c2.487,4.299,1.017,9.806-3.291,12.289
										c-1.414,0.821-2.963,1.213-4.494,1.213c-3.099,0-6.133-1.614-7.799-4.503l-13.492-23.378c-2.487-4.303-1.018-9.811,3.285-12.293
										c4.304-2.482,9.811-1.022,12.294,3.285L414.288,498.999z M282.993,512.002l0.01,26.994c0,4.971-4.028,9.003-9.003,9.003
										c-4.966,0-8.998-4.027-8.998-8.998l-0.005-26.994c0-4.966,4.023-9.003,8.998-9.003
										C278.965,503.004,282.993,507.031,282.993,512.002z M162.786,484.611L149.3,507.998c-1.668,2.889-4.695,4.503-7.81,4.503
										c-1.524,0-3.073-0.392-4.483-1.213c-4.305-2.483-5.783-7.98-3.297-12.289l13.49-23.387c2.49-4.308,8.006-5.768,12.298-3.295
										C163.793,474.801,165.275,480.308,162.786,484.611z M75.677,388.497c2.49,4.303,1.017,9.811-3.288,12.293l-23.384,13.507
										c-1.414,0.812-2.964,1.204-4.487,1.204c-3.111,0-6.13-1.615-7.804-4.499c-2.485-4.304-1.013-9.811,3.293-12.293l23.379-13.497
										C67.691,382.72,73.191,384.194,75.677,388.497z M36.002,283.003H9.003c-4.968,0-9.003-4.028-9.003-8.999
										c0-4.97,4.028-8.998,9.003-8.998l26.999-0.005c4.97,0,8.998,4.028,8.998,8.999C45,278.97,40.972,283.003,36.002,283.003z
										M75.686,159.502c-1.673,2.887-4.693,4.497-7.808,4.497c-1.526,0-3.073-0.388-4.487-1.204L40.001,149.3
										c-4.301-2.492-5.778-7.992-3.292-12.298c2.49-4.296,7.99-5.777,12.295-3.292l23.384,13.495
										C76.694,149.685,78.167,155.197,75.686,159.502z M133.709,49.004c-2.49-4.301-1.013-9.81,3.288-12.291
										c4.305-2.485,9.817-1.013,12.291,3.288l13.506,23.385c2.485,4.305,1.013,9.81-3.292,12.291c-1.418,0.821-2.963,1.213-4.492,1.213
										c-3.102,0-6.133-1.615-7.799-4.501L133.709,49.004z M265.001,35.997V8.998C265.001,4.028,269.034,0,274,0
										c4.971,0,9.003,4.028,9.003,8.998v26.999c0,4.975-4.032,9.003-9.003,9.003C269.034,45,265.001,40.972,265.001,35.997z"/></g>
								<g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg>';
								echo '</span>';
								echo '<span class="close">';
									echo '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
									width="446.853px" height="446.853px" viewBox="0 0 446.853 446.853" style="enable-background:new 0 0 446.853 446.853;"
									xml:space="preserve"><g><path d="M444.274,93.36c-2.558-3.666-6.674-5.932-11.145-6.123L155.942,75.289c-7.953-0.348-14.599,5.792-14.939,13.708
									c-0.338,7.913,5.792,14.599,13.707,14.939l258.421,11.14L362.32,273.61H136.205L95.354,51.179
									c-0.898-4.875-4.245-8.942-8.861-10.753L19.586,14.141c-7.374-2.887-15.695,0.735-18.591,8.1c-2.891,7.369,0.73,15.695,8.1,18.591
									l59.491,23.371l41.572,226.335c1.253,6.804,7.183,11.746,14.104,11.746h6.896l-15.747,43.74c-1.318,3.664-0.775,7.733,1.468,10.916
									c2.24,3.184,5.883,5.078,9.772,5.078h11.045c-6.844,7.617-11.045,17.646-11.045,28.675c0,23.718,19.299,43.012,43.012,43.012
									s43.012-19.294,43.012-43.012c0-11.028-4.201-21.058-11.044-28.675h93.777c-6.847,7.617-11.047,17.646-11.047,28.675
									c0,23.718,19.294,43.012,43.012,43.012c23.719,0,43.012-19.294,43.012-43.012c0-11.028-4.2-21.058-11.042-28.675h13.432
									c6.6,0,11.948-5.349,11.948-11.947c0-6.6-5.349-11.948-11.948-11.948H143.651l12.902-35.843h216.221
									c6.235,0,11.752-4.028,13.651-9.96l59.739-186.387C447.536,101.679,446.832,97.028,444.274,93.36z M169.664,409.814
									c-10.543,0-19.117-8.573-19.117-19.116s8.574-19.117,19.117-19.117s19.116,8.574,19.116,19.117S180.207,409.814,169.664,409.814z
										M327.373,409.814c-10.543,0-19.116-8.573-19.116-19.116s8.573-19.117,19.116-19.117s19.116,8.574,19.116,19.117
									S337.916,409.814,327.373,409.814z"/></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg>';
								echo '</span>';
							echo '</div>';

							echo '<div class="wdt-shop-recently-viewed-products-wrapper">';

								echo '<div class="wdt-shop-recently-viewed-products-title">';
									echo esc_html__('Recently Viewed', 'windoor-pro');
								echo '</div>';

								echo '<div class="wdt-shop-recently-viewed-products-container">';
									echo esc_html__('Sorry, there are no products.', 'windoor-pro');
								echo '</div>';

							echo '</div>';

						echo '</div>';

					}

				}


			}


		/**
         * Set Recently Viewed Products
         */
			function windoor_shop_set_recently_viewed_products() {
				if(is_product()) {

					global $post;
					$product_id = $post->ID;

					$wdt_shop_recently_viewed = (isset($_COOKIE['wdt_shop_recently_viewed']) && !empty($_COOKIE['wdt_shop_recently_viewed'])) ? explode(',', $_COOKIE['wdt_shop_recently_viewed']) : array ();

					if(!empty($wdt_shop_recently_viewed)) {
						if(!in_array($product_id, $wdt_shop_recently_viewed)) {
							array_push($wdt_shop_recently_viewed, $product_id);
							setcookie('wdt_shop_recently_viewed', implode(',', $wdt_shop_recently_viewed), time()+1314000, '/' );
						}
					} else {
						array_push($wdt_shop_recently_viewed, $product_id);
						setcookie('wdt_shop_recently_viewed', implode(',', $wdt_shop_recently_viewed), time()+1314000, '/' );
					}

				}
			}


    }

}

if( !function_exists('windoor_shop_others_recently_viewed_products_include') ) {
	function windoor_shop_others_recently_viewed_products_include() {
        $reflection = new ReflectionClass('Windoor_Shop_Others_Recently_Viewed_Products_Include');
        return $reflection->newInstanceWithoutConstructor();
	}
}

Windoor_Shop_Others_Recently_Viewed_Products_Include::instance();