<?php
use WindoorElementor\Widgets\WindoorElementorWidgetBase;
use Elementor\Controls_Manager;
use Elementor\Utils;

class Elementor_Post_Comments extends WindoorElementorWidgetBase {

    public function get_name() {
        return 'wdt-post-comments';
    }

    public function get_title() {
        return esc_html__('Post - Comments', 'windoor-pro');
    }

    protected function register_controls() {

        $this->start_controls_section( 'wdt_section_general', array(
            'label' => esc_html__( 'General', 'windoor-pro'),
        ) );

            $this->add_control( 'style', array(
                'type'    => Controls_Manager::SELECT,
				'label'   => esc_html__('Style', 'windoor-pro'),
                'default' => '',
                'options' => array(
                    ''  => esc_html__('Default', 'windoor-pro'),
                    'meta-elements-space'		 => esc_html__('Space', 'windoor-pro'),
                    'meta-elements-boxed'  		 => esc_html__('Boxed', 'windoor-pro'),
                    'meta-elements-boxed-curvy'  => esc_html__('Curvy', 'windoor-pro'),
                    'meta-elements-boxed-round'  => esc_html__('Round', 'windoor-pro'),
					'meta-elements-filled'  	 => esc_html__('Filled', 'windoor-pro'),
					'meta-elements-filled-curvy' => esc_html__('Filled Curvy', 'windoor-pro'),
					'meta-elements-filled-round' => esc_html__('Filled Round', 'windoor-pro'),
                ),
            ) );

            $this->add_control( 'el_class', array(
                'type'        => Controls_Manager::TEXT,
                'label'       => esc_html__('Extra class name', 'windoor-pro'),
                'description' => esc_html__('Style particular element differently - add a class name and refer to it in custom CSS', 'windoor-pro')
            ) );

        $this->end_controls_section();

    }

    protected function render() {

        $settings = $this->get_settings_for_display();

        extract($settings);

		$out = '';

        global $post;
        $post_id =  $post->ID;

        $Post_Style = windoor_get_single_post_style( $post_id );

		$template_args['post_ID'] = $post_id;
		$template_args['post_Style'] = $Post_Style;
        $template_args = array_merge( $template_args, windoor_single_post_params() );

		$out .= '<div class="entry-comments-wrapper '.$style.' '.$el_class.'">';
            $out .= windoor_get_template_part( 'post', 'templates/'.$Post_Style.'/parts/comment', '', $template_args );
		$out .= '</div>';

		echo $out;
	}

}