<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if( !class_exists( 'Windoor_Shop_Metabox_Single_Upsell_Related' ) ) {
    class Windoor_Shop_Metabox_Single_Upsell_Related {

        private static $_instance = null;

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        function __construct() {

			add_filter( 'windoor_shop_product_custom_settings', array( $this, 'windoor_shop_product_custom_settings' ), 10 );

		}

        function windoor_shop_product_custom_settings( $options ) {

			$ct_dependency      = array ();
			$upsell_dependency  = array ( 'show-upsell', '==', 'true');
			$related_dependency = array ( 'show-related', '==', 'true');
			if( function_exists('windoor_shop_single_module_custom_template') ) {
				$ct_dependency['dependency'] 	= array ( 'product-template', '!=', 'custom-template');
				$upsell_dependency 				= array ( 'product-template|show-upsell', '!=|==', 'custom-template|true');
				$related_dependency 			= array ( 'product-template|show-related', '!=|==', 'custom-template|true');
			}

			$product_options = array (

				array_merge (
					array(
						'id'         => 'show-upsell',
						'type'       => 'select',
						'title'      => esc_html__('Show Upsell Products', 'windoor'),
						'class'      => 'chosen',
						'default'    => 'admin-option',
						'attributes' => array( 'data-depend-id' => 'show-upsell' ),
						'options'    => array(
							'admin-option' => esc_html__( 'Admin Option', 'windoor' ),
							'true'         => esc_html__( 'Show', 'windoor'),
							null           => esc_html__( 'Hide', 'windoor'),
						)
					),
					$ct_dependency
				),

				array(
					'id'         => 'upsell-column',
					'type'       => 'select',
					'title'      => esc_html__('Choose Upsell Column', 'windoor'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'windoor' ),
						1              => esc_html__( 'One Column', 'windoor' ),
						2              => esc_html__( 'Two Columns', 'windoor' ),
						3              => esc_html__( 'Three Columns', 'windoor' ),
						4              => esc_html__( 'Four Columns', 'windoor' ),
					),
					'dependency' => $upsell_dependency
				),

				array(
					'id'         => 'upsell-limit',
					'type'       => 'select',
					'title'      => esc_html__('Choose Upsell Limit', 'windoor'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'windoor' ),
						1              => esc_html__( 'One', 'windoor' ),
						2              => esc_html__( 'Two', 'windoor' ),
						3              => esc_html__( 'Three', 'windoor' ),
						4              => esc_html__( 'Four', 'windoor' ),
						5              => esc_html__( 'Five', 'windoor' ),
						6              => esc_html__( 'Six', 'windoor' ),
						7              => esc_html__( 'Seven', 'windoor' ),
						8              => esc_html__( 'Eight', 'windoor' ),
						9              => esc_html__( 'Nine', 'windoor' ),
						10              => esc_html__( 'Ten', 'windoor' ),
					),
					'dependency' => $upsell_dependency
				),

				array_merge (
					array(
						'id'         => 'show-related',
						'type'       => 'select',
						'title'      => esc_html__('Show Related Products', 'windoor'),
						'class'      => 'chosen',
						'default'    => 'admin-option',
						'attributes' => array( 'data-depend-id' => 'show-related' ),
						'options'    => array(
							'admin-option' => esc_html__( 'Admin Option', 'windoor' ),
							'true'         => esc_html__( 'Show', 'windoor'),
							null           => esc_html__( 'Hide', 'windoor'),
						)
					),
					$ct_dependency
				),

				array(
					'id'         => 'related-column',
					'type'       => 'select',
					'title'      => esc_html__('Choose Related Column', 'windoor'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'windoor' ),
						2              => esc_html__( 'Two Columns', 'windoor' ),
						3              => esc_html__( 'Three Columns', 'windoor' ),
						4              => esc_html__( 'Four Columns', 'windoor' ),
					),
					'dependency' => $related_dependency
				),

				array(
					'id'         => 'related-limit',
					'type'       => 'select',
					'title'      => esc_html__('Choose Related Limit', 'windoor'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'windoor' ),
						1              => esc_html__( 'One', 'windoor' ),
						2              => esc_html__( 'Two', 'windoor' ),
						3              => esc_html__( 'Three', 'windoor' ),
						4              => esc_html__( 'Four', 'windoor' ),
						5              => esc_html__( 'Five', 'windoor' ),
						6              => esc_html__( 'Six', 'windoor' ),
						7              => esc_html__( 'Seven', 'windoor' ),
						8              => esc_html__( 'Eight', 'windoor' ),
						9              => esc_html__( 'Nine', 'windoor' ),
						10              => esc_html__( 'Ten', 'windoor' ),
					),
					'dependency' => $related_dependency
				)

			);

			$options = array_merge( $options, $product_options );

			return $options;

		}

    }
}

Windoor_Shop_Metabox_Single_Upsell_Related::instance();