<?php
/**
 * Recommends plugins for use with the theme via the TGMA Script
 *
 * @package Windoor WordPress theme
 */

function windoor_tgmpa_plugins_register() {

	// Get array of recommended plugins.

	$plugins_list = array(
        array(
            'name'               => esc_html__('Windoor Plus', 'windoor'),
            'slug'               => 'windoor-plus',
            'source'             => WINDOOR_MODULE_DIR . '/plugins/windoor-plus.zip',
            'required'           => true,
            'version'            => '1.0.0',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'               => esc_html__('Windoor Pro', 'windoor'),
            'slug'               => 'windoor-pro',
            'source'             => WINDOOR_MODULE_DIR . '/plugins/windoor-pro.zip',
            'required'           => true,
            'version'            => '1.0.0',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'               => esc_html__('Windoor Shop', 'windoor'),
            'slug'               => 'windoor-shop',
            'source'             => WINDOOR_MODULE_DIR . '/plugins/windoor-shop.zip',
            'required'           => true,
            'version'            => '1.0.0',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'     => esc_html__('Elementor', 'windoor'),
            'slug'     => 'elementor',
            'required' => true,
        ),
        array(
            'name'               => esc_html__('Windoor WeDesignTech Elementor Addon', 'windoor'),
            'slug'               => 'windoor-wedesigntech-elementor-addon',
            'source'             => WINDOOR_MODULE_DIR . '/plugins/windoor-wedesigntech-elementor-addon.zip',
            'required'           => true,
            'version'            => '1.0.0',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'               => esc_html__('Windoor WeDesignTech Portfolio', 'windoor'),
            'slug'               => 'windoor-wedesigntech-portfolio',
            'source'             => WINDOOR_MODULE_DIR . '/plugins/windoor-wedesigntech-portfolio.zip',
            'required'           => true,
            'version'            => '1.0.0',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'     => esc_html__('Contact Form 7', 'windoor'),
            'slug'     => 'contact-form-7',
            'required' => true,
        ),
        array(
            'name'     => esc_html__('Date Time Picker for Contact Form 7', 'windoor'),
            'slug'     => 'date-time-picker-for-contact-form-7',
            'required' => true,
        ),
        array(
            'name'     => esc_html__('One Click Demo Import', 'windoor'),
            'slug'     => 'one-click-demo-import',
            'required' => true,
        ),
        array(
            'name'     => esc_html__('WooCommerce', 'windoor'),
            'slug'     => 'woocommerce',
            'required' => true,
        ),
         array(
            'name'     => esc_html__('Variation Swatches for WooCommerce', 'windoor'),
            'slug'     => 'woo-variation-swatches',
            'required' => true,
        ),
        array(
            'name'     => esc_html__('TI WooCommerce Wishlist', 'windoor'),
            'slug'     => 'ti-woocommerce-wishlist',
            'required' => true,
        )
	);

    $plugins = apply_filters('windoor_required_plugins_list', $plugins_list);

	// Register notice
	tgmpa( $plugins, array(
		'id'           => 'windoor_theme',
		'domain'       => 'windoor',
		'menu'         => 'install-required-plugins',
		'has_notices'  => true,
		'is_automatic' => true,
		'dismissable'  => true,
	) );

}
add_action( 'tgmpa_register', 'windoor_tgmpa_plugins_register' );